/*
 * Decompiled with CFR 0.152.
 */
package com.workshopcraft.simplebarrels.api;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.workshopcraft.simplebarrels.SimpleBarrels;
import com.workshopcraft.simplebarrels.api.barrelData;
import com.workshopcraft.simplebarrels.blocks.BlockBarrel;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class barrelFactory {
    List<barrelData> barrelList;

    public barrelFactory() {
        Gson gson = new Gson();
        try {
            JsonElement json = (JsonElement)gson.fromJson((Reader)new InputStreamReader(JsonElement.class.getResourceAsStream("/barrels.json")), JsonElement.class);
            if (json.isJsonObject() && json.getAsJsonObject().has("barrels")) {
                JsonElement marker = json.getAsJsonObject().get("barrels");
                if (marker.isJsonArray()) {
                    JsonArray jarr = marker.getAsJsonArray();
                    Type barrelType = new TypeToken<List<barrelData>>(){}.getType();
                    int jarrSize = jarr.size();
                    String tmpBarrelName = "";
                    String tmpBarrelSourceBlock = "";
                    int tmpBarrelSourceMeta = 0;
                    String tmpBarrelDependancy = "";
                    this.barrelList = new ArrayList<barrelData>();
                    for (int j = 0; j < jarrSize; ++j) {
                        JsonElement bData = jarr.get(j);
                        tmpBarrelName = bData.getAsJsonObject().get("unlocalizedname").getAsString();
                        tmpBarrelSourceBlock = bData.getAsJsonObject().get("sourceblock").getAsString();
                        tmpBarrelSourceMeta = Integer.parseInt(bData.getAsJsonObject().get("sourcemeta").getAsString());
                        tmpBarrelDependancy = bData.getAsJsonObject().get("dependancy").getAsString();
                        this.barrelList.add(new barrelData(tmpBarrelName, tmpBarrelSourceBlock, tmpBarrelSourceMeta, tmpBarrelDependancy));
                    }
                    System.out.println(this.barrelList.size());
                    SimpleBarrels.barrels = new ArrayList<BlockBarrel>();
                    for (int i = 0; i < this.barrelList.size(); ++i) {
                        BlockBarrel bBtmp = new BlockBarrel(this.barrelList.get((int)i).unlocalizedName);
                        if (!this.checkDependancy(this.barrelList.get((int)i).dependancy).booleanValue()) continue;
                        SimpleBarrels.barrels.add(bBtmp);
                    }
                } else {
                    System.out.println("NOT an array of JsonStuffz");
                }
            }
            String string = gson.toJson(json);
        }
        catch (JsonSyntaxException e) {
            System.out.println("JSon SYNTAX ERROR");
        }
        catch (JsonIOException e) {
            System.out.println("JSon IOException");
        }
    }

    public Boolean checkDependancy(String dependancy) {
        if (dependancy.equals("")) {
            return true;
        }
        if (Loader.isModLoaded((String)dependancy)) {
            return true;
        }
        return false;
    }

    public barrelFactory(JsonObject barrelList) {
    }

    public void addBarrel(BlockBarrel barrel, Boolean f, Boolean c, ItemStack plank) {
        ItemStack i = new ItemStack((Block)barrel, 1);
        NBTTagCompound n = new NBTTagCompound();
        n.func_74757_a("frame", f.booleanValue());
        n.func_74757_a("comp", c.booleanValue());
        i.func_77982_d(n);
        if (!f.booleanValue() && !c.booleanValue()) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(i, new Object[]{"WIW", "FCR", "WIW", Character.valueOf('W'), plank, Character.valueOf('C'), "chestWood", Character.valueOf('R'), Items.field_151132_bS, Character.valueOf('F'), Items.field_151160_bD, Character.valueOf('I'), Items.field_151042_j}));
        } else if (f.booleanValue() && !c.booleanValue()) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(i, new Object[]{"WIW", " CR", "WIW", Character.valueOf('W'), plank, Character.valueOf('C'), "chestWood", Character.valueOf('R'), Items.field_151132_bS, Character.valueOf('I'), Items.field_151042_j}));
        } else if (!f.booleanValue() && c.booleanValue()) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(i, new Object[]{"WIW", "FC ", "WIW", Character.valueOf('W'), plank, Character.valueOf('C'), "chestWood", Character.valueOf('F'), Items.field_151160_bD, Character.valueOf('I'), Items.field_151042_j}));
        } else if (f.booleanValue() && c.booleanValue()) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(i, new Object[]{"WIW", " C ", "WIW", Character.valueOf('W'), plank, Character.valueOf('C'), "chestWood", Character.valueOf('I'), Items.field_151042_j}));
        }
    }

    public void init() {
        int i = 0;
        while (i < SimpleBarrels.barrels.size()) {
            BlockBarrel bBtmp = SimpleBarrels.barrels.get(i);
            if (!this.checkDependancy(this.barrelList.get((int)i).dependancy).booleanValue()) continue;
            GameRegistry.register((IForgeRegistryEntry)bBtmp);
            GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)bBtmp), (ResourceLocation)bBtmp.getRegistryName());
            Item mcPlank = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this.barrelList.get((int)i).sourceBlock));
            this.addBarrel(bBtmp, false, false, new ItemStack(mcPlank, 1, this.barrelList.get((int)i).sourceMeta));
            this.addBarrel(bBtmp, true, false, new ItemStack(mcPlank, 1, this.barrelList.get((int)i).sourceMeta));
            this.addBarrel(bBtmp, false, true, new ItemStack(mcPlank, 1, this.barrelList.get((int)i).sourceMeta));
            this.addBarrel(bBtmp, true, true, new ItemStack(mcPlank, 1, this.barrelList.get((int)i).sourceMeta));
            ++i;
        }
    }

    public void clientInit() {
        int i = 0;
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        while (i < SimpleBarrels.barrels.size()) {
            BlockBarrel bBtmp = SimpleBarrels.barrels.get(i);
            if (!this.checkDependancy(this.barrelList.get((int)i).dependancy).booleanValue()) continue;
            renderItem.func_175037_a().func_178086_a(Item.func_150898_a((Block)bBtmp), 0, new ModelResourceLocation("simplebarrels:" + Item.func_150898_a((Block)bBtmp).func_77658_a().substring(5), "inventory"));
            ++i;
        }
    }
}

