/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.Items;

import java.util.List;
import mcjty.lib.tools.ItemStackTools;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.Items.GenericWand;
import romelo333.notenoughwands.ProtectedBlocks;
import romelo333.notenoughwands.network.PacketGetProtectedBlockCount;
import romelo333.notenoughwands.network.PacketGetProtectedBlocks;
import romelo333.notenoughwands.network.PacketHandler;
import romelo333.notenoughwands.network.ReturnProtectedBlockCountHelper;
import romelo333.notenoughwands.network.ReturnProtectedBlocksHelper;
import romelo333.notenoughwands.varia.ContainerToItemRecipe;
import romelo333.notenoughwands.varia.Tools;

public class ProtectionWand
extends GenericWand {
    public static final int MODE_FIRST = 0;
    public static final int MODE_PROTECT = 0;
    public static final int MODE_UNPROTECT = 1;
    public static final int MODE_CLEAR = 2;
    public static final int MODE_LAST = 2;
    public int blockShowRadius = 10;
    public int maximumProtectedBlocks = 16;
    private final boolean master;
    public static final String[] descriptions = new String[]{"protect", "unprotect", "clear all"};
    private static long tooltipLastTime = 0L;
    private static long lastTime = 0L;

    public ProtectionWand(boolean master) {
        if (master) {
            this.setup("master_protection_wand").xpUsage(0).availability(AVAILABILITY_CREATIVE).loot(0);
        } else {
            this.setup("protection_wand").xpUsage(50).availability(AVAILABILITY_ADVANCED).loot(1);
        }
        this.master = master;
    }

    @Override
    public void initConfig(Configuration cfg) {
        super.initConfig(cfg, 200, 100000, 100, 200000, 50, 500000);
        this.blockShowRadius = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_blockShowRadius", this.blockShowRadius, "How far around the player protected blocks will be hilighted").getInt();
        this.maximumProtectedBlocks = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_maximumProtectedBlocks", this.master ? 0 : this.maximumProtectedBlocks, "The maximum number of blocks to protect with this wand (set to 0 for no maximum)").getInt();
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        boolean hasid = stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("id");
        int mode = this.getMode(stack);
        int id = this.getId(stack);
        if (hasid && id != 0 && System.currentTimeMillis() - tooltipLastTime > 250L) {
            tooltipLastTime = System.currentTimeMillis();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetProtectedBlockCount(id));
        }
        list.add(TextFormatting.GREEN + "Mode: " + descriptions[mode]);
        if (this.master) {
            list.add(TextFormatting.YELLOW + "Master wand");
        } else if (id != 0) {
            list.add(TextFormatting.GREEN + "Id: " + id);
        }
        if (hasid) {
            list.add(TextFormatting.GREEN + "Number of protected blocks: " + ReturnProtectedBlockCountHelper.count);
        }
        list.add("Right click to protect or unprotect a block.");
        this.showModeKeyDescription(list, "switch mode");
    }

    @Override
    public void toggleMode(EntityPlayer player, ItemStack stack) {
        int mode = this.getMode(stack);
        if (++mode > 2) {
            mode = 0;
        }
        Tools.notify(player, "Switched to " + descriptions[mode] + " mode");
        Tools.getTagCompound(stack).func_74768_a("mode", mode);
    }

    private int getMode(ItemStack stack) {
        return Tools.getTagCompound(stack).func_74762_e("mode");
    }

    public int getId(ItemStack stack) {
        if (this.master) {
            return -1;
        }
        return Tools.getTagCompound(stack).func_74762_e("id");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOverlay(RenderWorldLastEvent evt, EntityPlayerSP player, ItemStack wand) {
        if (System.currentTimeMillis() - lastTime > 250L) {
            lastTime = System.currentTimeMillis();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetProtectedBlocks());
        }
        if (this.master) {
            ProtectionWand.renderOutlines(evt, player, ReturnProtectedBlocksHelper.childBlocks, 30, 30, 200);
        }
        ProtectionWand.renderOutlines(evt, player, ReturnProtectedBlocksHelper.blocks, 210, 60, 40);
    }

    protected EnumActionResult clOnItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
            int id = this.getOrCreateId(stack, world, protectedBlocks);
            int mode = this.getMode(stack);
            if (mode == 0) {
                if (!this.checkUsage(stack, player, 1.0f)) {
                    return EnumActionResult.FAIL;
                }
                if (!protectedBlocks.protect(player, world, pos, id)) {
                    return EnumActionResult.FAIL;
                }
                this.registerUsage(stack, player, 1.0f);
            } else if (mode == 1) {
                if (!protectedBlocks.unprotect(player, world, pos, id)) {
                    return EnumActionResult.FAIL;
                }
            } else {
                int cnt = protectedBlocks.clearProtections(world, id);
                Tools.notify(player, "Cleared " + cnt + " protected blocks");
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private int getOrCreateId(ItemStack stack, World world, ProtectedBlocks protectedBlocks) {
        int id = this.getId(stack);
        if (id == 0) {
            id = protectedBlocks.getNewId(world);
            Tools.getTagCompound(stack).func_74768_a("id", id);
        }
        return id;
    }

    @Override
    protected void setupCraftingInt(Item wandcore) {
        if (this.master) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"re ", "ew ", "  w", Character.valueOf('r'), Items.field_151132_bS, Character.valueOf('e'), Items.field_151156_bN, Character.valueOf('w'), wandcore});
        } else {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"re ", "ew ", "  w", Character.valueOf('r'), Items.field_151132_bS, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('w'), wandcore});
            GameRegistry.addRecipe((IRecipe)new ContainerToItemRecipe(new ItemStack[]{new ItemStack((Item)this), new ItemStack(Items.field_151061_bv), ItemStackTools.getEmptyStack(), new ItemStack(Items.field_151061_bv), new ItemStack(wandcore), ItemStackTools.getEmptyStack(), ItemStackTools.getEmptyStack(), ItemStackTools.getEmptyStack(), new ItemStack(wandcore)}, 0, new ItemStack((Item)this)));
        }
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.master;
    }

    public Item func_77668_q() {
        return this;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (this.hasContainerItem(stack) && stack.func_77942_o()) {
            ItemStack container = new ItemStack(this.func_77668_q());
            container.func_77982_d(stack.func_77978_p().func_74737_b());
            return container;
        }
        return ItemStackTools.getEmptyStack();
    }
}

