/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.Items;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import romelo333.notenoughwands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class BuildingWand
extends GenericWand {
    public static final int MODE_FIRST = 0;
    public static final int MODE_9 = 0;
    public static final int MODE_9ROW = 1;
    public static final int MODE_25 = 2;
    public static final int MODE_25ROW = 3;
    public static final int MODE_SINGLE = 4;
    public static final int MODE_LAST = 4;
    public static final String[] descriptions = new String[]{"9 blocks", "9 blocks row", "25 blocks", "25 blocks row", "single"};
    public static final int[] amount = new int[]{9, 9, 25, 25, 1};

    public BuildingWand() {
        this.setup("building_wand").xpUsage(1).availability(AVAILABILITY_NORMAL).loot(3);
    }

    @Override
    protected void initConfig(Configuration cfg) {
        super.initConfig(cfg, 2000, 100000, 500, 200000, 200, 500000);
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            int cnt = (compound.func_74764_b("undo1") ? 1 : 0) + (compound.func_74764_b("undo2") ? 1 : 0);
            list.add(TextFormatting.GREEN + "Has " + cnt + " undo states");
            int mode = compound.func_74762_e("mode");
            if (mode == 1 || mode == 3) {
                int submode = this.getSubMode(stack);
                list.add(TextFormatting.GREEN + "Mode: " + descriptions[mode] + (submode == 1 ? " [Rotated]" : ""));
            } else {
                list.add(TextFormatting.GREEN + "Mode: " + descriptions[mode]);
            }
        }
        list.add("Right click to extend blocks in that direction.");
        list.add("Sneak right click on such a block to undo one of");
        list.add("the last two operations.");
        this.showModeKeyDescription(list, "switch mode");
        this.showSubModeKeyDescription(list, "change orientation");
    }

    @Override
    public void toggleMode(EntityPlayer player, ItemStack stack) {
        int mode = this.getMode(stack);
        if (++mode > 4) {
            mode = 0;
        }
        Tools.notify(player, "Switched to " + descriptions[mode] + " mode");
        Tools.getTagCompound(stack).func_74768_a("mode", mode);
    }

    @Override
    public void toggleSubMode(EntityPlayer player, ItemStack stack) {
        int submode = this.getSubMode(stack);
        submode = submode == 1 ? 0 : 1;
        Tools.notify(player, "Switched orientation");
        Tools.getTagCompound(stack).func_74768_a("submode", submode);
    }

    private int getMode(ItemStack stack) {
        return Tools.getTagCompound(stack).func_74762_e("mode");
    }

    private int getSubMode(ItemStack stack) {
        return Tools.getTagCompound(stack).func_74762_e("submode");
    }

    protected EnumActionResult clOnItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                this.undoPlaceBlock(stack, player, world, pos);
            } else {
                this.placeBlock(stack, player, world, pos, side);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private void placeBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        boolean notenough = false;
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        int meta = block.func_176201_c(blockState);
        Set<BlockPos> coordinates = this.findSuitableBlocks(stack, world, side, pos, block, meta);
        HashSet<BlockPos> undo = new HashSet<BlockPos>();
        for (BlockPos coordinate : coordinates) {
            if (!this.checkUsage(stack, player, 1.0f)) break;
            if (Tools.consumeInventoryItem(Item.func_150898_a((Block)block), meta, player.field_71071_by, player)) {
                Tools.playSound(world, block.func_185467_w().func_185844_d(), (double)coordinate.func_177958_n(), (double)coordinate.func_177956_o(), (double)coordinate.func_177952_p(), 1.0, 1.0);
                IBlockState state = block.func_176203_a(meta);
                world.func_180501_a(coordinate, state, 2);
                player.field_71070_bA.func_75142_b();
                this.registerUsage(stack, player, 1.0f);
                undo.add(coordinate);
                continue;
            }
            notenough = true;
        }
        if (notenough) {
            Tools.error(player, "You don't have the right block");
        }
        this.registerUndo(stack, block, meta, world, undo);
    }

    private void registerUndo(ItemStack stack, Block block, int meta, World world, Set<BlockPos> undo) {
        NBTTagCompound undoTag = new NBTTagCompound();
        undoTag.func_74768_a("block", Block.field_149771_c.func_148757_b((Object)block));
        undoTag.func_74768_a("meta", meta);
        undoTag.func_74768_a("dimension", world.field_73011_w.getDimension());
        int[] undoX = new int[undo.size()];
        int[] undoY = new int[undo.size()];
        int[] undoZ = new int[undo.size()];
        int idx = 0;
        for (BlockPos coordinate : undo) {
            undoX[idx] = coordinate.func_177958_n();
            undoY[idx] = coordinate.func_177956_o();
            undoZ[idx] = coordinate.func_177952_p();
            ++idx;
        }
        undoTag.func_74783_a("x", undoX);
        undoTag.func_74783_a("y", undoY);
        undoTag.func_74783_a("z", undoZ);
        NBTTagCompound wandTag = Tools.getTagCompound(stack);
        if (wandTag.func_74764_b("undo1")) {
            wandTag.func_74782_a("undo2", wandTag.func_74781_a("undo1"));
        }
        wandTag.func_74782_a("undo1", (NBTBase)undoTag);
    }

    private void undoPlaceBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        NBTTagCompound wandTag = Tools.getTagCompound(stack);
        NBTTagCompound undoTag1 = (NBTTagCompound)wandTag.func_74781_a("undo1");
        NBTTagCompound undoTag2 = (NBTTagCompound)wandTag.func_74781_a("undo2");
        Set<BlockPos> undo1 = this.checkUndo(player, world, undoTag1);
        Set<BlockPos> undo2 = this.checkUndo(player, world, undoTag2);
        if (undo1 == null && undo2 == null) {
            Tools.error(player, "Nothing to undo!");
            return;
        }
        if (undo1 != null && undo1.contains(pos)) {
            this.performUndo(stack, player, world, pos, undoTag1, undo1);
            if (wandTag.func_74764_b("undo2")) {
                wandTag.func_74782_a("undo1", wandTag.func_74781_a("undo2"));
                wandTag.func_82580_o("undo2");
            } else {
                wandTag.func_82580_o("undo1");
            }
            return;
        }
        if (undo2 != null && undo2.contains(pos)) {
            this.performUndo(stack, player, world, pos, undoTag2, undo2);
            wandTag.func_82580_o("undo2");
            return;
        }
        Tools.error(player, "Select at least one block of the area you want to undo!");
    }

    private void performUndo(ItemStack stack, EntityPlayer player, World world, BlockPos pos, NBTTagCompound undoTag, Set<BlockPos> undo) {
        Block block = (Block)Block.field_149771_c.func_148754_a(undoTag.func_74762_e("block"));
        int meta = undoTag.func_74762_e("meta");
        int cnt = 0;
        for (BlockPos coordinate : undo) {
            IBlockState testState = world.func_180495_p(coordinate);
            Block testBlock = testState.func_177230_c();
            int testMeta = testBlock.func_176201_c(testState);
            if (testBlock != block || testMeta != meta) continue;
            Tools.playSound(world, block.func_185467_w().func_185844_d(), (double)coordinate.func_177958_n(), (double)coordinate.func_177956_o(), (double)coordinate.func_177952_p(), 1.0, 1.0);
            world.func_175698_g(coordinate);
            ++cnt;
        }
        if (cnt > 0 && !player.field_71075_bZ.field_75098_d) {
            Tools.giveItem(world, player, block, meta, cnt, pos);
            player.field_71070_bA.func_75142_b();
        }
    }

    private Set<BlockPos> checkUndo(EntityPlayer player, World world, NBTTagCompound undoTag) {
        if (undoTag == null) {
            return null;
        }
        int dimension = undoTag.func_74762_e("dimension");
        if (dimension != world.field_73011_w.getDimension()) {
            Tools.error(player, "Select at least one block of the area you want to undo!");
            return null;
        }
        int[] undoX = undoTag.func_74759_k("x");
        int[] undoY = undoTag.func_74759_k("y");
        int[] undoZ = undoTag.func_74759_k("z");
        HashSet<BlockPos> undo = new HashSet<BlockPos>();
        for (int i = 0; i < undoX.length; ++i) {
            undo.add(new BlockPos(undoX[i], undoY[i], undoZ[i]));
        }
        return undo;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOverlay(RenderWorldLastEvent evt, EntityPlayerSP player, ItemStack wand) {
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver != null && mouseOver.field_178784_b != null && mouseOver.func_178782_a() != null) {
            World world = player.func_130014_f_();
            BlockPos blockPos = mouseOver.func_178782_a();
            if (blockPos == null) {
                return;
            }
            IBlockState blockState = world.func_180495_p(blockPos);
            Block block = blockState.func_177230_c();
            if (block != null && block.func_149688_o(blockState) != Material.field_151579_a) {
                int meta = block.func_176201_c(blockState);
                if (player.func_70093_af()) {
                    NBTTagCompound wandTag = Tools.getTagCompound(wand);
                    NBTTagCompound undoTag1 = (NBTTagCompound)wandTag.func_74781_a("undo1");
                    NBTTagCompound undoTag2 = (NBTTagCompound)wandTag.func_74781_a("undo2");
                    Set<BlockPos> undo1 = this.checkUndo((EntityPlayer)player, world, undoTag1);
                    Set<BlockPos> undo2 = this.checkUndo((EntityPlayer)player, world, undoTag2);
                    if (undo1 == null && undo2 == null) {
                        return;
                    }
                    if (undo1 != null && undo1.contains(blockPos)) {
                        Set<BlockPos> coordinates = undo1;
                        BuildingWand.renderOutlines(evt, player, coordinates, 240, 30, 0);
                    } else if (undo2 != null && undo2.contains(blockPos)) {
                        Set<BlockPos> coordinates = undo2;
                        BuildingWand.renderOutlines(evt, player, coordinates, 240, 30, 0);
                    }
                } else {
                    Set<BlockPos> coordinates = this.findSuitableBlocks(wand, world, mouseOver.field_178784_b, blockPos, block, meta);
                    BuildingWand.renderOutlines(evt, player, coordinates, 50, 250, 180);
                }
            }
        }
    }

    private Set<BlockPos> findSuitableBlocks(ItemStack stack, World world, EnumFacing sideHit, BlockPos pos, Block block, int meta) {
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
        HashSet<BlockPos> done = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> todo = new ArrayDeque<BlockPos>();
        todo.addLast(pos);
        this.findSuitableBlocks(world, coordinates, done, todo, sideHit, block, meta, amount[this.getMode(stack)], this.getMode(stack) == 1 || this.getMode(stack) == 3, this.getSubMode(stack));
        return coordinates;
    }

    private void findSuitableBlocks(World world, Set<BlockPos> coordinates, Set<BlockPos> done, Deque<BlockPos> todo, EnumFacing direction, Block block, int meta, int maxAmount, boolean rowMode, int rotated) {
        BlockPos offset;
        BlockPos base;
        EnumFacing dirA = null;
        EnumFacing dirB = null;
        if (rowMode) {
            base = todo.getFirst();
            offset = base.func_177972_a(direction);
            dirA = rotated == 1 ? this.dir2(direction) : this.dir1(direction);
            dirB = dirA.func_176734_d();
            if (!this.isSuitable(world, block, meta, base.func_177972_a(dirA), offset.func_177972_a(dirA)) || !this.isSuitable(world, block, meta, base.func_177972_a(dirB), offset.func_177972_a(dirB))) {
                dirA = rotated == 1 ? this.dir3(direction) : this.dir2(direction);
                dirB = dirA.func_176734_d();
                if (!this.isSuitable(world, block, meta, base.func_177972_a(dirA), offset.func_177972_a(dirA)) || !this.isSuitable(world, block, meta, base.func_177972_a(dirB), offset.func_177972_a(dirB))) {
                    dirA = rotated == 1 ? this.dir1(direction) : this.dir3(direction);
                    dirB = dirA.func_176734_d();
                }
            }
        }
        while (!todo.isEmpty() && coordinates.size() < maxAmount) {
            base = todo.pollFirst();
            if (done.contains(base)) continue;
            done.add(base);
            offset = base.func_177972_a(direction);
            if (!this.isSuitable(world, block, meta, base, offset)) continue;
            coordinates.add(offset);
            if (rowMode) {
                todo.addLast(base.func_177972_a(dirA));
                todo.addLast(base.func_177972_a(dirB));
                continue;
            }
            todo.addLast(base.func_177972_a(this.dir1(direction)));
            todo.addLast(base.func_177972_a(this.dir1(direction).func_176734_d()));
            todo.addLast(base.func_177972_a(this.dir2(direction)));
            todo.addLast(base.func_177972_a(this.dir2(direction).func_176734_d()));
            todo.addLast(base.func_177972_a(this.dir1(direction)).func_177972_a(this.dir2(direction)));
            todo.addLast(base.func_177972_a(this.dir1(direction)).func_177972_a(this.dir2(direction).func_176734_d()));
            todo.addLast(base.func_177972_a(this.dir1(direction).func_176734_d()).func_177972_a(this.dir2(direction)));
            todo.addLast(base.func_177972_a(this.dir1(direction).func_176734_d()).func_177972_a(this.dir2(direction).func_176734_d()));
        }
    }

    private boolean isSuitable(World world, Block block, int meta, BlockPos base, BlockPos offset) {
        IBlockState baseState;
        IBlockState destState = world.func_180495_p(offset);
        Block destBlock = destState.func_177230_c();
        if (destBlock == null) {
            destBlock = Blocks.field_150350_a;
        }
        return (baseState = world.func_180495_p(base)).func_177230_c() == block && baseState.func_177230_c().func_176201_c(baseState) == meta && destBlock.func_176200_f((IBlockAccess)world, offset);
    }

    private EnumFacing dir1(EnumFacing direction) {
        switch (direction) {
            case DOWN: 
            case UP: {
                return EnumFacing.EAST;
            }
            case NORTH: 
            case SOUTH: {
                return EnumFacing.EAST;
            }
            case WEST: 
            case EAST: {
                return EnumFacing.DOWN;
            }
        }
        return null;
    }

    private EnumFacing dir2(EnumFacing direction) {
        switch (direction) {
            case DOWN: 
            case UP: {
                return EnumFacing.SOUTH;
            }
            case NORTH: 
            case SOUTH: {
                return EnumFacing.DOWN;
            }
            case WEST: 
            case EAST: {
                return EnumFacing.SOUTH;
            }
        }
        return null;
    }

    private EnumFacing dir3(EnumFacing direction) {
        switch (direction) {
            case DOWN: 
            case UP: {
                return EnumFacing.SOUTH;
            }
            case NORTH: 
            case SOUTH: {
                return EnumFacing.WEST;
            }
            case WEST: 
            case EAST: {
                return EnumFacing.SOUTH;
            }
        }
        return null;
    }

    @Override
    protected void setupCraftingInt(Item wandcore) {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"bb ", "bw ", "  w", Character.valueOf('b'), Items.field_151118_aC, Character.valueOf('w'), wandcore});
    }
}

