/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.helper;

import com.google.common.base.Optional;
import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.helper.DragonHelper;
import java.util.UUID;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DragonReproductionHelper
extends DragonHelper {
    private static final Logger L = LogManager.getLogger();
    public static final String NBT_BREEDER = "HatchedByUUID";
    public static final String NBT_REPRO_COUNT = "ReproductionCount";
    public static final String NBT_REPRODUCED = "HasReproduced";
    public static final String NBT_BREEDER_OLD = "HatchedBy";
    public static final byte REPRO_LIMIT = 2;
    private final DataParameter<Optional<UUID>> dataParamBreeder;
    private final DataParameter<Integer> dataParamReproduced;

    public DragonReproductionHelper(EntityTameableDragon dragon, DataParameter<Optional<UUID>> dataParamBreeder, DataParameter<Integer> dataIndexReproCount) {
        super(dragon);
        this.dataParamBreeder = dataParamBreeder;
        this.dataParamReproduced = dataIndexReproCount;
        this.dataWatcher.func_187214_a(dataParamBreeder, (Object)Optional.absent());
        this.dataWatcher.func_187214_a(dataIndexReproCount, (Object)0);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        Optional<UUID> breederID = this.getBreederID();
        if (breederID.isPresent()) {
            nbt.func_186854_a(NBT_BREEDER, (UUID)breederID.get());
        }
        nbt.func_74768_a(NBT_REPRO_COUNT, this.getReproCount());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        int reproCount = 0;
        if (nbt.func_74764_b(NBT_REPRO_COUNT)) {
            reproCount = nbt.func_74762_e(NBT_REPRO_COUNT);
        } else if (nbt.func_74764_b(NBT_REPRODUCED) && nbt.func_74767_n(NBT_REPRODUCED)) {
            ++reproCount;
        }
        if (nbt.func_74764_b(NBT_BREEDER)) {
            this.setBreederID(nbt.func_186857_a(NBT_BREEDER));
        } else if (nbt.func_74764_b(NBT_BREEDER_OLD)) {
            String breederName = nbt.func_74779_i(NBT_BREEDER_OLD);
            EntityPlayer breeder = this.dragon.field_70170_p.func_72924_a(breederName);
            this.setBreeder(breeder);
        }
        this.setReproCount(reproCount);
    }

    public int getReproCount() {
        return (Integer)this.dataWatcher.func_187225_a(this.dataParamReproduced);
    }

    public void setReproCount(int reproCount) {
        L.trace("setReproCount({})", new Object[]{reproCount});
        this.dataWatcher.func_187227_b(this.dataParamReproduced, (Object)reproCount);
    }

    public void addReproduced() {
        this.setReproCount(this.getReproCount() + 1);
    }

    public boolean canReproduce() {
        return this.dragon.func_70909_n() && this.getReproCount() < 2;
    }

    public Optional<UUID> getBreederID() {
        return (Optional)this.dataWatcher.func_187225_a(this.dataParamBreeder);
    }

    public void setBreederID(UUID breederID) {
        L.trace("setBreederUUID({})", new Object[]{breederID});
        this.dataWatcher.func_187227_b(this.dataParamBreeder, (Object)Optional.fromNullable((Object)breederID));
    }

    public EntityPlayer getBreeder() {
        Optional<UUID> breederID = this.getBreederID();
        if (breederID.isPresent()) {
            return this.dragon.field_70170_p.func_152378_a((UUID)breederID.get());
        }
        return null;
    }

    public void setBreeder(EntityPlayer breeder) {
        this.setBreederID(breeder != null ? breeder.func_110124_au() : null);
    }

    public boolean canMateWith(EntityAnimal mate) {
        if (mate == this.dragon) {
            return false;
        }
        if (!(mate instanceof EntityTameableDragon)) {
            return false;
        }
        if (!this.canReproduce()) {
            return false;
        }
        EntityTameableDragon dragonMate = (EntityTameableDragon)mate;
        if (!dragonMate.func_70909_n()) {
            return false;
        }
        if (!dragonMate.getReproductionHelper().canReproduce()) {
            return false;
        }
        return this.dragon.func_70880_s() && dragonMate.func_70880_s();
    }

    public EntityAgeable createChild(EntityAgeable mate) {
        if (!(mate instanceof EntityTameableDragon)) {
            throw new IllegalArgumentException("The mate isn't a dragon");
        }
        EntityTameableDragon parent1 = this.dragon;
        EntityTameableDragon parent2 = (EntityTameableDragon)mate;
        EntityTameableDragon baby = new EntityTameableDragon(this.dragon.field_70170_p);
        if (parent1.func_145818_k_() && parent2.func_145818_k_()) {
            String babyName;
            String p1Name = parent1.func_95999_t();
            String p2Name = parent2.func_95999_t();
            if (p1Name.contains(" ") || p2Name.contains(" ")) {
                String[] p1Names = p1Name.split(" ");
                String[] p2Names = p2Name.split(" ");
                p1Name = this.fixChildName(p1Names[this.rand.nextInt(p1Names.length)]);
                p2Name = this.fixChildName(p2Names[this.rand.nextInt(p2Names.length)]);
                babyName = this.rand.nextBoolean() ? p1Name + " " + p2Name : p2Name + " " + p1Name;
            } else {
                p1Name = this.rand.nextBoolean() ? p1Name.substring(0, (p1Name.length() - 1) / 2) : p1Name.substring((p1Name.length() - 1) / 2);
                p2Name = this.rand.nextBoolean() ? p2Name.substring(0, (p2Name.length() - 1) / 2) : p2Name.substring((p2Name.length() - 1) / 2);
                p2Name = this.fixChildName(p2Name);
                babyName = this.rand.nextBoolean() ? p1Name + p2Name : p2Name + p1Name;
            }
            baby.func_96094_a(babyName);
        }
        baby.getBreedHelper().inheritBreed(parent1, parent2);
        parent1.getReproductionHelper().addReproduced();
        parent2.getReproductionHelper().addReproduced();
        return baby;
    }

    private String fixChildName(String nameOld) {
        if (nameOld == null || nameOld.isEmpty()) {
            return nameOld;
        }
        char[] chars = nameOld.toLowerCase().toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        String nameNew = new String(chars);
        if (!nameOld.equals(nameNew)) {
            L.debug("Fixed child name {} -> {}");
        }
        return nameNew;
    }
}

