/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.translate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import sonar.core.SonarCore;
import sonar.core.helpers.FontHelper;
import sonar.core.translate.ILocalisationHandler;
import sonar.core.translate.Localisation;

public class LocalisationManager
implements IResourceManagerReloadListener {
    public List<ILocalisationHandler> handlers = new ArrayList<ILocalisationHandler>();

    public void clear() {
        this.handlers.clear();
    }

    public void add(ILocalisationHandler handler) {
        this.handlers.add(handler);
        this.loadHandler(handler);
    }

    public void remove(ILocalisationHandler handler) {
        this.handlers.remove(handler);
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.handlers.forEach(handler -> this.loadHandler((ILocalisationHandler)handler));
    }

    public void loadHandler(ILocalisationHandler handler) {
        handler.getLocalisations(Lists.newArrayList()).forEach(l -> LocalisationManager.translate(l));
    }

    public static Localisation translate(Localisation l) {
        l.toDisplay = FontHelper.translate(l.original);
        boolean bl = l.wasFound = !l.toDisplay.equals(l.original);
        if (!l.wasFound) {
            SonarCore.logger.info("NO TRANSLATION FOUND FOR: " + l.o());
        }
        return l;
    }
}

