/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.inventory;

import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.IItemHandler;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.DirtyPart;
import sonar.core.network.sync.ISyncPart;

public class SonarLargeInventory
extends DirtyPart
implements IItemHandler,
INBTSyncable,
ISyncPart {
    public StoredItemStack[] slots;
    public int limit = 64;
    public int numStacks = 4;
    public int size;
    public IItemHandler embeddedHandler = new EmbeddedHandler(this);

    public SonarLargeInventory(int size, int numStacks) {
        this.size = size;
        this.slots = new StoredItemStack[size];
        this.numStacks = numStacks;
    }

    public SonarLargeInventory setStackLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SAVE && nbt.func_74764_b(this.getTagName())) {
            NBTTagList list = nbt.func_150295_c(this.getTagName(), 10);
            StoredItemStack[] stacks = new StoredItemStack[this.size];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                byte b = compound.func_74771_c("Slot");
                if (b < 0 || b >= this.size) continue;
                stacks[b] = NBTHelper.instanceNBTSyncable(StoredItemStack.class, compound);
            }
            this.slots = stacks;
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SAVE) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.size; ++i) {
                StoredItemStack stack = this.slots[i];
                if (stack == null || stack.getStackSize() == 0L) continue;
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74774_a("Slot", (byte)i);
                list.func_74742_a((NBTBase)stack.writeData(compound, type));
            }
            nbt.func_74782_a(this.getTagName(), (NBTBase)list);
        }
        return nbt;
    }

    public ItemStack getStackInSlot(int slot) {
        int target = this.getStackPosition(slot);
        StoredItemStack stack = this.slots[target];
        if (stack == null || stack.getStackSize() == 0L) {
            return null;
        }
        int actualSize = this.getSlotSize(stack, target, slot);
        return actualSize == 0 ? null : stack.copy().setStackSize(actualSize).getActualStack();
    }

    public int getSlotSize(StoredItemStack stack, int target, int slot) {
        int maxStackSize = stack.item.func_77976_d();
        int pos = slot - target * this.numStacks;
        int fullSize = (int)stack.getStackSize();
        int actualSize = fullSize >= pos * maxStackSize ? Math.min(fullSize - pos * maxStackSize, maxStackSize) : Math.min(0, (fullSize - pos) * maxStackSize);
        return actualSize;
    }

    public int getSlots() {
        return this.size * this.numStacks;
    }

    public int getLargeSize() {
        return this.size;
    }

    public int getStackPosition(int slot) {
        return (int)Math.floor(slot / this.numStacks);
    }

    public StoredItemStack getLargeStack(int slot) {
        if (this.size > slot) {
            return this.slots[slot];
        }
        return null;
    }

    public void setLargeStack(int slot, StoredItemStack stack) {
        this.slots[slot] = stack;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int maxAdd;
        StoredItemStack stored;
        int pos = this.getStackPosition(slot);
        if (stack != null && stack.field_77994_a != 0 && this.isItemValidForPos(pos, stack) && ((stored = this.slots[pos]) == null || stored.getStackSize() == 0L || stored.equalStack(stack) && stored.getStackSize() < (long)(this.numStacks * stack.func_77976_d())) && (maxAdd = (int)Math.min((long)(this.numStacks * stack.func_77976_d()) - (stored != null ? stored.getStackSize() : 0L), (long)stack.field_77994_a)) != 0) {
            if (!simulate) {
                if (stored != null && stored.getStackSize() != 0L) {
                    stored.stored += (long)maxAdd;
                } else {
                    stored = this.slots[pos] = new StoredItemStack(stack.func_77946_l(), maxAdd);
                }
            }
            return maxAdd == stack.field_77994_a ? null : new StoredItemStack(stack.func_77946_l()).setStackSize(stack.field_77994_a - maxAdd).getActualStack();
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            int toRemove = Math.min(amount, stack.field_77994_a);
            if (toRemove == 0) {
                return null;
            }
            int target = this.getStackPosition(slot);
            StoredItemStack stored = this.slots[target];
            if (!simulate) {
                stored.stored -= (long)toRemove;
                if (stored.stored == 0L) {
                    this.slots[target] = null;
                }
            }
            return new StoredItemStack(stack.func_77946_l()).setStackSize(toRemove).getActualStack();
        }
        return null;
    }

    public boolean isItemValidForPos(int slot, ItemStack item) {
        return true;
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.readData(ByteBufUtils.readTag((ByteBuf)buf), NBTHelper.SyncType.SAVE);
    }

    @Override
    public boolean canSync(NBTHelper.SyncType sync) {
        return sync == NBTHelper.SyncType.SAVE;
    }

    @Override
    public String getTagName() {
        return "Items";
    }

    public void markDirty() {
        this.markChanged();
    }

    public static class EmbeddedHandler
    implements IItemHandler {
        SonarLargeInventory inv;

        public EmbeddedHandler(SonarLargeInventory inv) {
            this.inv = inv;
        }

        public int getSlots() {
            return this.inv.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.inv.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.inv.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.inv.extractItem(slot, amount, simulate);
        }
    }
}

