/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.integration.multipart;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.Multipart;
import mcmultipart.multipart.PartSlot;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.SonarCore;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.network.PacketRequestMultipartSync;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ISyncableListener;
import sonar.core.network.sync.SyncableList;
import sonar.core.utils.IRemovable;
import sonar.core.utils.IUUIDIdentity;
import sonar.core.utils.IWorldPosition;
import sonar.core.utils.Pair;

public abstract class SonarMultipart
extends Multipart
implements ISyncableListener,
ITickable,
INBTSyncable,
IWorldPosition,
IRemovable {
    public SyncableList syncList = new SyncableList(this);
    public AxisAlignedBB collisionBox = null;
    public boolean wasRemoved = false;
    public boolean isValid = false;
    protected boolean forceSync;
    public boolean isDirty = false;

    public SonarMultipart(AxisAlignedBB collisionBox) {
        this.collisionBox = collisionBox;
    }

    public SonarMultipart() {
    }

    public void func_73660_a() {
        if (!this.isValid && !this.wasRemoved) {
            this.validate();
            this.isValid = true;
        }
        if (this.isDirty) {
            this.markDirty();
            this.isDirty = !this.isDirty;
        }
    }

    public void validate() {
        this.isValid = true;
    }

    public void invalidate() {
        this.isValid = false;
    }

    public void onRemoved() {
        super.onRemoved();
        this.invalidate();
        this.wasRemoved = true;
    }

    public void onUnloaded() {
        super.onUnloaded();
        this.invalidate();
    }

    public UUID getUUID() {
        if (this.getContainer() != null) {
            return this.getContainer().getPartID((IMultipart)this);
        }
        return IUUIDIdentity.INVALID_UUID;
    }

    public void addSelectionBoxes(List<AxisAlignedBB> list) {
        if (this.collisionBox != null) {
            list.add(this.collisionBox);
        }
    }

    public void addCollisionBoxes(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        if (this.collisionBox != null && this.collisionBox.func_72326_a(mask)) {
            list.add(this.collisionBox);
        }
    }

    @Override
    public BlockCoords getCoords() {
        if (this.getContainer() == null) {
            return null;
        }
        return new BlockCoords(this.getContainer().getPosIn(), this.getContainer().getWorldIn());
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound tag) {
        return this.writeData(tag, NBTHelper.SyncType.SAVE);
    }

    public final void readFromNBT(NBTTagCompound tag) {
        this.readData(tag, NBTHelper.SyncType.SAVE);
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTHelper.readSyncParts(nbt, type, this.syncList);
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.forceSync && type == NBTHelper.SyncType.DEFAULT_SYNC) {
            type = NBTHelper.SyncType.SYNC_OVERRIDE;
            this.forceSync = false;
        }
        NBTHelper.writeSyncParts(nbt, type, this.syncList, this.forceSync);
        return nbt;
    }

    public void sendSyncPacket() {
        if (!this.getWorld().field_72995_K) {
            SonarMultipartHelper.sendMultipartSyncAround(this, 64);
        } else {
            SonarMultipartHelper.sendMultipartSyncToServer(this);
        }
    }

    public void sendByteBufPacket(int id) {
        if (!this.getWorld().field_72995_K) {
            SonarMultipartHelper.sendMultipartPacketAround(this, id, 64);
        } else {
            SonarMultipartHelper.sendMultipartPacketToServer(this, id);
        }
    }

    public ItemStack getPickBlock(EntityPlayer player, PartMOP hit) {
        return this.getItemStack();
    }

    public List<ItemStack> getDrops() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.getItemStack()});
    }

    public abstract ItemStack getItemStack();

    public Pair<Boolean, EnumFacing> rotatePart(EnumFacing face, EnumFacing axis) {
        EnumFacing[] valid = this.getValidRotations();
        if (valid != null) {
            int pos = -1;
            for (int i = 0; i < valid.length; ++i) {
                if (valid[i] != face) continue;
                pos = i;
                break;
            }
            if (pos != -1) {
                int current = pos;
                boolean fullCycle = false;
                while (!fullCycle && this.getContainer().getPartInSlot(PartSlot.getFaceSlot((EnumFacing)valid[current])) != null) {
                    if (++current >= valid.length) {
                        current = 0;
                    }
                    if (current != pos) continue;
                    return new Pair<Boolean, EnumFacing>(false, face);
                }
                if (current != -1 && this.isServer()) {
                    face = valid[current];
                    return new Pair<Boolean, EnumFacing>(true, face);
                }
            }
        }
        return new Pair<Boolean, EnumFacing>(false, face);
    }

    public void onSyncPacketRequested(EntityPlayer player) {
    }

    public void requestSyncPacket() {
        SonarCore.network.sendToServer((IMessage)new PacketRequestMultipartSync(this.getPos(), this.getUUID()));
    }

    public void forceNextSync() {
        this.forceSync = true;
    }

    @Override
    public boolean wasRemoved() {
        return this.wasRemoved;
    }

    @Override
    public void markChanged(IDirtyPart part) {
        if (this.isServer()) {
            this.syncList.markSyncPartChanged(part);
            this.isDirty = true;
        }
    }

    public final boolean isClient() {
        if (this.getWorld() == null) {
            return FMLCommonHandler.instance().getEffectiveSide().isClient();
        }
        return this.getWorld().field_72995_K;
    }

    public final boolean isServer() {
        if (this.getWorld() == null) {
            return FMLCommonHandler.instance().getEffectiveSide().isServer();
        }
        World world = this.getWorld();
        return !this.getWorld().field_72995_K;
    }

    public final void openGui(EntityPlayer player, Object mod) {
        player.openGui(mod, this.getUUID().hashCode(), this.getWorld(), this.getPos().func_177958_n(), this.getPos().func_177956_o(), this.getPos().func_177952_p());
    }

    public final void openFlexibleGui(EntityPlayer player, int id) {
        SonarCore.instance.guiHandler.openBasicMultipart(false, this.getUUID(), player, this.getWorld(), this.getPos(), id);
    }

    public final void changeFlexibleGui(EntityPlayer player, int id) {
        SonarCore.instance.guiHandler.openBasicMultipart(true, this.getUUID(), player, this.getWorld(), this.getPos(), id);
    }
}

