/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.energy;

import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import sonar.core.api.energy.StoredEnergyStack;
import sonar.core.api.utils.ActionType;

public class GenericForgeEnergyHandler {
    public static boolean canProvideEnergy(ICapabilityProvider tile, EnumFacing dir) {
        return tile != null && tile.hasCapability(CapabilityEnergy.ENERGY, dir);
    }

    public static StoredEnergyStack getEnergy(StoredEnergyStack energyStack, ICapabilityProvider tile, EnumFacing dir) {
        IEnergyStorage storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, dir);
        if (storage != null) {
            energyStack.setStorageValues(storage.getEnergyStored(), storage.getMaxEnergyStored());
            energyStack.setMaxInput(storage.canReceive() ? (long)storage.receiveEnergy(Integer.MAX_VALUE, true) : 0L);
            energyStack.setMaxOutput(storage.canExtract() ? (long)storage.extractEnergy(Integer.MAX_VALUE, true) : 0L);
        }
        return energyStack;
    }

    public static StoredEnergyStack addEnergy(StoredEnergyStack transfer, ICapabilityProvider tile, EnumFacing dir, ActionType action) {
        int transferRF;
        IEnergyStorage storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, dir);
        if (storage != null && (dir == null || storage.canReceive()) && (transferRF = Math.min(storage.getMaxEnergyStored() - storage.getEnergyStored(), transfer.stored < Integer.MAX_VALUE ? (int)transfer.stored : Integer.MAX_VALUE)) > 0) {
            transfer.stored -= (long)storage.receiveEnergy(transferRF, action.shouldSimulate());
        }
        if (transfer.stored == 0L) {
            transfer = null;
        }
        return transfer;
    }

    public static StoredEnergyStack removeEnergy(StoredEnergyStack transfer, ICapabilityProvider tile, EnumFacing dir, ActionType action) {
        int transferRF;
        IEnergyStorage storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, dir);
        if (storage != null && (dir == null || storage.canExtract()) && (transferRF = Math.min(storage.getEnergyStored(), transfer.stored < Integer.MAX_VALUE ? (int)transfer.stored : Integer.MAX_VALUE)) > 0) {
            transfer.stored -= (long)storage.extractEnergy(transferRF, action.shouldSimulate());
        }
        if (transfer.stored == 0L) {
            transfer = null;
        }
        return transfer;
    }
}

