/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.api.energy;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.core.api.ISonarStack;
import sonar.core.api.SonarAPI;
import sonar.core.api.energy.EnergyType;
import sonar.core.helpers.NBTHelper;

public class StoredEnergyStack
implements ISonarStack<StoredEnergyStack> {
    public long stored;
    public long capacity;
    public long input;
    public long output;
    public long usage;
    public boolean hasStorage;
    public boolean hasInput;
    public boolean hasOutput;
    public boolean hasUsage;
    public EnergyType energyType;

    public StoredEnergyStack() {
    }

    public StoredEnergyStack(EnergyType type) {
        this.energyType = type;
    }

    public void setStorageValues(long stored, long capacity) {
        if (!this.hasStorage) {
            this.stored = stored;
            this.capacity = capacity;
            this.hasStorage = true;
        }
    }

    public void increaseStorageValues(long stored, long capacity) {
        this.stored += stored;
        this.capacity += capacity;
    }

    public void setMaxInput(long input) {
        if (!this.hasInput) {
            this.input = input;
            this.hasInput = true;
        }
    }

    public void increaseMaxInput(long input) {
        this.input += input;
    }

    public void setMaxOutput(long output) {
        if (!this.hasOutput) {
            this.output = output;
            this.hasOutput = true;
        }
    }

    public void increaseMaxOutput(long output) {
        this.output += output;
    }

    public void setUsage(long usage) {
        if (!this.hasUsage) {
            this.usage = usage;
            this.hasUsage = true;
        }
    }

    public void increaseUsage(long usage) {
        this.usage += usage;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.energyType = SonarAPI.getRegistry().getEnergyType(nbt.func_74779_i("energytype"));
        this.hasStorage = nbt.func_74767_n("hS");
        this.hasInput = nbt.func_74767_n("hI");
        this.hasOutput = nbt.func_74767_n("hO");
        this.hasUsage = nbt.func_74767_n("hU");
        if (this.hasStorage) {
            this.stored = nbt.func_74763_f("s");
            this.capacity = nbt.func_74763_f("c");
        }
        if (this.hasInput) {
            this.input = nbt.func_74763_f("i");
        }
        if (this.hasOutput) {
            this.output = nbt.func_74763_f("o");
        }
        if (this.hasUsage) {
            this.usage = nbt.func_74763_f("u");
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        nbt.func_74778_a("energytype", this.energyType.getName());
        nbt.func_74757_a("hS", this.hasStorage);
        nbt.func_74757_a("hI", this.hasInput);
        nbt.func_74757_a("hO", this.hasOutput);
        nbt.func_74757_a("hU", this.hasUsage);
        if (this.hasStorage) {
            nbt.func_74772_a("s", this.stored);
            nbt.func_74772_a("c", this.capacity);
        }
        if (this.hasInput) {
            nbt.func_74772_a("i", this.input);
        }
        if (this.hasOutput) {
            nbt.func_74772_a("o", this.output);
        }
        if (this.hasUsage) {
            nbt.func_74772_a("u", this.usage);
        }
        return nbt;
    }

    public static StoredEnergyStack readFromBuf(ByteBuf buf) {
        StoredEnergyStack stored = new StoredEnergyStack(SonarAPI.getRegistry().getEnergyType(ByteBufUtils.readUTF8String((ByteBuf)buf)));
        stored.hasStorage = buf.readBoolean();
        stored.hasInput = buf.readBoolean();
        stored.hasOutput = buf.readBoolean();
        stored.hasUsage = buf.readBoolean();
        if (stored.hasStorage) {
            stored.stored = buf.readLong();
            stored.capacity = buf.readLong();
        }
        if (stored.hasInput) {
            stored.input = buf.readLong();
        }
        if (stored.hasOutput) {
            stored.output = buf.readLong();
        }
        if (stored.hasUsage) {
            stored.usage = buf.readLong();
        }
        return stored;
    }

    public static void writeToBuf(ByteBuf buf, StoredEnergyStack storedStack) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)storedStack.energyType.getName());
        buf.writeBoolean(storedStack.hasStorage);
        buf.writeBoolean(storedStack.hasInput);
        buf.writeBoolean(storedStack.hasOutput);
        buf.writeBoolean(storedStack.hasUsage);
        if (storedStack.hasStorage) {
            buf.writeLong(storedStack.stored);
            buf.writeLong(storedStack.capacity);
        }
        if (storedStack.hasInput) {
            buf.writeLong(storedStack.input);
        }
        if (storedStack.hasOutput) {
            buf.writeLong(storedStack.output);
        }
        if (storedStack.hasUsage) {
            buf.writeLong(storedStack.usage);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof StoredEnergyStack) {
            StoredEnergyStack target = (StoredEnergyStack)obj;
            if (this.stored == target.stored && this.capacity == target.capacity && this.input == target.input && this.output == target.output && this.usage == target.usage && this.energyType.getName().equals(target.energyType.getName())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ISonarStack.StorageTypes getStorageType() {
        return ISonarStack.StorageTypes.ENERGY;
    }

    @Override
    public StoredEnergyStack copy() {
        StoredEnergyStack stack = new StoredEnergyStack(this.energyType);
        stack.stored = this.stored;
        stack.capacity = this.capacity;
        stack.input = this.input;
        stack.output = this.output;
        stack.usage = this.usage;
        stack.hasStorage = this.hasStorage;
        stack.hasInput = this.hasInput;
        stack.hasOutput = this.hasOutput;
        stack.hasUsage = this.hasUsage;
        return stack;
    }

    @Override
    public void add(StoredEnergyStack stack) {
        if (this.energyType.getName().equals(stack.energyType.getName())) {
            this.stored += stack.stored;
            this.capacity += stack.capacity;
            if (stack.input > this.input) {
                this.input += stack.input;
            }
            if (stack.output > this.output) {
                this.output += stack.output;
            }
            if (stack.usage > this.usage) {
                this.usage += stack.usage;
            }
            if (stack.hasOutput) {
                this.hasOutput = true;
            }
            if (stack.hasStorage) {
                this.hasStorage = true;
            }
            if (stack.hasUsage) {
                this.hasUsage = true;
            }
            if (stack.hasInput) {
                this.hasInput = true;
            }
        }
    }

    @Override
    public void remove(StoredEnergyStack stack) {
        if (this.energyType.getName().equals(stack.energyType.getName())) {
            this.stored -= stack.stored;
            this.capacity -= stack.capacity;
        }
    }

    @Override
    public StoredEnergyStack setStackSize(long size) {
        this.stored = size;
        return this;
    }

    @Override
    public long getStackSize() {
        return this.stored;
    }

    public StoredEnergyStack convertEnergyType(EnergyType newFormat) {
        if (this.energyType != newFormat) {
            this.input = (long)((double)((long)((double)this.input / this.energyType.toRFConversion())) * newFormat.toRFConversion());
            this.output = (long)((double)((long)((double)this.output / this.energyType.toRFConversion())) * newFormat.toRFConversion());
            this.stored = (long)((double)((long)((double)this.stored / this.energyType.toRFConversion())) * newFormat.toRFConversion());
            this.capacity = (long)((double)((long)((double)this.capacity / this.energyType.toRFConversion())) * newFormat.toRFConversion());
            this.usage = (long)((double)((long)((double)this.usage / this.energyType.toRFConversion())) * newFormat.toRFConversion());
            this.energyType = newFormat;
        }
        return this;
    }

    public static long convert(long val, EnergyType current, EnergyType type) {
        double inRF = (double)val / current.toRFConversion();
        return (long)(inRF * type.toRFConversion());
    }
}

