/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.tileentity;

import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.cyclops.colossalchests.Capabilities;
import org.cyclops.colossalchests.tileentity.TileColossalChest;
import org.cyclops.commoncapabilities.api.capability.inventorystate.IInventoryState;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;

public class TileInterface
extends CyclopsTileEntity
implements ISidedInventory {
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    @NBTPersist
    private Vec3i corePosition = null;
    private WeakReference<TileColossalChest> coreReference = new WeakReference<Object>(null);

    public TileInterface() {
        this.addCapabilityInternal(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, new InvWrapper((IInventory)this));
        if (Capabilities.INVENTORY_STATE != null) {
            this.addInventoryStateCapability();
        }
        if (Capabilities.SLOTLESS_ITEMHANDLER != null) {
            this.addSlotlessItemHandlerCapability();
        }
    }

    protected void addInventoryStateCapability() {
        this.addCapabilityInternal(Capabilities.INVENTORY_STATE, new TileInterfaceInventoryState(this));
    }

    protected void addSlotlessItemHandlerCapability() {
        this.addCapabilityInternal(Capabilities.SLOTLESS_ITEMHANDLER, new TileInterfaceSlotlessItemHandler(this));
    }

    public void setCorePosition(Vec3i corePosition) {
        this.corePosition = corePosition;
        this.coreReference = new WeakReference<Object>(null);
    }

    protected TileColossalChest getCore() {
        if (this.corePosition == null) {
            return null;
        }
        if (this.coreReference.get() == null) {
            this.coreReference = new WeakReference<Object>(TileHelpers.getSafeTile((IBlockAccess)this.func_145831_w(), (BlockPos)new BlockPos(this.corePosition), TileColossalChest.class));
        }
        return (TileColossalChest)((Object)this.coreReference.get());
    }

    public int[] func_180463_a(EnumFacing side) {
        TileColossalChest core = this.getCore();
        if (core == null) {
            return new int[0];
        }
        return core.func_180463_a(side);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        TileColossalChest core = this.getCore();
        if (core == null) {
            return false;
        }
        return core.func_180462_a(index, itemStackIn, direction);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        TileColossalChest core = this.getCore();
        if (core == null) {
            return false;
        }
        return core.func_180461_b(index, stack, direction);
    }

    public int func_70302_i_() {
        TileColossalChest core = this.getCore();
        if (core == null) {
            return 0;
        }
        return core.func_70302_i_();
    }

    public ItemStack func_70301_a(int index) {
        TileColossalChest core = this.getCore();
        if (core == null) {
            return null;
        }
        return core.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        TileColossalChest core = this.getCore();
        if (core == null) {
            return null;
        }
        return core.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        TileColossalChest core = this.getCore();
        if (core == null) {
            return null;
        }
        return core.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        TileColossalChest core = this.getCore();
        if (core != null) {
            core.func_70299_a(index, stack);
        }
    }

    public int func_70297_j_() {
        TileColossalChest core = this.getCore();
        if (core == null) {
            return 0;
        }
        return core.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        TileColossalChest core = this.getCore();
        if (core == null) {
            return false;
        }
        return core.func_70300_a(player);
    }

    public void func_174889_b(EntityPlayer player) {
        TileColossalChest core = this.getCore();
        if (core != null) {
            core.func_174889_b(player);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        TileColossalChest core = this.getCore();
        if (core != null) {
            core.func_174886_c(player);
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        TileColossalChest core = this.getCore();
        if (core == null) {
            return false;
        }
        return core.func_94041_b(index, stack);
    }

    public int func_174887_a_(int id) {
        TileColossalChest core = this.getCore();
        if (core == null) {
            return -1;
        }
        return core.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        TileColossalChest core = this.getCore();
        if (core != null) {
            core.func_174885_b(id, value);
        }
    }

    public int func_174890_g() {
        TileColossalChest core = this.getCore();
        if (core == null) {
            return 0;
        }
        return core.func_174890_g();
    }

    public void func_174888_l() {
        TileColossalChest core = this.getCore();
        if (core != null) {
            core.func_174888_l();
        }
    }

    public String func_70005_c_() {
        TileColossalChest core = this.getCore();
        if (core == null) {
            return null;
        }
        return core.func_70005_c_();
    }

    public boolean func_145818_k_() {
        TileColossalChest core = this.getCore();
        if (core == null) {
            return false;
        }
        return core.func_145818_k_();
    }

    public ITextComponent func_145748_c_() {
        TileColossalChest core = this.getCore();
        if (core == null) {
            return null;
        }
        return core.func_145748_c_();
    }

    public Vec3i getCorePosition() {
        return this.corePosition;
    }

    public void update() {
        this.tickingTileComponent.func_73660_a();
    }

    public static class TileInterfaceSlotlessItemHandler
    implements ISlotlessItemHandler {
        private final TileInterface tile;

        public TileInterfaceSlotlessItemHandler(TileInterface tile) {
            this.tile = tile;
        }

        @Nullable
        protected ISlotlessItemHandler getHandler() {
            TileColossalChest core = this.tile.getCore();
            if (core != null) {
                return core.hasCapability(Capabilities.SLOTLESS_ITEMHANDLER, null) ? (ISlotlessItemHandler)core.getCapability(Capabilities.SLOTLESS_ITEMHANDLER, null) : null;
            }
            return null;
        }

        public ItemStack insertItem(ItemStack stack, boolean simulate) {
            ISlotlessItemHandler handler = this.getHandler();
            return handler != null ? handler.insertItem(stack, simulate) : stack;
        }

        public ItemStack extractItem(int amount, boolean simulate) {
            ISlotlessItemHandler handler = this.getHandler();
            return handler != null ? handler.extractItem(amount, simulate) : null;
        }

        public ItemStack extractItem(ItemStack matchStack, int matchFlags, boolean simulate) {
            ISlotlessItemHandler handler = this.getHandler();
            return handler != null ? handler.extractItem(matchStack, matchFlags, simulate) : null;
        }
    }

    public static class TileInterfaceInventoryState
    implements IInventoryState {
        private final TileInterface tile;

        public TileInterfaceInventoryState(TileInterface tile) {
            this.tile = tile;
        }

        public int getHash() {
            TileColossalChest core = this.tile.getCore();
            if (core != null) {
                return core.getInventoryHash();
            }
            return -1;
        }
    }
}

