/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.pipes.pipe;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mcmultipart.MCMultiPartMod;
import mcmultipart.client.multipart.AdvancedParticleManager;
import mcmultipart.client.multipart.IFastMSRPart;
import mcmultipart.microblock.IMicroblock;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.INormallyOccludingPart;
import mcmultipart.multipart.ISlottedPart;
import mcmultipart.multipart.Multipart;
import mcmultipart.multipart.MultipartRegistry;
import mcmultipart.multipart.OcclusionHelper;
import mcmultipart.multipart.PartSlot;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import pl.asie.charset.api.pipes.IPipe;
import pl.asie.charset.api.pipes.IShifter;
import pl.asie.charset.lib.misc.IConnectable;
import pl.asie.charset.lib.utils.GenericExtendedProperty;
import pl.asie.charset.lib.utils.RotationUtils;
import pl.asie.charset.pipes.ModCharsetPipes;
import pl.asie.charset.pipes.PipeUtils;
import pl.asie.charset.pipes.pipe.PacketPipeSyncRequest;
import pl.asie.charset.pipes.pipe.PipeFluidContainer;
import pl.asie.charset.pipes.pipe.PipeItem;

public class PartPipe
extends Multipart
implements IConnectable,
ISlottedPart,
INormallyOccludingPart,
IPipe,
ITickable,
IFastMSRPart {
    public static final GenericExtendedProperty<PartPipe> PROPERTY = new GenericExtendedProperty<PartPipe>("part", PartPipe.class);
    private static final AxisAlignedBB[] BOXES = new AxisAlignedBB[7];
    final PipeFluidContainer fluid = new PipeFluidContainer(this);
    boolean renderFast = false;
    protected int[] shifterDistance = new int[6];
    private final Set<PipeItem> itemSet = new HashSet<PipeItem>();
    private byte connectionCache = 0;
    private boolean neighborBlockChanged;
    private boolean requestUpdate;

    public void handlePacket(ByteBuf buf) {
        byte oldCC = this.connectionCache;
        this.connectionCache = buf.readByte();
        this.requestUpdate = true;
        if (oldCC != this.connectionCache) {
            this.markRenderUpdate();
        }
    }

    public void readUpdatePacket(PacketBuffer buf) {
        super.readUpdatePacket(buf);
        if (!Minecraft.func_71410_x().func_152345_ab()) {
            final ByteBuf buf2 = Unpooled.copiedBuffer((ByteBuf)buf);
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    PartPipe.this.handlePacket(buf2);
                }
            });
        } else {
            this.handlePacket((ByteBuf)buf);
        }
    }

    public void writeUpdatePacket(PacketBuffer buf) {
        super.writeUpdatePacket(buf);
        buf.writeByte((int)this.connectionCache);
    }

    public ItemStack getPickBlock(EntityPlayer player, PartMOP hit) {
        return new ItemStack(ModCharsetPipes.itemPipe);
    }

    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack(ModCharsetPipes.itemPipe));
        for (PipeItem i : this.itemSet) {
            if (!i.isValid()) continue;
            drops.add(i.getStack());
        }
        return drops;
    }

    public float getHardness(PartMOP hit) {
        return 0.3f;
    }

    public Material getMaterial() {
        return Material.field_151592_s;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        this.addSelectionBoxes(list);
        return (AxisAlignedBB)list.get(0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(AdvancedParticleManager advancedEffectRenderer) {
        advancedEffectRenderer.addBlockDestroyEffects(this.getPos(), Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(this.getExtendedState(MultipartRegistry.getDefaultState((IMultipart)this).func_177621_b())));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(PartMOP partMOP, AdvancedParticleManager advancedEffectRenderer) {
        return true;
    }

    public void addOcclusionBoxes(List<AxisAlignedBB> list) {
        list.add(new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75));
    }

    public void addSelectionBoxes(List<AxisAlignedBB> list) {
        list.add(BOXES[6]);
        for (EnumFacing f : EnumFacing.field_82609_l) {
            if (!this.connects(f)) continue;
            list.add(BOXES[f.ordinal()]);
        }
    }

    public void addCollisionBoxes(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        if (BOXES[6].func_72326_a(mask)) {
            list.add(BOXES[6]);
        }
        for (EnumFacing f : EnumFacing.field_82609_l) {
            if (!this.connects(f) || !BOXES[f.ordinal()].func_72326_a(mask)) continue;
            list.add(BOXES[f.ordinal()]);
        }
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public ResourceLocation getModelPath() {
        return new ResourceLocation("charsetpipes:pipe");
    }

    public TileEntity getNeighbourTile(EnumFacing side) {
        return side != null ? this.getWorld().func_175625_s(this.getPos().func_177972_a(side)) : null;
    }

    private boolean internalConnects(EnumFacing side) {
        ISlottedPart part = this.getContainer().getPartInSlot(PartSlot.getFaceSlot((EnumFacing)side));
        if (part instanceof IMicroblock.IFaceMicroblock && !((IMicroblock.IFaceMicroblock)part).isFaceHollow()) {
            return false;
        }
        if (!OcclusionHelper.occlusionTest((IMultipart)OcclusionHelper.boxes((AxisAlignedBB[])new AxisAlignedBB[]{BOXES[side.ordinal()]}), p -> p == this, (IMultipartContainer)this.getContainer())) {
            return false;
        }
        if (PipeUtils.getPipe(this.getWorld(), this.getPos().func_177972_a(side), side.func_176734_d()) != null) {
            return true;
        }
        TileEntity tile = this.getNeighbourTile(side);
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())) {
            return true;
        }
        if (tile instanceof ISidedInventory || tile instanceof IInventory) {
            return true;
        }
        if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) {
            return true;
        }
        if (tile instanceof IFluidHandler) {
            return true;
        }
        if (tile != null && tile.hasCapability(ModCharsetPipes.CAP_SHIFTER, side.func_176734_d())) {
            return ((IShifter)tile.getCapability(ModCharsetPipes.CAP_SHIFTER, side.func_176734_d())).getMode() == IShifter.Mode.Extract;
        }
        return false;
    }

    private void updateConnections(EnumFacing side) {
        if (side != null) {
            this.connectionCache = (byte)(this.connectionCache & ~(1 << side.ordinal()));
            if (this.internalConnects(side)) {
                PartPipe pipe = PipeUtils.getPipe(this.getWorld(), this.getPos().func_177972_a(side), side.func_176734_d());
                if (pipe != null && !pipe.internalConnects(side.func_176734_d())) {
                    return;
                }
                this.connectionCache = (byte)(this.connectionCache | 1 << side.ordinal());
            }
        } else {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                this.updateConnections(facing);
            }
        }
    }

    @Override
    public boolean connects(EnumFacing side) {
        return (this.connectionCache & 1 << side.ordinal()) != 0;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.readItems(nbt);
        NBTTagCompound tag = nbt.func_74775_l("fluid");
        this.fluid.readFromNBT(tag);
        this.connectionCache = nbt.func_74771_c("cc");
        this.shifterDistance = nbt.func_74759_k("shifterDist");
        if (this.shifterDistance == null || this.shifterDistance.length != 6) {
            this.shifterDistance = new int[6];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readItems(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("items", 10);
        Set<PipeItem> set = this.itemSet;
        synchronized (set) {
            this.itemSet.clear();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                PipeItem pipeItem = new PipeItem(this, compound);
                if (!pipeItem.isValid()) continue;
                this.itemSet.add(pipeItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeItems(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        Set<PipeItem> set = this.itemSet;
        synchronized (set) {
            for (PipeItem i : this.itemSet) {
                NBTTagCompound cpd = new NBTTagCompound();
                i.writeToNBT(cpd);
                list.func_74742_a((NBTBase)cpd);
            }
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.writeItems(nbt);
        NBTTagCompound tag = new NBTTagCompound();
        this.fluid.writeToNBT(tag);
        if (tag.func_186856_d() > 0) {
            nbt.func_74782_a("fluid", (NBTBase)tag);
        }
        nbt.func_74774_a("cc", this.connectionCache);
        if (this.shifterDistance != null) {
            nbt.func_74783_a("shifterDist", this.shifterDistance);
        }
        return nbt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUnloaded() {
        super.onUnloaded();
        if (this.getWorld() != null && this.getWorld().field_72995_K) {
            Set<PipeItem> set = this.itemSet;
            synchronized (set) {
                this.itemSet.clear();
            }
        }
    }

    public void onAdded() {
        if (this.getWorld() != null) {
            this.updateNeighborInfo(false);
            this.onLoaded();
        }
        this.scheduleRenderUpdate();
    }

    public void onLoaded() {
        this.neighborBlockChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73660_a() {
        if (this.requestUpdate && this.getWorld() != null) {
            ModCharsetPipes.packet.sendToServer(new PacketPipeSyncRequest((IMultipart)this));
            this.requestUpdate = false;
        }
        if (this.neighborBlockChanged && this.getWorld() != null) {
            this.updateNeighborInfo(true);
            this.neighborBlockChanged = false;
        }
        this.fluid.func_73660_a();
        Set<PipeItem> set = this.itemSet;
        synchronized (set) {
            Iterator<PipeItem> itemIterator = this.itemSet.iterator();
            while (itemIterator.hasNext()) {
                PipeItem p = itemIterator.next();
                if (p.move()) continue;
                itemIterator.remove();
            }
        }
    }

    protected int getShifterStrength(EnumFacing direction) {
        return direction == null ? 0 : this.shifterDistance[direction.ordinal()];
    }

    private void updateShifterSide(EnumFacing dir) {
        TileEntity tile;
        PartPipe pipe;
        int i = dir.ordinal();
        int oldDistance = this.shifterDistance[i];
        if (this.shifterDistance[i] == 1 && this.getNearestShifterInternal(dir) != null) {
            return;
        }
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos(this.getPos());
        EnumFacing dirO = dir.func_176734_d();
        int dist = 0;
        while ((pipe = PipeUtils.getPipe(this.getWorld(), (BlockPos)p, dirO)) instanceof PartPipe) {
            p.func_189536_c(dirO);
            ++dist;
            if (pipe.connects(dirO)) continue;
        }
        this.shifterDistance[i] = (tile = this.getWorld().func_175625_s((BlockPos)p)) != null && tile.hasCapability(ModCharsetPipes.CAP_SHIFTER, dir) && this.isMatchingShifter((IShifter)tile.getCapability(ModCharsetPipes.CAP_SHIFTER, dir), dir, dist) ? dist : 0;
        if (oldDistance != this.shifterDistance[i] && (pipe = PipeUtils.getPipe(this.getWorld(), this.getPos().func_177972_a(dir), null)) != null) {
            pipe.updateShifterSide(dir);
        }
    }

    private void updateNeighborInfo(boolean sendPacket) {
        if (!this.getWorld().field_72995_K) {
            byte oc = this.connectionCache;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                this.updateConnections(dir);
                this.updateShifterSide(dir);
            }
            if (sendPacket && this.connectionCache != oc) {
                this.sendUpdatePacket();
            }
        }
    }

    private boolean isMatchingShifter(IShifter p, EnumFacing dir, int dist) {
        return p.getDirection() == dir && dist <= p.getShiftDistance();
    }

    private IShifter getNearestShifterInternal(EnumFacing dir) {
        IShifter shifter;
        TileEntity tile;
        switch (this.shifterDistance[dir.ordinal()]) {
            case 0: {
                return null;
            }
            case 1: {
                tile = this.getNeighbourTile(dir.func_176734_d());
                break;
            }
            default: {
                tile = this.getWorld().func_175625_s(this.getPos().func_177967_a(dir.func_176734_d(), this.shifterDistance[dir.ordinal()]));
            }
        }
        if (tile != null && tile.hasCapability(ModCharsetPipes.CAP_SHIFTER, dir) && this.isMatchingShifter(shifter = (IShifter)tile.getCapability(ModCharsetPipes.CAP_SHIFTER, dir), dir, Integer.MAX_VALUE)) {
            return shifter;
        }
        return null;
    }

    protected IShifter getNearestShifter(EnumFacing dir) {
        if (dir == null) {
            return null;
        }
        if (this.shifterDistance[dir.ordinal()] == 0) {
            return null;
        }
        IShifter p = this.getNearestShifterInternal(dir);
        if (p == null) {
            this.updateShifterSide(dir);
            return this.getNearestShifterInternal(dir);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addItemClientSide(PipeItem item) {
        if (this.getWorld() == null || !this.getWorld().field_72995_K) {
            return;
        }
        Set<PipeItem> set = this.itemSet;
        synchronized (set) {
            Iterator<PipeItem> itemIterator = this.itemSet.iterator();
            while (itemIterator.hasNext()) {
                PipeItem p = itemIterator.next();
                if (p.id != item.id) continue;
                itemIterator.remove();
                break;
            }
            if (this.renderFast && ModCharsetPipes.proxy.stopsRenderFast(this.getWorld(), item.stack)) {
                this.renderFast = false;
            }
            this.itemSet.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeItemClientSide(PipeItem item) {
        if (this.getWorld() != null && this.getWorld().field_72995_K) {
            Set<PipeItem> set = this.itemSet;
            synchronized (set) {
                this.itemSet.remove(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean injectItemInternal(PipeItem item, EnumFacing dir, boolean simulate) {
        if (item.isValid()) {
            int stuckItems = 0;
            Set<PipeItem> set = this.itemSet;
            synchronized (set) {
                for (PipeItem p : this.itemSet) {
                    if (!p.isStuck() || ++stuckItems < 1) continue;
                    return false;
                }
                if (!simulate) {
                    this.itemSet.add(item);
                    if (this.renderFast && ModCharsetPipes.proxy.stopsRenderFast(this.getWorld(), item.stack)) {
                        this.renderFast = false;
                    }
                }
            }
            if (!simulate) {
                item.reset(this, dir);
                item.sendPacket(true);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canInjectItems(EnumFacing side) {
        return this.connects(side);
    }

    @Override
    public int injectItem(ItemStack stack, EnumFacing direction, boolean simulate) {
        if (this.getWorld() == null || this.getWorld().field_72995_K || !this.connects(direction)) {
            return 0;
        }
        PipeItem item = new PipeItem(this, stack, direction);
        if (this.injectItemInternal(item, direction, simulate)) {
            return stack.field_77994_a;
        }
        return 0;
    }

    protected void scheduleRenderUpdate() {
        if (this.getWorld() != null) {
            this.getWorld().func_175704_b(this.getPos(), this.getPos());
        }
    }

    public void onNeighborBlockChange(Block block) {
        this.neighborBlockChanged = true;
    }

    public Collection<PipeItem> getPipeItems() {
        return this.itemSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PipeItem getItemByID(int id) {
        Set<PipeItem> set = this.itemSet;
        synchronized (set) {
            for (PipeItem p : this.itemSet) {
                if (p.id != id) continue;
                return p;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSyncRequest() {
        Set<PipeItem> set = this.itemSet;
        synchronized (set) {
            for (PipeItem p : this.itemSet) {
                p.sendPacket(true);
            }
        }
        this.fluid.sendPacket(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemStack getTravellingStack(EnumFacing side) {
        float targetError = 1000.0f;
        PipeItem targetItem = null;
        Set<PipeItem> set = this.itemSet;
        synchronized (set) {
            for (PipeItem p : this.itemSet) {
                float error;
                if (side == null) {
                    error = Math.abs(p.getProgress() - 0.5f);
                    if (error > 0.25f) {
                        continue;
                    }
                } else {
                    if (p.getDirection() == null) continue;
                    if (p.getProgress() <= 0.25f && side == p.getDirection().func_176734_d()) {
                        error = Math.abs(p.getProgress() - 0.125f);
                    } else {
                        if (!(p.getProgress() >= 0.75f) || side != p.getDirection()) continue;
                        error = Math.abs(p.getProgress() - 0.875f);
                    }
                    if (error > 0.125f) continue;
                }
                if (!(error < targetError)) continue;
                targetError = error;
                targetItem = p;
            }
        }
        return targetItem != null ? targetItem.getStack() : null;
    }

    public IBlockState getExtendedState(IBlockState state) {
        return ((IExtendedBlockState)state).withProperty(PROPERTY, (Object)this);
    }

    public BlockStateContainer createBlockState() {
        return new ExtendedBlockState((Block)MCMultiPartMod.multipart, new IProperty[0], new IUnlistedProperty[]{PROPERTY});
    }

    public EnumSet<PartSlot> getSlotMask() {
        return EnumSet.of(PartSlot.CENTER);
    }

    public boolean hasFastRenderer() {
        return this.itemSet.size() == 0 || this.renderFast;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluid.tanks[facing.ordinal()]);
        }
        return null;
    }

    static {
        PartPipe.BOXES[6] = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
        for (int i = 0; i < 6; ++i) {
            PartPipe.BOXES[i] = RotationUtils.rotateFace(new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.25, 0.75), EnumFacing.func_82600_a((int)i));
        }
    }
}

