/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.network;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import io.netty.channel.ChannelHandler;
import java.util.EnumMap;
import mcmultipart.multipart.IMultipart;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.lib.network.PacketChannelHandler;

public class PacketRegistry {
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private TIntObjectMap<Class<? extends Packet>> idPacketMap = new TIntObjectHashMap();
    private TObjectIntMap<Class<? extends Packet>> packetIdMap = new TObjectIntHashMap();

    public PacketRegistry(String channelName) {
        this.channels = NetworkRegistry.INSTANCE.newChannel(channelName, new ChannelHandler[]{new PacketChannelHandler(this)});
    }

    public void registerPacket(int id, Class<? extends Packet> packet) {
        this.idPacketMap.put(id, packet);
        this.packetIdMap.put(packet, id);
    }

    public net.minecraft.network.Packet getPacketFrom(Packet message) {
        return this.channels.get(Side.SERVER).generatePacketFrom((Object)message);
    }

    public void sendToAll(Packet message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public void sendToWatching(Packet message, World world, BlockPos pos) {
        WorldServer worldServer = (WorldServer)world;
        for (EntityPlayerMP player : worldServer.func_73046_m().func_184103_al().func_181057_v()) {
            if (player.field_70170_p.field_73011_w.getDimension() != world.field_73011_w.getDimension() || !worldServer.func_184164_w().func_72694_a(player, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) continue;
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
            this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
        }
    }

    public void sendToWatching(Packet message, IMultipart tile) {
        this.sendToWatching(message, tile.getWorld(), tile.getPos());
    }

    public void sendToAllAround(Packet packet, IMultipart entity, double d) {
        this.sendToAllAround(packet, new NetworkRegistry.TargetPoint(entity.getWorld().field_73011_w.getDimension(), (double)entity.getPos().func_177958_n(), (double)entity.getPos().func_177956_o(), (double)entity.getPos().func_177952_p(), d));
    }

    public void sendToWatching(Packet message, TileEntity tile) {
        this.sendToWatching(message, tile.func_145831_w(), tile.func_174877_v());
    }

    public void sendTo(Packet message, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public void sendToAllAround(Packet message, NetworkRegistry.TargetPoint point) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public void sendToDimension(Packet message, int dimensionId) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public void sendToServer(Packet message) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeOutbound(new Object[]{message});
    }

    public void sendToAllAround(Packet packet, TileEntity entity, double d) {
        this.sendToAllAround(packet, new NetworkRegistry.TargetPoint(entity.func_145831_w().field_73011_w.getDimension(), (double)entity.func_174877_v().func_177958_n(), (double)entity.func_174877_v().func_177956_o(), (double)entity.func_174877_v().func_177952_p(), d));
    }

    public void sendToAllAround(Packet packet, Entity entity, double d) {
        this.sendToAllAround(packet, new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, d));
    }

    public Packet instantiatePacket(int i) {
        try {
            return (Packet)((Class)this.idPacketMap.get(i)).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getPacketId(Class<? extends Packet> aClass) {
        return this.packetIdMap.get(aClass);
    }
}

