/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.modules.ModuleBase;

public abstract class ModuleWorker
extends ModuleBase {
    private boolean preWork = true;
    private boolean shouldDie;

    public ModuleWorker(EntityMinecartModular cart) {
        super(cart);
    }

    public abstract byte getWorkPriority();

    public abstract boolean work();

    public void startWorking(int time) {
        this.getCart().setWorkingTime(time);
        this.preWork = false;
        this.getCart().setWorker(this);
    }

    public void stopWorking() {
        if (this.getCart().getWorker() == this) {
            this.preWork = true;
            this.getCart().setWorker(null);
        }
    }

    public boolean preventAutoShutdown() {
        return false;
    }

    public void kill() {
        this.shouldDie = true;
    }

    public boolean isDead() {
        return this.shouldDie;
    }

    public void revive() {
        this.shouldDie = false;
    }

    protected boolean doPreWork() {
        return this.preWork;
    }

    public BlockPos getLastblock() {
        return this.getNextblock(false);
    }

    public BlockPos getNextblock() {
        return this.getNextblock(true);
    }

    private BlockPos getNextblock(boolean flag) {
        IBlockState blockState;
        BlockPos pos = this.getCart().func_180425_c();
        if (BlockRailBase.func_176562_d((World)this.getCart().field_70170_p, (BlockPos)pos.func_177977_b())) {
            pos = pos.func_177977_b();
        }
        if (BlockRailBase.func_176563_d((IBlockState)(blockState = this.getCart().field_70170_p.func_180495_p(pos)))) {
            int meta = ((BlockRailBase)blockState.func_177230_c()).getRailDirection((IBlockAccess)this.getCart().field_70170_p, pos, blockState, (EntityMinecart)this.getCart()).func_177015_a();
            if (meta >= 2 && meta <= 5) {
                pos = pos.func_177984_a();
            }
            int[][] logic = EntityMinecartModular.railDirectionCoordinates[meta];
            double pX = this.getCart().pushX;
            double pZ = this.getCart().pushZ;
            boolean xDir = pX > 0.0 && logic[0][0] > 0 || pX == 0.0 || logic[0][0] == 0 || pX < 0.0 && logic[0][0] < 0;
            boolean zDir = pZ > 0.0 && logic[0][2] > 0 || pZ == 0.0 || logic[0][2] == 0 || pZ < 0.0 && logic[0][2] < 0;
            int dir = (xDir && zDir) != flag ? 1 : 0;
            return pos.func_177982_a(logic[dir][0], logic[dir][1], logic[dir][2]);
        }
        return pos;
    }

    @Override
    public float getMaxSpeed() {
        if (!this.doPreWork()) {
            return 0.0f;
        }
        return super.getMaxSpeed();
    }

    protected boolean isValidForTrack(World world, BlockPos pos, boolean flag) {
        boolean result;
        boolean bl = result = this.countsAsAir(pos) && (!flag || world.isSideSolid(pos.func_177977_b(), EnumFacing.UP));
        if (result) {
            int coordX = pos.func_177958_n() - (this.getCart().x() - pos.func_177958_n());
            int coordZ = pos.func_177956_o() - (this.getCart().z() - pos.func_177956_o());
            Block block = this.getCart().field_70170_p.func_180495_p(new BlockPos(coordX, pos.func_177956_o(), coordZ)).func_177230_c();
            boolean isWater = block == Blocks.field_150355_j || block == Blocks.field_150358_i || block == Blocks.field_150432_aD;
            boolean isLava = block == Blocks.field_150353_l || block == Blocks.field_150356_k;
            boolean isOther = block != null && block instanceof IFluidBlock;
            boolean isLiquid = isWater || isLava || isOther;
            result = !isLiquid;
        }
        return result;
    }
}

