/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotCake;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.ISuppliesModule;
import vswe.stevescarts.modules.ModuleBase;

public class ModuleCakeServer
extends ModuleBase
implements ISuppliesModule {
    private int cooldown = 0;
    private static final int MAX_CAKES = 10;
    private static final int SLICES_PER_CAKE = 6;
    private static final int MAX_TOTAL_SLICES = 66;
    private int[] rect = new int[]{40, 20, 13, 36};
    private DataParameter<Integer> BUFFER;

    public ModuleCakeServer(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        super.update();
        if (!this.getCart().field_70170_p.field_72995_K) {
            ItemStack item;
            if (this.getCart().hasCreativeSupplies()) {
                if (this.cooldown >= 20) {
                    if (this.getCakeBuffer() < 66) {
                        this.setCakeBuffer(this.getCakeBuffer() + 1);
                    }
                    this.cooldown = 0;
                } else {
                    ++this.cooldown;
                }
            }
            if ((item = this.getStack(0)) != null && item.func_77973_b().equals(Items.field_151105_aU) && this.getCakeBuffer() + 6 <= 66) {
                this.setCakeBuffer(this.getCakeBuffer() + 6);
                this.setStack(0, null);
            }
        }
    }

    private void setCakeBuffer(int i) {
        this.updateDw(this.BUFFER, i);
    }

    private int getCakeBuffer() {
        if (this.isPlaceholder()) {
            return 6;
        }
        return this.getDw(this.BUFFER);
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void initDw() {
        this.BUFFER = this.createDw(DataSerializers.field_187192_b);
        this.registerDw(this.BUFFER, 0);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected int getInventoryWidth() {
        return 1;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotCake(this.getCart(), slotId, 8 + x * 18, 38 + y * 18);
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, Localization.MODULES.ATTACHMENTS.CAKE_SERVER.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        tagCompound.func_74777_a(this.generateNBTName("Cake", id), (short)this.getCakeBuffer());
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.setCakeBuffer(tagCompound.func_74765_d(this.generateNBTName("Cake", id)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(gui, Localization.MODULES.ATTACHMENTS.CAKES.translate(String.valueOf(this.getCakes()), String.valueOf(10)) + "\n" + Localization.MODULES.ATTACHMENTS.SLICES.translate(String.valueOf(this.getSlices()), String.valueOf(6)), x, y, this.rect);
    }

    private int getCakes() {
        if (this.getCakeBuffer() == 66) {
            return 10;
        }
        return this.getCakeBuffer() / 6;
    }

    private int getSlices() {
        if (this.getCakeBuffer() == 66) {
            return 6;
        }
        return this.getCakeBuffer() % 6;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/cake.png");
        this.drawImage(gui, this.rect, 0, this.inRect(x, y, this.rect) ? this.rect[3] : 0);
        int maxHeight = this.rect[3] - 2;
        int height = (int)((float)this.getCakes() / 10.0f * (float)maxHeight);
        if (height > 0) {
            this.drawImage(gui, this.rect[0] + 1, this.rect[1] + 1 + maxHeight - height, this.rect[2], maxHeight - height, 7, height);
        }
        if ((height = (int)((float)this.getSlices() / 6.0f * (float)maxHeight)) > 0) {
            this.drawImage(gui, this.rect[0] + 9, this.rect[1] + 1 + maxHeight - height, this.rect[2] + 7, maxHeight - height, 3, height);
        }
    }

    @Override
    public int guiWidth() {
        return 75;
    }

    @Override
    public int guiHeight() {
        return 60;
    }

    @Override
    public boolean onInteractFirst(EntityPlayer entityplayer) {
        if (this.getCakeBuffer() > 0) {
            if (!this.getCart().field_70170_p.field_72995_K && entityplayer.func_71043_e(false)) {
                this.setCakeBuffer(this.getCakeBuffer() - 1);
                entityplayer.func_71024_bL().func_75122_a(2, 0.1f);
            }
            return true;
        }
        return false;
    }

    public int getRenderSliceCount() {
        int count = this.getSlices();
        if (count == 0 && this.getCakes() > 0) {
            count = 6;
        }
        return count;
    }

    @Override
    public boolean haveSupplies() {
        return this.getCakeBuffer() > 0;
    }
}

