/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import java.util.ArrayList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.blocks.tileentities.TileEntityCargo;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotChest;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.ModuleBase;
import vswe.stevescarts.modules.addons.ModuleAddon;

public abstract class ModuleRecipe
extends ModuleAddon {
    private int target = 3;
    protected boolean dirty = true;
    protected ArrayList<SlotBase> inputSlots;
    protected ArrayList<SlotBase> outputSlots;
    protected ArrayList<SlotBase> allTheSlots = new ArrayList();
    private int maxItemCount = 1;
    private int mode;

    public ModuleRecipe(EntityMinecartModular cart) {
        super(cart);
        this.outputSlots = new ArrayList();
    }

    protected abstract int getLimitStartX();

    protected abstract int getLimitStartY();

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiMinecart gui, int x, int y) {
        if (this.canUseAdvancedFeatures()) {
            int[] area = this.getArea();
            ResourceHelper.bindResource("/gui/recipe.png");
            this.drawImage(gui, area[0] - 2, area[1] - 2, 0, 0, 20, 20);
            if (this.mode == 1) {
                for (int i = 0; i < 3; ++i) {
                    this.drawControlRect(gui, x, y, i);
                }
            } else {
                this.drawControlRect(gui, x, y, 1);
            }
        }
    }

    private void drawControlRect(GuiMinecart gui, int x, int y, int i) {
        int[] rect;
        int v = i * 11;
        this.drawImage(gui, rect, 20 + (this.inRect(x, y, rect = this.getControlRect(i)) ? 22 : 0), v);
    }

    private int[] getControlRect(int i) {
        return new int[]{this.getLimitStartX(), this.getLimitStartY() + 12 * i, 22, 11};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(GuiMinecart gui) {
        if (this.canUseAdvancedFeatures()) {
            String str = null;
            switch (this.mode) {
                case 0: {
                    str = "Inf";
                    break;
                }
                case 1: {
                    str = String.valueOf(this.maxItemCount);
                    break;
                }
                default: {
                    str = "X";
                }
            }
            this.drawString(gui, str, this.getControlRect(1), 0x404040);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackgroundItems(GuiMinecart gui, int x, int y) {
        if (this.canUseAdvancedFeatures()) {
            ItemStack icon = this.isTargetInvalid() ? new ItemStack(Items.field_151143_au, 1) : TileEntityCargo.itemSelections.get(this.target).getIcon();
            int[] area = this.getArea();
            this.drawItemInInterface(gui, icon, area[0], area[1]);
        }
    }

    private boolean isTargetInvalid() {
        return this.target < 0 || this.target >= TileEntityCargo.itemSelections.size() || TileEntityCargo.itemSelections.get(this.target).getValidSlot() == null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        if (this.canUseAdvancedFeatures()) {
            String str = Localization.MODULES.ADDONS.RECIPE_OUTPUT.translate(new String[0]) + "\n" + Localization.MODULES.ADDONS.CURRENT.translate(new String[0]) + ": ";
            str = this.isTargetInvalid() ? str + Localization.MODULES.ADDONS.INVALID_OUTPUT.translate(new String[0]) : str + TileEntityCargo.itemSelections.get(this.target).getName();
            this.drawStringOnMouseOver(gui, str, x, y, this.getArea());
            for (int i = 0; i < 3; ++i) {
                if (i == 1) {
                    str = Localization.MODULES.ADDONS.RECIPE_MODE.translate(new String[0]) + "\n" + Localization.MODULES.ADDONS.CURRENT.translate(new String[0]) + ": ";
                    switch (this.mode) {
                        case 0: {
                            str = str + Localization.MODULES.ADDONS.RECIPE_NO_LIMIT.translate(new String[0]);
                            break;
                        }
                        case 1: {
                            str = str + Localization.MODULES.ADDONS.RECIPE_LIMIT.translate(new String[0]);
                            break;
                        }
                        default: {
                            str = str + Localization.MODULES.ADDONS.RECIPE_DISABLED.translate(new String[0]);
                            break;
                        }
                    }
                } else {
                    str = this.mode != 1 ? null : Localization.MODULES.ADDONS.RECIPE_CHANGE_AMOUNT.translate(i == 0 ? "0" : "1") + "\n" + Localization.MODULES.ADDONS.RECIPE_CHANGE_AMOUNT_10.translate(new String[0]) + "\n" + Localization.MODULES.ADDONS.RECIPE_CHANGE_AMOUNT_64.translate(new String[0]);
                }
                if (str == null) continue;
                this.drawStringOnMouseOver(gui, str, x, y, this.getControlRect(i));
            }
        }
    }

    protected abstract int[] getArea();

    @Override
    public int numberOfGuiData() {
        return this.canUseAdvancedFeatures() ? 3 : 0;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        if (this.canUseAdvancedFeatures()) {
            this.updateGuiData(info, 0, (short)this.target);
            this.updateGuiData(info, 1, (short)this.mode);
            this.updateGuiData(info, 2, (short)this.maxItemCount);
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (this.canUseAdvancedFeatures()) {
            if (id == 0) {
                this.target = data;
            } else if (id == 1) {
                this.mode = data;
            } else if (id == 2) {
                this.maxItemCount = data;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (this.canUseAdvancedFeatures()) {
            if (this.inRect(x, y, this.getArea())) {
                this.sendPacket(0, (byte)button);
            }
            for (int i = 0; i < 3; ++i) {
                if (this.mode != 1 && i != 1 || !this.inRect(x, y, this.getControlRect(i))) continue;
                if (i == 1) {
                    this.sendPacket(1, (byte)button);
                    break;
                }
                byte encodedData = (byte)(i != 0 ? 1 : 0);
                if (GuiScreen.func_146271_m()) {
                    encodedData = (byte)(encodedData | 2);
                } else if (GuiScreen.func_146272_n()) {
                    encodedData = (byte)(encodedData | 4);
                }
                this.sendPacket(2, encodedData);
                break;
            }
        }
    }

    @Override
    protected int numberOfPackets() {
        return this.canUseAdvancedFeatures() ? 3 : 0;
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (this.canUseAdvancedFeatures()) {
            if (id == 0) {
                this.dirty = true;
                this.changeTarget(data[0] == 0);
            } else if (id == 1) {
                if (data[0] == 0) {
                    if (++this.mode > 2) {
                        this.mode = 0;
                    }
                } else if (--this.mode < 0) {
                    this.mode = 2;
                }
            } else if (id == 2) {
                int dif;
                int n = dif = (data[0] & 1) == 0 ? 1 : -1;
                if ((data[0] & 2) != 0) {
                    dif *= 64;
                } else if ((data[0] & 4) != 0) {
                    dif *= 10;
                }
                this.maxItemCount = Math.min(Math.max(1, this.maxItemCount + dif), 999);
            }
        }
    }

    private void changeTarget(boolean up) {
        if (!up) {
            if (--this.target < 0) {
                this.target = TileEntityCargo.itemSelections.size() - 1;
            }
        } else if (++this.target >= TileEntityCargo.itemSelections.size()) {
            this.target = 0;
        }
        if (this.isTargetInvalid()) {
            this.changeTarget(up);
        }
    }

    protected abstract boolean canUseAdvancedFeatures();

    protected Class getValidSlot() {
        if (this.isTargetInvalid()) {
            return null;
        }
        return TileEntityCargo.itemSelections.get(this.target).getValidSlot();
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        if (this.canUseAdvancedFeatures()) {
            this.target = tagCompound.func_74771_c(this.generateNBTName("Target", id));
            this.mode = tagCompound.func_74771_c(this.generateNBTName("Mode", id));
            this.maxItemCount = tagCompound.func_74765_d(this.generateNBTName("MaxItems", id));
        }
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        if (this.canUseAdvancedFeatures()) {
            tagCompound.func_74774_a(this.generateNBTName("Target", id), (byte)this.target);
            tagCompound.func_74774_a(this.generateNBTName("Mode", id), (byte)this.mode);
            tagCompound.func_74777_a(this.generateNBTName("MaxItems", id), (short)this.maxItemCount);
        }
    }

    protected void prepareLists() {
        if (this.inputSlots == null) {
            this.inputSlots = new ArrayList();
            for (ModuleBase module : this.getCart().getModules()) {
                if (module.getSlots() == null) continue;
                for (SlotBase slot : module.getSlots()) {
                    if (!(slot instanceof SlotChest)) continue;
                    this.inputSlots.add(slot);
                }
            }
        }
        if (this.dirty) {
            this.allTheSlots.clear();
            this.outputSlots.clear();
            Class validSlot = this.getValidSlot();
            for (ModuleBase module2 : this.getCart().getModules()) {
                if (module2.getSlots() == null) continue;
                for (SlotBase slot2 : module2.getSlots()) {
                    if (validSlot.isInstance((Object)slot2)) {
                        this.outputSlots.add(slot2);
                        this.allTheSlots.add(slot2);
                        continue;
                    }
                    if (!(slot2 instanceof SlotChest)) continue;
                    this.allTheSlots.add(slot2);
                }
            }
            this.dirty = false;
        }
    }

    protected boolean canCraftMoreOfResult(ItemStack result) {
        if (this.mode == 0) {
            return true;
        }
        if (this.mode == 2) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < this.outputSlots.size(); ++i) {
            ItemStack item = this.outputSlots.get(i).func_75211_c();
            if (item == null || !item.func_77969_a(result) || !ItemStack.func_77970_a((ItemStack)item, (ItemStack)result) || (count += item.field_77994_a) < this.maxItemCount) continue;
            return false;
        }
        return true;
    }
}

