/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers.storages;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import vswe.stevescarts.guis.GuiBase;
import vswe.stevescarts.helpers.IconData;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.storages.ITankHolder;

public class Tank
implements IFluidTank {
    private FluidStack fluid;
    private int tankSize;
    private ITankHolder owner;
    private int tankid;
    private boolean isLocked;

    public Tank(ITankHolder owner, int tankSize, int tankid) {
        this.owner = owner;
        this.tankSize = tankSize;
        this.tankid = tankid;
    }

    public Tank copy() {
        Tank tank = new Tank(this.owner, this.tankSize, this.tankid);
        if (this.getFluid() != null) {
            tank.setFluid(this.getFluid().copy());
        }
        return tank;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public int getCapacity() {
        return this.tankSize;
    }

    public int getTankPressure() {
        return 0;
    }

    public void containerTransfer() {
        ItemStack item = this.owner.getInputContainer(this.tankid);
        if (item != null) {
            FluidStack fluidContent2;
            ItemStack full;
            if (FluidContainerRegistry.isFilledContainer((ItemStack)item)) {
                int fill;
                FluidStack fluidContent = FluidContainerRegistry.getFluidForFilledItem((ItemStack)item);
                if (fluidContent != null && (fill = this.fill(fluidContent, false, false)) == fluidContent.amount) {
                    Item container = item.func_77973_b().func_77668_q();
                    ItemStack containerStack = null;
                    if (container != null) {
                        containerStack = new ItemStack(container, 1);
                        this.owner.addToOutputContainer(this.tankid, containerStack);
                    }
                    if (containerStack == null || containerStack.field_77994_a == 0) {
                        ItemStack itemStack = item;
                        --itemStack.field_77994_a;
                        if (item.field_77994_a <= 0) {
                            this.owner.clearInputContainer(this.tankid);
                        }
                        this.fill(fluidContent, true, false);
                    }
                }
            } else if (FluidContainerRegistry.isEmptyContainer((ItemStack)item) && (full = FluidContainerRegistry.fillFluidContainer((FluidStack)this.fluid, (ItemStack)item)) != null && (fluidContent2 = FluidContainerRegistry.getFluidForFilledItem((ItemStack)full)) != null) {
                this.owner.addToOutputContainer(this.tankid, full);
                if (full.field_77994_a == 0) {
                    ItemStack itemStack2 = item;
                    --itemStack2.field_77994_a;
                    if (item.field_77994_a <= 0) {
                        this.owner.clearInputContainer(this.tankid);
                    }
                    this.drain(fluidContent2.amount, true, false);
                }
            }
        }
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.fill(resource, doFill, false);
    }

    public int fill(FluidStack resource, boolean doFill, boolean isRemote) {
        if (resource == null || this.fluid != null && !resource.isFluidEqual(this.fluid)) {
            return 0;
        }
        int free = this.tankSize - (this.fluid == null ? 0 : this.fluid.amount);
        int fill = Math.min(free, resource.amount);
        if (doFill && !isRemote) {
            if (this.fluid == null) {
                this.fluid = resource.copy();
                this.fluid.amount = 0;
            }
            FluidStack fluid = this.fluid;
            fluid.amount += fill;
            this.owner.onFluidUpdated(this.tankid);
        }
        return fill;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain, false);
    }

    public FluidStack drain(int maxDrain, boolean doDrain, boolean isRemote) {
        if (this.fluid == null) {
            return null;
        }
        int amount = this.fluid.amount;
        int drain = Math.min(amount, maxDrain);
        FluidStack ret = this.fluid.copy();
        ret.amount = drain;
        if (doDrain && !isRemote) {
            FluidStack fluid = this.fluid;
            fluid.amount -= drain;
            if (this.fluid.amount <= 0 && !this.isLocked) {
                this.fluid = null;
            }
            this.owner.onFluidUpdated(this.tankid);
        }
        return ret;
    }

    public void setLocked(boolean val) {
        this.isLocked = val;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public String getMouseOver() {
        String name = Localization.MODULES.TANKS.EMPTY.translate(new String[0]);
        int amount = 0;
        if (this.fluid != null) {
            name = this.fluid.getFluid().getLocalizedName(this.fluid);
            if (name.indexOf(".") != -1) {
                name = FluidRegistry.getFluidName((FluidStack)this.fluid);
            }
            name = name != null && !name.equals("") ? Character.toUpperCase(name.charAt(0)) + name.substring(1) : Localization.MODULES.TANKS.INVALID.translate(new String[0]);
            amount = this.fluid.amount;
        }
        return name + "\n" + this.formatNumber(amount) + " / " + this.formatNumber(this.tankSize);
    }

    private String formatNumber(int number) {
        return String.format("%,d", number);
    }

    @Deprecated
    public static IconData getIconAndTexture(FluidStack stack) {
        return null;
    }

    private static float getColorComponent(int color, int id) {
        return (float)((color & 255 << id * 8) >> id * 8) / 255.0f;
    }

    public static void applyColorFilter(FluidStack fluid) {
        int color = fluid.getFluid().getColor(fluid);
        GL11.glColor4f((float)Tank.getColorComponent(color, 2), (float)Tank.getColorComponent(color, 1), (float)Tank.getColorComponent(color, 0), (float)1.0f);
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public void drawFluid(GuiBase gui, int startX, int startY) {
    }

    public int getFluidAmount() {
        return this.fluid == null ? 0 : this.fluid.amount;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo(this.fluid, this.getCapacity());
    }
}

