/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers;

import java.util.HashMap;
import java.util.Locale;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.blocks.BlockRailAdvDetector;
import vswe.stevescarts.blocks.ModBlocks;
import vswe.stevescarts.blocks.tileentities.TileEntityDetector;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.OperatorObject;

public enum DetectorType implements IStringSerializable
{
    NORMAL(0, true, false, true, new String[]{"detector_manager_bot", "detector_manager_top", "detector_manager_yellow", "detector_manager_blue", "detector_manager_green", "detector_manager_red"}),
    UNIT(1, false, false, false, new String[]{"detector_manager_bot", "detector_manager_bot", "detector_unit_yellow", "detector_unit_blue", "detector_unit_green", "detector_unit_red"}),
    STOP(2, true, true, false, new String[]{"detector_manager_bot", "detector_station_top", "detector_station_yellow", "detector_station_blue", "detector_station_green", "detector_station_red"}){

        @Override
        public void activate(TileEntityDetector detector, EntityMinecartModular cart) {
            cart.releaseCart();
        }
    }
    ,
    JUNCTION(3, true, false, false, new String[]{"detector_manager_bot", "detector_junction_top", "detector_junction_yellow", "detector_junction_blue", "detector_junction_green", "detector_junction_red"}){

        @Override
        public void activate(TileEntityDetector detector, EntityMinecartModular cart) {
            this.update(detector, true);
        }

        @Override
        public void deactivate(TileEntityDetector detector) {
            this.update(detector, false);
        }

        private void update(TileEntityDetector detector, boolean flag) {
            if (detector.func_145831_w().func_180495_p(detector.func_174877_v()).func_177230_c() == ModBlocks.ADVANCED_DETECTOR.getBlock()) {
                BlockPos posUp = detector.func_174877_v().func_177984_a();
                IBlockState stateUp = detector.func_145831_w().func_180495_p(posUp);
                ((BlockRailAdvDetector)ModBlocks.ADVANCED_DETECTOR.getBlock()).refreshState(detector.func_145831_w(), posUp, stateUp, flag);
            }
        }
    }
    ,
    REDSTONE(4, false, false, false, new String[]{"detector_redstone_bot", "detector_redstone_bot", "detector_redstone_yellow", "detector_redstone_blue", "detector_redstone_green", "detector_redstone_red"}){

        @Override
        public void initOperators(HashMap<Byte, OperatorObject> operators) {
            super.initOperators(operators);
            new OperatorObject.OperatorObjectRedstone(operators, 11, Localization.GUI.DETECTOR.REDSTONE, 0, 0, 0);
            new OperatorObject.OperatorObjectRedstone(operators, 12, Localization.GUI.DETECTOR.REDSTONE_TOP, 0, 1, 0);
            new OperatorObject.OperatorObjectRedstone(operators, 13, Localization.GUI.DETECTOR.REDSTONE_BOT, 0, -1, 0);
            new OperatorObject.OperatorObjectRedstone(operators, 14, Localization.GUI.DETECTOR.REDSTONE_NORTH, 0, 0, -1);
            new OperatorObject.OperatorObjectRedstone(operators, 15, Localization.GUI.DETECTOR.REDSTONE_WEST, -1, 0, 0);
            new OperatorObject.OperatorObjectRedstone(operators, 16, Localization.GUI.DETECTOR.REDSTONE_SOUTH, 0, 0, 1);
            new OperatorObject.OperatorObjectRedstone(operators, 17, Localization.GUI.DETECTOR.REDSTONE_EAST, 1, 0, 0);
        }
    };

    private int meta;
    private String[] textures;
    private boolean acceptCart;
    private boolean stopCart;
    private boolean emitRedstone;
    private HashMap<Byte, OperatorObject> operators;
    public static PropertyEnum<DetectorType> SATE;
    public static PropertyBool POWERED;

    private DetectorType(int meta, boolean acceptCart, boolean stopCart, boolean emitRedstone, String[] textures) {
        this.meta = meta;
        this.textures = textures;
        this.acceptCart = acceptCart;
        this.stopCart = stopCart;
        this.emitRedstone = emitRedstone;
    }

    public int getMeta() {
        return this.meta;
    }

    public String getTranslatedName() {
        StringBuilder append = new StringBuilder().append("item.");
        StevesCarts instance = StevesCarts.instance;
        return I18n.func_74838_a((String)append.append("SC2:").append("BlockDetector").append(this.meta).append(".name").toString());
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public boolean canInteractWithCart() {
        return this.acceptCart;
    }

    public boolean shouldStopCart() {
        return this.stopCart;
    }

    public boolean shouldEmitRedstone() {
        return this.emitRedstone;
    }

    public void activate(TileEntityDetector detector, EntityMinecartModular cart) {
    }

    public void deactivate(TileEntityDetector detector) {
    }

    public static DetectorType getTypeFromSate(IBlockState state) {
        return (DetectorType)((Object)state.func_177229_b(SATE));
    }

    public static DetectorType getTypeFromint(int meta) {
        return DetectorType.values()[meta];
    }

    public void initOperators(HashMap<Byte, OperatorObject> operators) {
        this.operators = operators;
    }

    public HashMap<Byte, OperatorObject> getOperators() {
        return this.operators;
    }

    static {
        SATE = PropertyEnum.func_177709_a((String)"detectortype", DetectorType.class);
        POWERED = PropertyBool.func_177716_a((String)"powered");
    }
}

