/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.guis;

import java.util.ArrayList;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiBase;
import vswe.stevescarts.helpers.ModuleCountPair;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.ModuleBase;

@SideOnly(value=Side.CLIENT)
public class GuiMinecart
extends GuiBase {
    private static ResourceLocation textureLeft = ResourceHelper.getResource("/gui/guiBase1.png");
    private static ResourceLocation textureRight = ResourceHelper.getResource("/gui/guiBase2.png");
    public static ResourceLocation moduleTexture = ResourceHelper.getResourceFromPath("/atlas/items.png");
    private boolean isScrolling;
    private int[] scrollBox = new int[]{450, 15, 18, 225};
    private EntityMinecartModular cart;

    public GuiMinecart(InventoryPlayer invPlayer, EntityMinecartModular cart) {
        super(cart.getCon(invPlayer));
        this.setup(cart);
    }

    protected void setup(EntityMinecartModular cart) {
        this.cart = cart;
        this.setXSize(478);
        this.setYSize(256);
    }

    @Override
    public void drawGuiForeground(int x, int y) {
        GL11.glDisable((int)2896);
        if (this.cart.getModules() != null) {
            ModuleBase thief = this.cart.getInterfaceThief();
            if (thief != null) {
                this.drawModuleForeground(thief);
                this.drawModuleMouseOver(thief, x, y);
            } else {
                for (ModuleBase module : this.cart.getModules()) {
                    this.drawModuleForeground(module);
                }
                this.renderModuleListText(x, y);
                for (ModuleBase module : this.cart.getModules()) {
                    this.drawModuleMouseOver(module, x, y);
                }
                this.renderModuleListMouseOver(x, y);
            }
        }
        GL11.glEnable((int)2896);
    }

    @Override
    public void drawGuiBackground(float f, int x, int y) {
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int j = this.getGuiLeft();
        int k = this.getGuiTop();
        ResourceHelper.bindResource(textureLeft);
        this.func_73729_b(j, k, 0, 0, 256, this.field_147000_g);
        ResourceHelper.bindResource(textureRight);
        this.func_73729_b(j + 256, k, 0, 0, this.field_146999_f - 256, this.field_147000_g);
        ModuleBase thief = this.cart.getInterfaceThief();
        if (thief != null) {
            this.drawModuleSlots(thief);
            this.drawModuleBackground(thief, x, y);
            this.drawModuleBackgroundItems(thief, x, y);
            for (ModuleBase module : this.cart.getModules()) {
                if (!module.hasGui() || !module.hasSlots()) continue;
                ArrayList<SlotBase> slotsList = module.getSlots();
                for (SlotBase slot : slotsList) {
                    this.resetSlot(slot);
                }
            }
        } else if (this.cart.getModules() != null) {
            this.func_73729_b(j + this.scrollBox[0], k + this.scrollBox[1], 222, 24, this.scrollBox[2], this.scrollBox[3]);
            this.func_73729_b(j + this.scrollBox[0] + 2, k + this.scrollBox[1] + 2 + this.cart.getScrollY(), 240, 26 + (this.cart.canScrollModules ? 0 : 25), 14, 25);
            for (ModuleBase module : this.cart.getModules()) {
                this.drawModuleSlots(module);
            }
            for (ModuleBase module : this.cart.getModules()) {
                this.drawModuleBackground(module, x, y);
            }
            this.renderModuleList(x, y);
            for (ModuleBase module : this.cart.getModules()) {
                this.drawModuleBackgroundItems(module, x, y);
            }
        }
        GL11.glEnable((int)2896);
    }

    private void renderModuleList(int x, int y) {
        x -= this.getGuiLeft();
        y -= this.getGuiTop();
        ArrayList<ModuleCountPair> moduleCounts = this.cart.getModuleCounts();
        GL11.glEnable((int)3042);
        for (int i = 0; i < moduleCounts.size(); ++i) {
            ModuleCountPair count = moduleCounts.get(i);
            float alpha = this.inRect(x, y, this.getModuleDisplayX(i), this.getModuleDisplayY(i), 16, 16) ? 1.0f : 0.5f;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            this.drawModuleIcon(count.getData(), this.getGuiLeft() + this.getModuleDisplayX(i), this.getGuiTop() + this.getModuleDisplayY(i), 1.0f, 1.0f, 0.0f, 0.0f);
        }
        GL11.glDisable((int)3042);
    }

    private void renderModuleListText(int x, int y) {
        x -= this.getGuiLeft();
        y -= this.getGuiTop();
        ArrayList<ModuleCountPair> moduleCounts = this.cart.getModuleCounts();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getFontRenderer().func_78276_b(this.cart.getCartName(), 5, 172, 0x404040);
        GL11.glEnable((int)3042);
        for (int i = 0; i < moduleCounts.size(); ++i) {
            ModuleCountPair count = moduleCounts.get(i);
            if (count.getCount() == 1) continue;
            int alpha = (int)((this.inRect(x, y, this.getModuleDisplayX(i), this.getModuleDisplayY(i), 16, 16) ? 1.0f : 0.75f) * 256.0f);
            String str = String.valueOf(count.getCount());
            this.getFontRenderer().func_175063_a(str, (float)(this.getModuleDisplayX(i) + 16 - this.getFontRenderer().func_78256_a(str)), (float)(this.getModuleDisplayY(i) + 8), 0xFFFFFF | alpha << 24);
        }
        GL11.glDisable((int)3042);
    }

    private void renderModuleListMouseOver(int x, int y) {
        x -= this.getGuiLeft();
        y -= this.getGuiTop();
        ArrayList<ModuleCountPair> moduleCounts = this.cart.getModuleCounts();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < moduleCounts.size(); ++i) {
            ModuleCountPair count = moduleCounts.get(i);
            if (!this.inRect(x, y, this.getModuleDisplayX(i), this.getModuleDisplayY(i), 16, 16)) continue;
            this.drawMouseOver(count.toString(), x, y);
        }
    }

    private int getModuleDisplayX(int id) {
        return id % 8 * 18 + 7;
    }

    private int getModuleDisplayY(int id) {
        return id / 8 * 18 + 182;
    }

    @Override
    public void mouseClick(int x, int y, int button) {
        super.mouseClick(x, y, button);
        ModuleBase thief = this.cart.getInterfaceThief();
        if (thief != null) {
            this.handleModuleMouseClicked(thief, x, y, button);
        } else if (this.cart.getModules() != null) {
            if (this.inRect(x - this.getGuiLeft(), y - this.getGuiTop(), this.scrollBox[0], this.scrollBox[1], this.scrollBox[2], this.scrollBox[3])) {
                this.isScrolling = true;
            }
            for (ModuleBase module : this.cart.getModules()) {
                this.handleModuleMouseClicked(module, x, y, button);
            }
        }
    }

    protected boolean inRect(int x, int y, int x1, int y1, int sizeX, int sizeY) {
        return x >= x1 && x <= x1 + sizeX && y >= y1 && y <= y1 + sizeY;
    }

    @Override
    public void mouseMoved(int x, int y, int button) {
        super.mouseMoved(x, y, button);
        if (this.isScrolling) {
            int temp = y - this.getGuiTop() - 12 - (this.scrollBox[1] + 2);
            if (temp < 0) {
                temp = 0;
            } else if (temp > 198) {
                temp = 198;
            }
            this.cart.setScrollY(temp);
        }
        if (button != -1) {
            this.isScrolling = false;
        }
        if (this.cart.getModules() != null) {
            ModuleBase thief = this.cart.getInterfaceThief();
            if (thief != null) {
                this.handleModuleMouseMoved(thief, x, y, button);
            } else {
                for (ModuleBase module : this.cart.getModules()) {
                    this.handleModuleMouseMoved(module, x, y, button);
                }
            }
        }
    }

    @Override
    public void keyPress(char character, int extraInformation) {
        super.keyPress(character, extraInformation);
        if (this.cart.getModules() != null) {
            ModuleBase thief = this.cart.getInterfaceThief();
            if (thief != null) {
                this.handleModuleKeyPress(thief, character, extraInformation);
            } else {
                for (ModuleBase module : this.cart.getModules()) {
                    this.handleModuleKeyPress(module, character, extraInformation);
                }
            }
        }
    }

    @Override
    public boolean disableStandardKeyFunctionality() {
        if (this.cart.getModules() != null) {
            ModuleBase thief = this.cart.getInterfaceThief();
            if (thief != null) {
                return thief.disableStandardKeyFunctionality();
            }
            for (ModuleBase module : this.cart.getModules()) {
                if (!module.disableStandardKeyFunctionality()) continue;
                return true;
            }
        }
        return false;
    }

    private void drawModuleForeground(ModuleBase module) {
        if (module.hasGui()) {
            module.drawForeground(this);
            if (module.useButtons()) {
                module.drawButtonText(this);
            }
        }
    }

    private void drawModuleMouseOver(ModuleBase module, int x, int y) {
        if (module.hasGui()) {
            module.drawMouseOver(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
            if (module.useButtons()) {
                module.drawButtonOverlays(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
            }
        }
    }

    private void drawModuleSlots(ModuleBase module) {
        if (module.hasGui() && module.hasSlots()) {
            ArrayList<SlotBase> slotsList = module.getSlots();
            for (SlotBase slot : slotsList) {
                boolean drawAll;
                int[] rect = new int[]{slot.getX() + 1, slot.getY() + 1, 16, 16};
                module.handleScroll(rect);
                boolean bl = drawAll = rect[3] == 16;
                if (drawAll) {
                    slot.field_75223_e = slot.getX() + module.getX() + 1;
                    slot.field_75221_f = slot.getY() + module.getY() + 1 - this.cart.getRealScrollY();
                } else {
                    this.resetSlot(slot);
                }
                module.drawImage(this, slot.getX(), slot.getY(), this.field_146999_f - 256, 0, 18, 18);
                if (drawAll) continue;
                module.drawImage(this, slot.getX() + 1, slot.getY() + 1, this.field_146999_f - 256 + 18, 1, 16, 16);
            }
        }
    }

    private void resetSlot(SlotBase slot) {
        slot.field_75223_e = -9001;
        slot.field_75221_f = -9001;
    }

    private void drawModuleBackground(ModuleBase module, int x, int y) {
        if (module.hasGui()) {
            module.drawBackground(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
            if (module.useButtons()) {
                module.drawButtons(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
            }
        }
    }

    private void drawModuleBackgroundItems(ModuleBase module, int x, int y) {
        if (module.hasGui()) {
            module.drawBackgroundItems(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
        }
    }

    private void handleModuleMouseClicked(ModuleBase module, int x, int y, int button) {
        module.mouseClicked(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY(), button);
        if (module.useButtons()) {
            module.mouseClickedButton(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY(), button);
        }
    }

    private void handleModuleMouseMoved(ModuleBase module, int x, int y, int button) {
        module.mouseMovedOrUp(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY(), button);
    }

    private void handleModuleKeyPress(ModuleBase module, char character, int extraInformation) {
        module.keyPress(this, character, extraInformation);
    }
}

