/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.compat.minecraft;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.oredict.OreDictionary;
import vswe.stevescarts.api.farms.EnumHarvestResult;
import vswe.stevescarts.api.farms.ITreeModule;
import vswe.stevescarts.entitys.EntityMinecartModular;

public class DefaultTreeModule
implements ITreeModule {
    @Override
    public EnumHarvestResult isLeaves(IBlockState blockState, BlockPos pos, EntityMinecartModular cart) {
        return blockState.func_177230_c().isLeaves(blockState, (IBlockAccess)cart.field_70170_p, pos) ? EnumHarvestResult.ALLOW : EnumHarvestResult.SKIP;
    }

    @Override
    public EnumHarvestResult isWood(IBlockState blockState, BlockPos pos, EntityMinecartModular cart) {
        return blockState.func_177230_c().isWood((IBlockAccess)cart.field_70170_p, pos) ? EnumHarvestResult.ALLOW : EnumHarvestResult.SKIP;
    }

    @Override
    public boolean isSapling(ItemStack sapling) {
        if (sapling != null) {
            if (this.isStackSapling(sapling)) {
                return true;
            }
            if (sapling.func_77973_b() instanceof ItemBlock) {
                Block b = Block.func_149634_a((Item)sapling.func_77973_b());
                return b instanceof BlockSapling || b != null && this.isStackSapling(new ItemStack(b, 1, Short.MAX_VALUE));
            }
        }
        return false;
    }

    @Override
    public boolean plantSapling(World world, BlockPos pos, ItemStack stack, FakePlayer fakePlayer) {
        return stack.func_77973_b().func_180614_a(stack, (EntityPlayer)fakePlayer, world, pos, EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f) == EnumActionResult.SUCCESS;
    }

    private boolean isStackSapling(ItemStack sapling) {
        int[] ids;
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)sapling)) {
            String name = OreDictionary.getOreName((int)id);
            if (name == null || !name.startsWith("treeSapling")) continue;
            return true;
        }
        return false;
    }
}

