/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks.tileentities;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.blocks.tileentities.TileEntityBase;
import vswe.stevescarts.containers.ContainerActivator;
import vswe.stevescarts.containers.ContainerBase;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiActivator;
import vswe.stevescarts.guis.GuiBase;
import vswe.stevescarts.helpers.ActivatorOption;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.modules.addons.ModuleChunkLoader;
import vswe.stevescarts.modules.addons.ModuleInvisible;
import vswe.stevescarts.modules.addons.ModuleShield;
import vswe.stevescarts.modules.realtimers.ModuleCage;
import vswe.stevescarts.modules.workers.tools.ModuleDrill;

public class TileEntityActivator
extends TileEntityBase {
    private ArrayList<ActivatorOption> options;

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiBase getGui(InventoryPlayer inv) {
        return new GuiActivator(inv, this);
    }

    @Override
    public ContainerBase getContainer(InventoryPlayer inv) {
        return new ContainerActivator((IInventory)inv, this);
    }

    public TileEntityActivator() {
        this.loadOptions();
    }

    private void loadOptions() {
        this.options = new ArrayList<ActivatorOption>();
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_DRILL, ModuleDrill.class));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_SHIELD, ModuleShield.class));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_INVISIBILITY, ModuleInvisible.class));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_CHUNK, ModuleChunkLoader.class));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_CAGE_AUTO, ModuleCage.class, 0));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_CAGE, ModuleCage.class, 1));
    }

    public ArrayList<ActivatorOption> getOptions() {
        return this.options;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        for (ActivatorOption option : this.options) {
            option.setOption(nbttagcompound.func_74771_c(option.getName()));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        for (ActivatorOption option : this.options) {
            nbttagcompound.func_74774_a(option.getName(), (byte)option.getOption());
        }
        return nbttagcompound;
    }

    @Override
    public void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            boolean leftClick = (data[0] & 1) == 0;
            int optionId = (data[0] & 0xFFFFFFFE) >> 1;
            if (optionId >= 0 && optionId < this.options.size()) {
                this.options.get(optionId).changeOption(leftClick);
            }
        }
    }

    @Override
    public void initGuiData(Container con, IContainerListener crafting) {
        for (int i = 0; i < this.options.size(); ++i) {
            this.updateGuiData(con, crafting, i, (short)this.options.get(i).getOption());
        }
    }

    @Override
    public void checkGuiData(Container con, IContainerListener crafting) {
        for (int i = 0; i < this.options.size(); ++i) {
            int lastoption;
            int option = this.options.get(i).getOption();
            if (option == (lastoption = ((ContainerActivator)con).lastOptions.get(i).intValue())) continue;
            this.updateGuiData(con, crafting, i, (short)option);
            ((ContainerActivator)con).lastOptions.set(i, option);
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id >= 0 && id < this.options.size()) {
            this.options.get(id).setOption(data);
        }
    }

    public void handleCart(EntityMinecartModular cart, boolean isOrange) {
        for (ActivatorOption option : this.options) {
            if (option.isDisabled()) continue;
            cart.handleActivator(option, isOrange);
        }
    }
}

