/*
 * Decompiled with CFR 0.152.
 */
package com.pengu.hammercore.client.model.simple;

import com.mrdimka.hammercore.math.ExpressionEvaluator;
import com.mrdimka.hammercore.math.functions.ExpressionFunction;
import com.pengu.hammercore.utils.NPEUtils;
import com.pengu.hammercore.utils.UnmodifiableList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.ArrayUtils;

public class SimpleModelParser {
    public static final ThreadLocal<ByteBuffer> buf = ThreadLocal.withInitial(() -> ByteBuffer.allocate(8));

    public static UnmodifiableList<int[]> toOpcodes(String model) {
        String[] lines;
        int[] node = null;
        ArrayList<int[]> nodes = new ArrayList<int[]>();
        model = model.replaceAll("\r", "");
        for (String s : lines = model.split("\n")) {
            Object dir;
            if (s.equals("{")) {
                if (node == null) {
                    node = new int[]{};
                    continue;
                }
                throw new RuntimeException("unterminated node " + Arrays.toString(node));
            }
            if (s.equals("}")) {
                NPEUtils.checkNotNull(node, "node");
                nodes.add(node);
                node = null;
                continue;
            }
            if (s.startsWith("name ")) {
                NPEUtils.checkNotNull(node, "node");
                String name = s.substring(5);
                byte[] bt = name.getBytes();
                int[] ir = new int[bt.length + 2];
                ir[0] = 8;
                ir[1] = bt.length;
                for (int i = 0; i < bt.length; ++i) {
                    ir[i + 2] = bt[i];
                }
                node = ArrayUtils.addAll((int[])node, (int[])ir);
                continue;
            }
            if (s.startsWith("texture ")) {
                NPEUtils.checkNotNull(node, "node");
                dir = s.substring(8, 10);
                int op = 0;
                if (((String)dir).equals("x-")) {
                    op = EnumFacing.WEST.ordinal();
                } else if (((String)dir).equals("x+")) {
                    op = EnumFacing.EAST.ordinal();
                } else if (((String)dir).equals("y-")) {
                    op = EnumFacing.DOWN.ordinal();
                } else if (((String)dir).equals("y+")) {
                    op = EnumFacing.UP.ordinal();
                } else if (((String)dir).equals("z-")) {
                    op = EnumFacing.NORTH.ordinal();
                } else if (((String)dir).equals("z+")) {
                    op = EnumFacing.SOUTH.ordinal();
                } else {
                    NPEUtils.checkNotNull(null, "unknown orientation: " + (String)dir);
                }
                byte[] bt = s.substring(11).getBytes();
                int[] ir = new int[bt.length + 3];
                ir[0] = 7;
                ir[1] = bt.length;
                ir[2] = op;
                for (int i = 0; i < bt.length; ++i) {
                    ir[i + 3] = bt[i];
                }
                node = ArrayUtils.addAll((int[])node, (int[])ir);
                continue;
            }
            if (s.startsWith("textures ")) {
                NPEUtils.checkNotNull(node, "node");
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    byte[] bt = s.substring(9).getBytes();
                    int[] ir = new int[bt.length + 3];
                    ir[0] = 7;
                    ir[1] = bt.length;
                    ir[2] = face.ordinal();
                    for (int i = 0; i < bt.length; ++i) {
                        ir[i + 3] = bt[i];
                    }
                    node = ArrayUtils.addAll((int[])node, (int[])ir);
                }
                continue;
            }
            if (s.startsWith("disable face ")) {
                NPEUtils.checkNotNull(node, "node");
                dir = s.substring(13, 15);
                int op = 0;
                if (((String)dir).equals("x-")) {
                    op = EnumFacing.WEST.ordinal();
                } else if (((String)dir).equals("x+")) {
                    op = EnumFacing.EAST.ordinal();
                } else if (((String)dir).equals("y-")) {
                    op = EnumFacing.DOWN.ordinal();
                } else if (((String)dir).equals("y+")) {
                    op = EnumFacing.UP.ordinal();
                } else if (((String)dir).equals("z-")) {
                    op = EnumFacing.NORTH.ordinal();
                } else if (((String)dir).equals("z+")) {
                    op = EnumFacing.SOUTH.ordinal();
                } else {
                    NPEUtils.checkNotNull(null, "unknown orientation: " + (String)dir);
                }
                node = ArrayUtils.addAll((int[])node, (int[])new int[]{0, op});
                continue;
            }
            if (s.equals("disable faces")) {
                NPEUtils.checkNotNull(node, "node");
                node = ArrayUtils.add((int[])node, (int)5);
                continue;
            }
            if (s.startsWith("enable face ")) {
                NPEUtils.checkNotNull(node, "node");
                dir = s.substring(12, 14);
                int op = 0;
                if (((String)dir).equals("x-")) {
                    op = EnumFacing.WEST.ordinal();
                } else if (((String)dir).equals("x+")) {
                    op = EnumFacing.EAST.ordinal();
                } else if (((String)dir).equals("y-")) {
                    op = EnumFacing.DOWN.ordinal();
                } else if (((String)dir).equals("y+")) {
                    op = EnumFacing.UP.ordinal();
                } else if (((String)dir).equals("z-")) {
                    op = EnumFacing.NORTH.ordinal();
                } else if (((String)dir).equals("z+")) {
                    op = EnumFacing.SOUTH.ordinal();
                } else {
                    NPEUtils.checkNotNull(null, "unknown orientation: " + (String)dir);
                }
                node = ArrayUtils.addAll((int[])node, (int[])new int[]{1, op});
                continue;
            }
            if (s.equals("enable faces")) {
                NPEUtils.checkNotNull(node, "node");
                node = ArrayUtils.add((int[])node, (int)6);
                continue;
            }
            if (s.startsWith("color ")) {
                NPEUtils.checkNotNull(node, "node");
                String[] c = s.substring(6).split(" ");
                node = ArrayUtils.addAll((int[])node, (int[])new int[]{2, Integer.parseInt(c[0]), Integer.parseInt(c[1]), Integer.parseInt(c[2]), c.length == 3 ? 255 : Integer.parseInt(c[3])});
                continue;
            }
            if (s.startsWith("bounds ")) {
                NPEUtils.checkNotNull(node, "node");
                String[] bds = s.substring(7).split(" ");
                node = ArrayUtils.add((int[])node, (int)3);
                node = SimpleModelParser.addDouble(node, ExpressionEvaluator.evaluateDouble(bds[0], new ExpressionFunction[0]));
                node = SimpleModelParser.addDouble(node, ExpressionEvaluator.evaluateDouble(bds[1], new ExpressionFunction[0]));
                node = SimpleModelParser.addDouble(node, ExpressionEvaluator.evaluateDouble(bds[2], new ExpressionFunction[0]));
                node = SimpleModelParser.addDouble(node, ExpressionEvaluator.evaluateDouble(bds[3], new ExpressionFunction[0]));
                node = SimpleModelParser.addDouble(node, ExpressionEvaluator.evaluateDouble(bds[4], new ExpressionFunction[0]));
                node = SimpleModelParser.addDouble(node, ExpressionEvaluator.evaluateDouble(bds[5], new ExpressionFunction[0]));
                continue;
            }
            if (!s.equals("draw")) continue;
            NPEUtils.checkNotNull(node, "node");
            node = ArrayUtils.addAll((int[])node, (int[])new int[]{4});
        }
        return new UnmodifiableList<int[]>(nodes);
    }

    public static int[] addDouble(int[] array, double d) {
        ByteBuffer b = buf.get();
        b.position(0);
        b.putDouble(d);
        b.position(0);
        int int1 = b.getInt();
        int int2 = b.getInt();
        return ArrayUtils.addAll((int[])array, (int[])new int[]{int1, int2});
    }

    public static double getDouble(int[] array, int pos) {
        ByteBuffer b = buf.get();
        b.position(0);
        b.putInt(array[pos]);
        b.putInt(array[pos + 1]);
        b.position(0);
        return b.getDouble();
    }
}

