/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.net.pkt;

import com.mrdimka.hammercore.common.utils.StrPos;
import com.mrdimka.hammercore.common.utils.WorldUtil;
import com.mrdimka.hammercore.net.packetAPI.IPacket;
import com.mrdimka.hammercore.net.packetAPI.IPacketListener;
import com.mrdimka.hammercore.tile.TileSyncable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSyncSyncableTile
implements IPacket,
IPacketListener<PacketSyncSyncableTile, IPacket> {
    private String pos;
    private int world;
    private NBTTagCompound nbt;

    public PacketSyncSyncableTile() {
    }

    public PacketSyncSyncableTile(TileSyncable tile) {
        this.nbt = tile.func_189517_E_();
        this.pos = StrPos.toStr(tile.func_174877_v());
        this.world = tile.func_145831_w().field_73011_w.getDimension();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("data", (NBTBase)this.nbt);
        nbt.func_74778_a("pos", this.pos);
        nbt.func_74768_a("dim", this.world);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.nbt = nbt.func_74775_l("data");
        this.pos = nbt.func_74779_i("pos");
        this.world = nbt.func_74762_e("dim");
    }

    @Override
    public IPacket onArrived(PacketSyncSyncableTile packet, MessageContext context) {
        TileSyncable sync;
        World world = WorldUtil.getWorld(context, packet.world);
        BlockPos pos = StrPos.fromStr(packet.pos);
        if (world != null && world.func_175707_a(pos, pos) && (sync = WorldUtil.cast(world.func_175625_s(pos), TileSyncable.class)) != null) {
            sync.handleUpdateTag(packet.nbt);
        }
        return null;
    }
}

