/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.common.utils;

import com.mrdimka.hammercore.HammerCore;
import com.mrdimka.hammercore.common.utils.BlankTeleporter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class WorldUtil {
    public static <T> T cast(Object obj, Class<T> to) {
        if (obj != null && to.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        return null;
    }

    public static World getWorld(MessageContext context, int dim) {
        return HammerCore.renderProxy.getWorld(context, dim);
    }

    public static NBTTagList saveInv(IInventory inventory) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            NBTTagCompound nbt = new NBTTagCompound();
            inventory.func_70301_a(i).func_77955_b(nbt);
            nbt.func_74768_a("Slot", i);
            list.func_74742_a((NBTBase)nbt);
        }
        return list;
    }

    public static void readInv(NBTTagList list, IInventory inv) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            inv.func_70299_a(nbt.func_74762_e("Slot"), ItemStack.func_77949_a((NBTTagCompound)nbt));
        }
    }

    public static void spawnItemStack(World worldIn, double x, double y, double z, ItemStack stackIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        EntityItem entityItem = new EntityItem(worldIn, x, y, z, stackIn);
        entityItem.field_70159_w = 0.0;
        entityItem.field_70179_y = 0.0;
        worldIn.func_72838_d((Entity)entityItem);
    }

    public static void spawnItemStack(World worldIn, BlockPos pos, ItemStack stackIn) {
        WorldUtil.spawnItemStack(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stackIn);
    }

    public static void teleportPlayer(EntityPlayerMP mp, int dim, double x, double y, double z) {
        if (!mp.field_70170_p.field_72995_K) {
            if (mp.field_70170_p.field_73011_w.getDimension() != dim) {
                MinecraftServer server = mp.field_71133_b;
                WorldServer nev = server.func_71218_a(dim);
                server.func_184103_al().transferPlayerToDimension(mp, dim, (Teleporter)new BlankTeleporter(nev));
            }
            mp.func_70634_a(x, y, z);
        }
    }

    public static void teleportEntity(Entity ent, int dim, double x, double y, double z) {
        if (!ent.field_70170_p.field_72995_K) {
            if (ent.field_70170_p.field_73011_w.getDimension() != dim) {
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                WorldServer old = server.func_71218_a(ent.field_70170_p.field_73011_w.getDimension());
                WorldServer nev = server.func_71218_a(dim);
                server.func_184103_al().transferEntityToWorld(ent, ent.field_70170_p.field_73011_w.getDimension(), old, nev, (Teleporter)new BlankTeleporter(nev));
            }
            ent.func_70634_a(x, y, z);
        }
    }

    public static void teleportEntity(Entity ent, double x, double y, double z) {
        WorldUtil.teleportEntity(ent, ent.field_70170_p.field_73011_w.getDimension(), x, y, z);
    }

    public static void teleportEntity(Entity ent, int dim) {
        WorldUtil.teleportEntity(ent, dim, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
    }
}

