/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.common.match.item;

import com.google.common.base.Predicate;
import com.mrdimka.hammercore.common.match.item.ItemMatchParams;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class ItemContainer
implements Predicate<ItemStack> {
    private final String item;
    private final int count;
    private final int damage;
    private final String nbt;
    private final String oredictNames;
    private final String mod;
    private final byte type;
    ItemMatchParams defParams = new ItemMatchParams().setUseOredict(true);

    public static ItemContainer create(ItemStack stack) {
        return new ItemContainer(stack);
    }

    public static ItemContainer create(String od) {
        return new ItemContainer(od);
    }

    private ItemContainer(ItemStack stack) {
        this.item = stack.func_77973_b().getRegistryName().toString();
        this.count = stack.field_77994_a;
        this.nbt = stack.func_77978_p() + "";
        int[] oredicts = OreDictionary.getOreIDs((ItemStack)stack);
        String ods = "";
        for (int i : oredicts) {
            ods = ods + OreDictionary.getOreName((int)i) + ";";
        }
        if (ods.endsWith(";")) {
            ods = ods.substring(0, ods.length() - 1);
        }
        this.oredictNames = ods;
        this.mod = stack.func_77973_b().getRegistryName().func_110624_b();
        this.damage = stack.func_77952_i();
        this.type = 0;
    }

    private ItemContainer(String oredict) {
        this.oredictNames = oredict;
        this.item = null;
        this.count = 0;
        this.damage = -1;
        this.nbt = null;
        this.mod = null;
        this.type = 1;
    }

    public int getCount() {
        return this.count;
    }

    public int getDamage() {
        return this.damage == -1 ? Short.MAX_VALUE : this.damage;
    }

    public Object getItem() {
        return this.item != null ? Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this.item)) : this.oredictNames.split(";");
    }

    public boolean matches(ItemContainer other, ItemMatchParams params) {
        boolean modOK = !params.useMod || this.mod != null && other.mod != null && other.mod.equals(this.mod);
        boolean nbtOK = !params.useNBT || this.nbt != null && other.nbt != null && other.nbt.equals(this.nbt);
        boolean dmgOK = !params.useDamage || this.damage == other.damage || this.damage == -1 || other.damage == -1 || this.damage == Short.MAX_VALUE || other.damage == Short.MAX_VALUE;
        boolean itmOK = ItemContainer.itemsMatch(this.item, other.item);
        boolean ctnOK = !params.useCount || this.count == other.count;
        boolean ordOK = params.useOredict && ItemContainer.oredictMatches(this.oredictNames, other.oredictNames);
        return ordOK || modOK && nbtOK && dmgOK && itmOK && ctnOK;
    }

    public boolean matches(ItemStack stack, ItemMatchParams params) {
        return this.matches(new ItemContainer(stack), params);
    }

    private static boolean itemsMatch(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    private static boolean oredictMatches(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        for (String as : a.split(";")) {
            if (!b.contains(as)) continue;
            return true;
        }
        return false;
    }

    public byte getType() {
        return this.type;
    }

    public boolean apply(ItemStack input) {
        return this.matches(input, this.defParams);
    }
}

