/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.client.model;

import com.mrdimka.hammercore.client.model.CasedModel;
import com.mrdimka.hammercore.client.model.SimpleModelLoader;
import com.mrdimka.hammercore.client.model.file.ModelCube;
import com.mrdimka.hammercore.client.model.file.ModelPart;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.client.model.ModelRenderer;

public class CasedModelLoader {
    public static CasedModel convert(String raw, boolean ignoreIssues) throws SimpleModelLoader.ModelLoadingException {
        raw = raw.replaceAll("\r\n", "\n");
        CasedModel model = new CasedModel();
        String[] lines = raw.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (!lines[i].contains("#")) continue;
            lines[i] = lines[i].substring(0, lines[i].indexOf("#"));
        }
        ModelPart current = null;
        String condition = "";
        int ln = 0;
        for (String line : lines) {
            String l = line.toLowerCase().replaceAll("\n", "");
            ++ln;
            try {
                float[] xyz;
                String[] args;
                String l0;
                if (l.isEmpty()) continue;
                if (l.startsWith("texturewidth ")) {
                    model.textureWidth = Integer.parseInt(l.substring("texturewidth ".length()));
                }
                if (l.startsWith("textureheight ")) {
                    model.textureHeight = Integer.parseInt(l.substring("textureheight ".length()));
                }
                if (l.equals("start")) {
                    if (current != null) {
                        throw new SimpleModelLoader.ModelLoadingException("Unexpected start: previous part not ended!");
                    }
                    current = new ModelPart();
                    condition = "";
                }
                if (l.startsWith("conditions ")) {
                    condition = l.substring("conditions ".length());
                }
                if (l.startsWith("addbox ")) {
                    l0 = l.substring("addbox ".length());
                    args = l0.trim().split(" ");
                    if (current == null) {
                        throw new SimpleModelLoader.ModelLoadingExceptionMessage("Unexpected box: Cannot add box to nothing!");
                    }
                    xyz = CasedModelLoader.parseFloats(3, args);
                    int[] size = CasedModelLoader.parseInts(3, Arrays.copyOfRange(args, 3, args.length));
                    current.addBox(xyz[0], xyz[1], xyz[2], size[0], size[1], size[2]);
                }
                if (l.startsWith("rotationpoint ")) {
                    l0 = l.substring("rotationpoint ".length());
                    args = l0.trim().split(" ");
                    if (current == null) {
                        throw new SimpleModelLoader.ModelLoadingExceptionMessage("Unexpected box: Cannot set rotation point to nothing!");
                    }
                    xyz = CasedModelLoader.parseFloats(3, args);
                    current.setRotationPoint(xyz[0], xyz[1], xyz[2]);
                }
                if (l.startsWith("texturesize ")) {
                    l0 = l.substring("texturesize ".length());
                    args = l0.trim().split(" ");
                    if (current == null) {
                        throw new SimpleModelLoader.ModelLoadingExceptionMessage("Unexpected box: Cannot set texture size to nothing!");
                    }
                    float[] xy = CasedModelLoader.parseFloats(2, args);
                    current.textureWidth = xy[0];
                    current.textureHeight = xy[1];
                }
                if (l.startsWith("mirror ")) {
                    l0 = l.substring("mirror ".length());
                    args = l0.trim().split(" ");
                    if (current == null) {
                        throw new SimpleModelLoader.ModelLoadingExceptionMessage("Unexpected box: Cannot set mirror to nothing!");
                    }
                    boolean[] mirror = CasedModelLoader.parseBooleans(1, args);
                    current.mirror = mirror[0];
                }
                if (!l.equals("end")) continue;
                if (current == null) {
                    throw new SimpleModelLoader.ModelLoadingException("Unexpected end: Cannot end nothing!");
                }
                model.addBox(current, condition);
                condition = "";
                current = null;
            }
            catch (Throwable err) {
                String msg = "Can't parse model line #" + ln + ": " + err.getClass().getName() + " > " + err.getMessage();
                if (err instanceof SimpleModelLoader.ModelLoadingException) {
                    msg = "Can't parse model line #" + ln + ": " + err.getMessage();
                }
                if (ignoreIssues) {
                    System.err.println(msg);
                    continue;
                }
                throw new SimpleModelLoader.ModelLoadingException(msg);
            }
        }
        return model;
    }

    public static String convert(CasedModel model) {
        String parsed = "";
        parsed = parsed + CasedModelLoader.ln("# This model was created by HammerCore 1.9.4.3 (author: MrDimka's Studio).");
        parsed = parsed + CasedModelLoader.ln();
        parsed = parsed + CasedModelLoader.ln("# This part sets texture size for renderer.");
        parsed = parsed + CasedModelLoader.ln("TextureWidth " + model.textureWidth);
        parsed = parsed + CasedModelLoader.ln("TextureHeight " + model.textureHeight);
        for (ModelPart part : model.PREDICATES.keySet()) {
            Set<ModelCube> boxes = part.boxes;
            if (boxes == null || boxes.isEmpty()) continue;
            parsed = parsed + CasedModelLoader.ln();
            parsed = parsed + CasedModelLoader.ln("# New Model Part Definition" + (part.name != null && !part.name.isEmpty() ? ", Part Name: " + part.name : "."));
            parsed = parsed + CasedModelLoader.ln("start");
            parsed = parsed + CasedModelLoader.ln("conditions " + model.PREDICATES.get(part));
            parsed = parsed + CasedModelLoader.ln("rotationPoint " + part.rotationPointX + " " + part.rotationPointY + " " + part.rotationPointZ);
            parsed = parsed + CasedModelLoader.ln("textureSize " + part.textureWidth + " " + part.textureHeight);
            parsed = parsed + CasedModelLoader.ln("mirror " + part.mirror);
            for (ModelCube box : boxes) {
                parsed = parsed + CasedModelLoader.ln("addBox " + box.posX1 + " " + box.posY1 + " " + box.posZ1 + " " + (int)(box.posX2 - box.posX1) + " " + (int)(box.posY2 - box.posY1) + " " + (int)(box.posZ2 - box.posZ1));
            }
            parsed = parsed + CasedModelLoader.ln("end");
        }
        return parsed;
    }

    private static String ln(String ln) {
        return ln + CasedModelLoader.ln();
    }

    private static String ln() {
        return "\n";
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    private static boolean[] parseBooleans(int needed, String ... strings) {
        boolean[] booleans = new boolean[needed];
        for (int i = 0; i < Math.min(needed, strings.length); ++i) {
            try {
                booleans[i] = Boolean.parseBoolean(strings[i]);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return booleans;
    }

    private static float[] parseFloats(int needed, String ... strings) {
        float[] floats = new float[needed];
        for (int i = 0; i < Math.min(needed, strings.length); ++i) {
            try {
                floats[i] = Float.parseFloat(strings[i]);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return floats;
    }

    private static int[] parseInts(int needed, String ... strings) {
        int[] ints = new int[needed];
        for (int i = 0; i < Math.min(needed, strings.length); ++i) {
            try {
                ints[i] = Integer.parseInt(strings[i]);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ints;
    }
}

