/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.api.mhb;

import com.mrdimka.hammercore.api.mhb.IRayCubeGetter;
import com.mrdimka.hammercore.raytracer.ExtendedRayTraceResult;
import com.mrdimka.hammercore.raytracer.IndexedCuboid6;
import com.mrdimka.hammercore.raytracer.RayTracer;
import com.mrdimka.hammercore.vec.Cuboid6;
import com.mrdimka.hammercore.vec.Vector3;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public abstract class BlockTraceable
extends Block {
    public static EnumFacing current_face = EnumFacing.DOWN;
    protected float minX;
    protected float minY;
    protected float minZ;
    protected float maxX;
    protected float maxY;
    protected float maxZ;
    protected final RayTracer RayTracer = new RayTracer();
    protected IRayCubeGetter registry;
    private boolean exited = true;

    public BlockTraceable(Material material) {
        super(material);
    }

    public BlockTraceable(Material material, MapColor mapColor) {
        super(material, mapColor);
    }

    public AxisAlignedBB getFullBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state) {
        return field_185505_j;
    }

    public boolean includeAllHitboxes(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getFullBoundingBox(world, pos, state);
    }

    public boolean onBoxActivated(int boxID, Cuboid6 box, World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean canSeeCouboid(World w, BlockPos p, int boxID, Cuboid6 box, Vector3 start, Vector3 end) {
        return this.RayTracer.rayTraceCuboid(start, end, box);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.registry = IRayCubeGetter.Instance.getter;
        RayTraceResult hit = com.mrdimka.hammercore.raytracer.RayTracer.retraceBlock(worldIn, playerIn, pos);
        return this.onBoxActivated(hit != null ? Math.max(0, hit.subHit) : 0, this.registry.getBoundCubes6(this) != null && this.registry.getBoundCubes6(this).length > 0 ? this.registry.getBoundCubes6(this)[hit != null ? Math.max(0, hit.subHit) : 0] : null, worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public final AxisAlignedBB func_180640_a(IBlockState s, World w, BlockPos p) {
        this.registry = IRayCubeGetter.Instance.getter;
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            return this.selectAxis(s, w, p, this.registry.func_0x834823_a());
        }
        return field_185505_j;
    }

    protected final AxisAlignedBB selectAxis(IBlockState s, World w, BlockPos p, EntityPlayer player) {
        this.registry = IRayCubeGetter.Instance.getter;
        if (player == null) {
            return this.getFullBoundingBox((IBlockAccess)w, p, s);
        }
        RayTraceResult hit = com.mrdimka.hammercore.raytracer.RayTracer.retraceBlock(w, player, p);
        AxisAlignedBB aabb = this.getFullBoundingBox((IBlockAccess)w, p, s);
        if (hit != null && this.registry.getBoundCubes6(this) != null && hit.subHit >= 0 && hit.subHit < this.registry.getBoundCubes6(this).length) {
            Cuboid6[] cubes = this.registry.getBoundCubes6(this);
            current_face = hit.field_178784_b;
            this.setBlockBounds((float)cubes[hit.subHit].min.x, (float)cubes[hit.subHit].min.y, (float)cubes[hit.subHit].min.z, (float)cubes[hit.subHit].max.x, (float)cubes[hit.subHit].max.y, (float)cubes[hit.subHit].max.z);
            aabb = new AxisAlignedBB((double)(this.minX + (float)p.func_177958_n()), (double)(this.minY + (float)p.func_177956_o()), (double)(this.minZ + (float)p.func_177952_p()), (double)(this.maxX + (float)p.func_177958_n()), (double)(this.maxY + (float)p.func_177956_o()), (double)(this.maxZ + (float)p.func_177952_p()));
        } else if (hit != null && this.registry.getBoundCubes6(this) == null && this.registry.getBoundCubeManager(this) != null && this.registry.getBoundCubeManager(this).getCuboids(w, p, w.func_180495_p(p)) != null && hit.subHit >= 0 && hit.subHit < this.registry.getBoundCubeManager(this).getCuboids(w, p, s).length) {
            Cuboid6[] cubes = this.registry.getBoundCubeManager(this).getCuboids(w, p, s);
            current_face = hit.field_178784_b;
            this.setBlockBounds((float)cubes[hit.subHit].min.x, (float)cubes[hit.subHit].min.y, (float)cubes[hit.subHit].min.z, (float)cubes[hit.subHit].max.x, (float)cubes[hit.subHit].max.y, (float)cubes[hit.subHit].max.z);
            aabb = new AxisAlignedBB((double)(this.minX + (float)p.func_177958_n()), (double)(this.minY + (float)p.func_177956_o()), (double)(this.minZ + (float)p.func_177952_p()), (double)(this.maxX + (float)p.func_177958_n()), (double)(this.maxY + (float)p.func_177956_o()), (double)(this.maxZ + (float)p.func_177952_p()));
        }
        return aabb;
    }

    public void func_185477_a(IBlockState s, World w, BlockPos p, AxisAlignedBB aabb, List<AxisAlignedBB> l, Entity ent) {
        this.registry = IRayCubeGetter.Instance.getter;
        if (!this.includeAllHitboxes(w, p, s)) {
            super.func_185477_a(s, w, p, aabb, l, ent);
            return;
        }
        Cuboid6[] cbs = null;
        if (this.registry == null) {
            return;
        }
        if (this.registry.getBoundCubeManager(this) != null) {
            cbs = this.registry.getBoundCubeManager(this).getCuboids(w, p, s);
        } else if (this.registry.getBoundCubes6(this) != null) {
            cbs = this.registry.getBoundCubes6(this);
        }
        if (cbs != null) {
            for (Cuboid6 c : cbs) {
                BlockTraceable.func_185492_a((BlockPos)p, (AxisAlignedBB)aabb, l, (AxisAlignedBB)c.aabb());
            }
        }
    }

    private void setBlockBounds(float x, float y, float z, float x2, float y2, float z2) {
        this.minX = x;
        this.minY = y;
        this.minZ = z;
        this.maxX = x2;
        this.maxY = y2;
        this.maxZ = z2;
    }

    public final RayTraceResult func_180636_a(IBlockState s, World world, BlockPos p, Vec3d start, Vec3d end) {
        this.registry = IRayCubeGetter.Instance.getter;
        if (this.registry == null) {
            return super.func_180636_a(s, world, p, start, end);
        }
        this.exited = false;
        LinkedList<IndexedCuboid6> cuboids = new LinkedList<IndexedCuboid6>();
        Cuboid6[] cbs = null;
        if (this.registry.getBoundCubeManager(this) != null) {
            cbs = this.registry.getBoundCubeManager(this).getCuboids(world, p, world.func_180495_p(p));
        } else if (this.registry.getBoundCubes6(this) != null) {
            cbs = this.registry.getBoundCubes6(this);
        }
        if (cbs == null) {
            return super.func_180636_a(s, world, p, start, end);
        }
        if (cbs != null) {
            for (int i = 0; i < cbs.length; ++i) {
                Cuboid6 c = cbs[i];
                Cuboid6 cc = new Cuboid6(c.aabb().field_72340_a + (double)p.func_177958_n(), c.aabb().field_72338_b + (double)p.func_177956_o(), c.aabb().field_72339_c + (double)p.func_177952_p(), c.aabb().field_72336_d + (double)p.func_177958_n(), c.aabb().field_72337_e + (double)p.func_177956_o(), c.aabb().field_72334_f + (double)p.func_177952_p());
                if (!this.canSeeCouboid(world, p, i, cc, new Vector3(start), new Vector3(end))) continue;
                cuboids.add(new IndexedCuboid6(i, cc));
            }
        }
        double min = Double.MAX_VALUE;
        for (IndexedCuboid6 cbd : new ArrayList(cuboids)) {
            double crr = cbd.center().toVec3d().func_72436_e(start);
            if (!(crr < min)) continue;
            min = crr;
            cuboids.clear();
            cuboids.add(cbd);
        }
        ExtendedRayTraceResult rtl = this.RayTracer.rayTraceCuboids(new Vector3(start), new Vector3(end), cuboids, p);
        this.exited = true;
        return rtl;
    }

    public Cuboid6 getCuboidFromPlayer(EntityPlayer player, BlockPos pos) {
        RayTraceResult hit = com.mrdimka.hammercore.raytracer.RayTracer.retraceBlock(player.field_70170_p, player, pos);
        if (hit != null && this.registry.getBoundCubes6(this) != null && hit.subHit >= 0 && hit.subHit < this.registry.getBoundCubes6(this).length) {
            Cuboid6[] cubes = this.registry.getBoundCubes6(this);
            return cubes[hit.subHit];
        }
        if (hit != null && this.registry.getBoundCubes6(this) == null && this.registry.getBoundCubeManager(this) != null && this.registry.getBoundCubeManager(this).getCuboids(player.field_70170_p, pos, player.field_70170_p.func_180495_p(pos)) != null && hit.subHit >= 0 && hit.subHit < this.registry.getBoundCubeManager(this).getCuboids(player.field_70170_p, pos, player.field_70170_p.func_180495_p(pos)).length) {
            Cuboid6[] cubes = this.registry.getBoundCubeManager(this).getCuboids(player.field_70170_p, pos, player.field_70170_p.func_180495_p(pos));
            return cubes[hit.subHit];
        }
        return null;
    }

    public Cuboid6 getCuboidFromRTR(World world, RayTraceResult hit) {
        if (hit == null || this.registry == null) {
            return null;
        }
        BlockPos pos = hit.func_178782_a();
        if (pos == null) {
            return null;
        }
        if (hit != null && this.registry.getBoundCubes6(this) != null && hit.subHit >= 0 && hit.subHit < this.registry.getBoundCubes6(this).length) {
            Cuboid6[] cubes = this.registry.getBoundCubes6(this);
            return cubes[hit.subHit];
        }
        if (hit != null && this.registry.getBoundCubes6(this) == null && this.registry.getBoundCubeManager(this) != null && this.registry.getBoundCubeManager(this).getCuboids(world, pos, world.func_180495_p(pos)) != null && hit.subHit >= 0 && hit.subHit < this.registry.getBoundCubeManager(this).getCuboids(world, pos, world.func_180495_p(pos)).length) {
            Cuboid6[] cubes = this.registry.getBoundCubeManager(this).getCuboids(world, pos, world.func_180495_p(pos));
            return cubes[hit.subHit];
        }
        return null;
    }
}

