/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.util.files;

import com.teamacronymcoders.base.util.Platform;
import com.teamacronymcoders.base.util.files.BaseFileUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.client.resources.IResourcePack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;

@SideOnly(value=Side.CLIENT)
public class ResourcePackAssembler {
    private static final String MC_META_BASE = "{\"pack\":{\"pack_format\":1,\"description\":\"%s\"}}";
    private static List<IResourcePack> defaultResourcePacks;
    private List<CustomFile> files = new ArrayList<CustomFile>();
    private File dir;
    private File zip;
    private String mcmeta;
    private String modid;
    private String assetsPath;
    private boolean hasPackPng = false;
    private Class<?> jarClass;

    public ResourcePackAssembler(File directory, String packName, String modid) {
        this.dir = directory;
        this.zip = new File(this.dir.getAbsolutePath() + ".zip");
        this.modid = modid.toLowerCase(Locale.US);
        this.mcmeta = String.format(MC_META_BASE, packName);
        this.assetsPath = "/assets/" + modid + "/";
    }

    public ResourcePackAssembler setHasPackPng(Class<?> jarClass) {
        this.jarClass = jarClass;
        this.hasPackPng = true;
        return this;
    }

    public void addFile(String path, File file) {
        this.files.add(new CustomFile(this.assetsPath + path, file));
    }

    public void addCustomFile(File file) {
        this.addFile(null, file);
    }

    public ResourcePackAssembler assemble() {
        BaseFileUtils.safeDeleteDirectory(this.dir);
        this.dir.mkdirs();
        String pathToDir = this.dir.getAbsolutePath();
        File metaFile = new File(pathToDir + "/pack.mcmeta");
        try {
            this.writeNewFile(metaFile, this.mcmeta);
            if (this.hasPackPng) {
                BaseFileUtils.copyFromJar(this.jarClass, this.modid + "/pack.png", new File(this.dir.getAbsolutePath() + "/pack.png"));
            }
            for (CustomFile custom : this.files) {
                File directory = new File(pathToDir + (custom.ext != null ? "/" + custom.ext : ""));
                directory.mkdirs();
                FileUtils.copyFile((File)custom.file, (File)new File(directory.getAbsolutePath() + "/" + custom.file.getName()));
            }
            BaseFileUtils.zipFolderContents(this.dir, this.zip);
            BaseFileUtils.safeDeleteDirectory(this.dir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public void inject() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            try {
                if (defaultResourcePacks == null) {
                    defaultResourcePacks = (List)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])new String[]{"defaultResourcePacks", "field_110449_ao", "ap"});
                }
                File dest = new File(this.dir.getParent() + "/resourcepack/" + this.zip.getName());
                BaseFileUtils.safeDelete(dest);
                FileUtils.copyFile((File)this.zip, (File)dest);
                BaseFileUtils.safeDelete(this.zip);
                defaultResourcePacks.add((IResourcePack)new FileResourcePack(dest));
            }
            catch (Exception e) {
                Platform.attemptLogExceptionToCurrentMod(e);
            }
        }
    }

    private void writeNewFile(File file, String defaultText) throws IOException {
        BaseFileUtils.safeDelete(file);
        file.delete();
        file.getParentFile().mkdirs();
        file.createNewFile();
        FileWriter fw = new FileWriter(file);
        fw.write(defaultText);
        fw.flush();
        fw.close();
    }

    private class CustomFile {
        private String ext;
        private File file;

        private CustomFile(String ext, File file) {
            this.ext = ext;
            this.file = file;
        }
    }
}

