/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.util;

import com.teamacronymcoders.base.Base;
import com.teamacronymcoders.base.registry.config.ConfigEntry;
import com.teamacronymcoders.base.registry.config.ConfigEntryBuilder;
import com.teamacronymcoders.base.registry.config.ConfigRegistry;
import com.teamacronymcoders.base.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictUtils {
    private static Map<String, ItemStack> preferredItemStacks;
    private static List<String> preferredModIds;

    private OreDictUtils() {
    }

    public static void setup() {
        preferredItemStacks = new HashMap<String, ItemStack>();
        preferredModIds = new ArrayList<String>();
        ConfigEntry preferredMods = ConfigEntryBuilder.getBuilder("preferredOreDictIds", "base").setArray(true).setCategory("materials").setComment("List for Prioritizing OreDict returns by modid").build();
        Base.instance.getRegistry(ConfigRegistry.class, "CONFIG").addEntry(preferredMods);
        preferredModIds = Arrays.asList(preferredMods.getStringArray());
    }

    @Nullable
    public static ItemStack getPreferredItemStack(String oreDictName) {
        ItemStack itemStack;
        if (!preferredItemStacks.containsKey(oreDictName)) {
            int bestMatchLevel = preferredModIds.size();
            ItemStack preferredItemStack = null;
            List itemStackList = OreDictionary.getOres((String)oreDictName);
            for (ItemStack itemStack2 : itemStackList) {
                String modid;
                if (!ItemStackUtils.isValidItemStack(itemStack2) || !preferredModIds.contains(modid = ItemStackUtils.getModIdFromItemStack(itemStack2))) continue;
                int newMatch = preferredModIds.indexOf(modid);
                bestMatchLevel = newMatch < bestMatchLevel ? newMatch : bestMatchLevel;
                preferredItemStack = itemStack2;
            }
            if (preferredItemStack == null && !itemStackList.isEmpty()) {
                preferredItemStack = (ItemStack)itemStackList.get(0);
            }
            preferredItemStacks.put(oreDictName, preferredItemStack);
        }
        return ItemStackUtils.isValidItemStack(itemStack = preferredItemStacks.get(oreDictName)) ? itemStack.func_77946_l() : null;
    }
}

