/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.registry.pieces.gameregistry;

import com.teamacronymcoders.base.registry.Registry;
import com.teamacronymcoders.base.registry.entity.EntityEntry;
import com.teamacronymcoders.base.registry.entity.SpawnEgg;
import com.teamacronymcoders.base.registry.entity.SpawnInfo;
import com.teamacronymcoders.base.registry.entity.UpdateInfo;
import com.teamacronymcoders.base.registry.pieces.RegistryPiece;
import com.teamacronymcoders.base.registry.pieces.RegistryPieceBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.registry.EntityRegistry;

@RegistryPiece(priority=EventPriority.HIGH)
public class EntityRegisterRegistryPiece
extends RegistryPieceBase<EntityEntry> {
    public int nextAvailableID = 0;

    public EntityRegisterRegistryPiece() {
        super(EntityEntry.class);
    }

    @Override
    public boolean acceptsRegistry(Registry registry) {
        return "ENTITY".equalsIgnoreCase(registry.getName());
    }

    @Override
    public void preInit(ResourceLocation name, EntityEntry entry) {
        SpawnInfo spawnInfo;
        Class<? extends Entity> entityClass = entry.getEntityClass();
        UpdateInfo updateInfo = entry.getUpdateInfo();
        EntityRegistry.registerModEntity(entityClass, (String)name.func_110623_a(), (int)this.nextAvailableID++, (Object)this.getMod(), (int)updateInfo.getTrackingRange(), (int)updateInfo.getUpdateFrequency(), (boolean)updateInfo.isSendVelocityUpdates());
        SpawnEgg spawnEgg = entry.getSpawnEgg();
        if (spawnEgg != null) {
            EntityRegistry.registerEgg(entry.getEntityClass(), (int)spawnEgg.getPrimaryColor(), (int)spawnEgg.getSecondaryColor());
        }
        if ((spawnInfo = entry.getSpawnInfo()) != null && EntityLiving.class.isAssignableFrom(entityClass)) {
            EntityRegistry.addSpawn(entityClass, (int)spawnInfo.getWeighted(), (int)spawnInfo.getMinimum(), (int)spawnInfo.getMaximum(), (EnumCreatureType)spawnInfo.getCreatureType(), (Biome[])spawnInfo.getSpawnBiomes());
        }
    }
}

