/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.modules.materials;

import com.teamacronymcoders.base.Base;
import com.teamacronymcoders.base.api.materials.MaterialRegistry;
import com.teamacronymcoders.base.api.materials.MaterialType;
import com.teamacronymcoders.base.creativetabs.CreativeTabCarousel;
import com.teamacronymcoders.base.modules.materials.BaseMaterial;
import com.teamacronymcoders.base.modules.materials.MaterialRecipes;
import com.teamacronymcoders.base.modules.materials.blocks.BlockMaterial;
import com.teamacronymcoders.base.modules.materials.blocks.BlockProperties;
import com.teamacronymcoders.base.modules.materials.items.ItemPart;
import com.teamacronymcoders.base.modulesystem.Module;
import com.teamacronymcoders.base.modulesystem.ModuleBase;
import com.teamacronymcoders.base.registry.BlockRegistry;
import com.teamacronymcoders.base.registry.ItemRegistry;
import com.teamacronymcoders.base.registry.config.ConfigEntry;
import com.teamacronymcoders.base.registry.config.ConfigRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Module(value="base")
public class ModuleMaterials
extends ModuleBase {
    public static final ItemPart GEAR = new ItemPart(MaterialType.EnumPartType.GEAR);
    public static final ItemPart DUST = new ItemPart(MaterialType.EnumPartType.DUST);
    public static final ItemPart PLATE = new ItemPart(MaterialType.EnumPartType.PLATE);
    public static final ItemPart NUGGET = new ItemPart(MaterialType.EnumPartType.NUGGET);
    public static final ItemPart INGOT = new ItemPart(MaterialType.EnumPartType.INGOT);
    public static Map<String, MaterialType> activeBaseMaterials;

    @Override
    public String getName() {
        return "Materials";
    }

    @Override
    public void configure(ConfigRegistry configRegistry) {
        activeBaseMaterials = new HashMap<String, MaterialType>();
        for (BaseMaterial material : BaseMaterial.values()) {
            MaterialType materialType = material.getMaterialType();
            MaterialConfigEntry materialConfig = new MaterialConfigEntry(materialType.getName(), false);
            configRegistry.register(materialType.getName(), (ConfigEntry)materialConfig);
            if (!materialConfig.getBoolean(false)) continue;
            MaterialRegistry.registerMaterial(material.ordinal(), materialType);
            activeBaseMaterials.put(materialType.getName(), materialType);
        }
    }

    @Override
    public void registerItems(ConfigRegistry configRegistry, ItemRegistry itemRegistry) {
        itemRegistry.register(GEAR);
        itemRegistry.register(DUST);
        itemRegistry.register(PLATE);
        itemRegistry.register(NUGGET);
        itemRegistry.register(INGOT);
    }

    @Override
    public void registerBlocks(ConfigRegistry configRegistry, BlockRegistry blockRegistry) {
        BlockProperties oreProperties = new BlockProperties(3.0f, 5.0f, "pickaxe", 2);
        BlockProperties storageProperties = new BlockProperties(5.0f, 10.0f, "pickaxe", 2);
        MaterialRegistry.getMaterials().forEach((id, materialType) -> {
            BlockMaterial blockMaterial;
            if (materialType.isTypeSet(MaterialType.EnumPartType.ORE)) {
                blockMaterial = new BlockMaterial((MaterialType)materialType, MaterialType.EnumPartType.ORE, oreProperties);
                blockRegistry.register(blockMaterial);
            }
            if (materialType.isTypeSet(MaterialType.EnumPartType.BLOCK)) {
                blockMaterial = new BlockMaterial((MaterialType)materialType, MaterialType.EnumPartType.BLOCK, storageProperties);
                blockRegistry.register(blockMaterial);
            }
            if (materialType.isTypeSet(MaterialType.EnumPartType.POOR_ORE)) {
                blockMaterial = new BlockMaterial((MaterialType)materialType, MaterialType.EnumPartType.POOR_ORE, oreProperties);
                blockRegistry.register(blockMaterial);
            }
        });
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (MaterialRegistry.getMaterials().size() > 0) {
            CreativeTabCarousel tabCarousel = new CreativeTabCarousel("base");
            tabCarousel.setIconStacks(GEAR.getAllSubItems(new ArrayList<ItemStack>()));
            Base.instance.setCreativeTab(tabCarousel);
        }
        super.preInit(event);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        MaterialRecipes.init();
    }

    public static class MaterialConfigEntry
    extends ConfigEntry {
        public MaterialConfigEntry(String materialName, Boolean value) {
            super("materials", materialName, Property.Type.BOOLEAN, Boolean.toString(value), String.format("Should %s be registered as a material?", materialName));
        }
    }
}

