/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.materialsystem.compat.tinkers;

import com.teamacronymcoders.base.IBaseMod;
import com.teamacronymcoders.base.materialsystem.MaterialException;
import com.teamacronymcoders.base.materialsystem.materialparts.MaterialPart;
import com.teamacronymcoders.base.materialsystem.parttype.PartType;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import slimeknights.tconstruct.library.materials.Material;

public class TinkersPartType
extends PartType {
    public TinkersPartType(IBaseMod mod) {
        super("Tinkers", mod);
    }

    @Override
    public void setup(@Nonnull MaterialPart materialPart) {
        this.createTinkers(materialPart);
    }

    private void createTinkers(MaterialPart materialPart) {
        Fluid fluid;
        if (!FluidRegistry.isFluidRegistered((String)materialPart.getMaterial().getUnlocalizedName())) {
            try {
                this.getMaterialSystem().registerPartsForMaterial(materialPart.getMaterial(), "fluid");
            }
            catch (MaterialException e) {
                this.getMod().getLogger().error("Could not register fluid for " + materialPart.getLocalizedName());
            }
        }
        if ((fluid = FluidRegistry.getFluid((String)materialPart.getMaterial().getUnlocalizedName())) != null) {
            Material tinkerMaterial = new Material(materialPart.getUnlocalizedName(), materialPart.getColor());
            tinkerMaterial.addCommonItems(materialPart.getMaterial().getUnlocalizedName());
        } else {
            this.getMod().getLogger().error("Could not create Fluid for Tinker's Compat");
        }
    }
}

