/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component.wire;

import com.amadornes.rscircuits.SCM;
import com.amadornes.rscircuits.api.IColorPalette;
import com.amadornes.rscircuits.api.circuit.EnumCircuitIOMode;
import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.api.component.IComponentFactory;
import com.amadornes.rscircuits.api.component.IPaintableComponent;
import com.amadornes.rscircuits.api.component.IRedstoneConductor;
import com.amadornes.rscircuits.component.SimpleFactory;
import com.amadornes.rscircuits.component.wire.ComponentWireFlatBase;
import com.amadornes.rscircuits.component.wire.SimpleRedstoneConductor;
import com.amadornes.rscircuits.init.SCMCaps;
import com.amadornes.rscircuits.init.SCMItems;
import com.amadornes.rscircuits.item.EnumResourceType;
import com.amadornes.rscircuits.util.ProjectionHelper;
import com.google.common.collect.Multimap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcmultipart.MCMultiPartMod;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.lwjgl.input.Keyboard;

public class ComponentWire
extends ComponentWireFlatBase
implements IPaintableComponent {
    public static final PropertyEnum<IRedstoneConductor.EnumConnectionType> FRONT = PropertyEnum.func_177709_a((String)"front", IRedstoneConductor.EnumConnectionType.class);
    public static final PropertyEnum<IRedstoneConductor.EnumConnectionType> BACK = PropertyEnum.func_177709_a((String)"back", IRedstoneConductor.EnumConnectionType.class);
    public static final PropertyEnum<IRedstoneConductor.EnumConnectionType> LEFT = PropertyEnum.func_177709_a((String)"left", IRedstoneConductor.EnumConnectionType.class);
    public static final PropertyEnum<IRedstoneConductor.EnumConnectionType> RIGHT = PropertyEnum.func_177709_a((String)"right", IRedstoneConductor.EnumConnectionType.class);
    public static final IUnlistedProperty<Integer> POWER_LEVEL = Properties.toUnlisted((IProperty)PropertyInteger.func_177719_a((String)"power_level", (int)0, (int)255));
    public static final ResourceLocation NAME = new ResourceLocation("rscircuits", "wire");
    private byte power = 0;
    private boolean shouldOutputPower = true;
    private boolean shouldPropagate = true;
    private EnumDyeColor color = EnumDyeColor.SILVER;
    private boolean glowing = false;
    private boolean connectOnAdd = true;

    public ComponentWire(ICircuit circuit, boolean glowing, boolean connectOnAdd) {
        super(circuit, EnumComponentSlot.BOTTOM);
        this.glowing = glowing;
        this.connectOnAdd = connectOnAdd;
        if (!connectOnAdd) {
            for (SimpleRedstoneConductor.ConnectionInfo info : this.cond.getNeighborsRAW()) {
                info.type = IRedstoneConductor.EnumConnectionType.DISABLED;
            }
        }
    }

    public ComponentWire(ICircuit circuit) {
        super(circuit);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public float getComplexity() {
        return 0.005f;
    }

    @Override
    public boolean isDynamic() {
        return this.glowing;
    }

    @Override
    public IBlockState getActualState() {
        IRedstoneConductor.IConnectionInfo[] info = this.getNeighbors();
        return super.getActualState().func_177226_a(FRONT, (Comparable)((Object)info[EnumCircuitSide.FRONT.ordinal()].getType())).func_177226_a(BACK, (Comparable)((Object)info[EnumCircuitSide.BACK.ordinal()].getType())).func_177226_a(LEFT, (Comparable)((Object)info[EnumCircuitSide.LEFT.ordinal()].getType())).func_177226_a(RIGHT, (Comparable)((Object)info[EnumCircuitSide.RIGHT.ordinal()].getType()));
    }

    @Override
    public boolean isBundled() {
        return false;
    }

    @Override
    public EnumDyeColor getColor() {
        return this.color;
    }

    @Override
    public boolean isColorBiased() {
        return true;
    }

    @Override
    public byte getInput(EnumDyeColor color) {
        if (!this.shouldPropagate) {
            return 0;
        }
        int input = 0;
        for (IRedstoneConductor.IConnectionInfo info : this.getNeighbors()) {
            Pair<IComponent, EnumComponentSlot> neighbor;
            if (info.getType() != IRedstoneConductor.EnumConnectionType.CATHODE || (neighbor = this.getNeighborPair(this.slot, info.getSide())) == null) continue;
            if (neighbor.getKey() instanceof IRedstoneConductor && !((IRedstoneConductor)neighbor.getKey()).isBundled()) {
                for (EnumDyeColor c : EnumDyeColor.values()) {
                    input = Math.max(input, ((IComponent)neighbor.getKey()).getOutputSignal((EnumComponentSlot)((Object)neighbor.getValue()), info.getSide().getOpposite(), c, false) & 0xFF);
                }
                continue;
            }
            if (((IComponent)neighbor.getKey()).isOutput((EnumComponentSlot)((Object)neighbor.getValue()), info.getSide().getOpposite())) {
                input = Math.max(input, ((IComponent)neighbor.getKey()).getOutputSignal((EnumComponentSlot)((Object)neighbor.getValue()), info.getSide().getOpposite(), this.color, false) & 0xFF);
            }
            if (!((IComponent)neighbor.getKey()).getBundledConnection((EnumComponentSlot)((EnumComponentSlot)((Object)neighbor.getValue())), (EnumCircuitSide)info.getSide().getOpposite()).isOutput) continue;
            input = Math.max(input, ((IComponent)neighbor.getKey()).getOutputSignal((EnumComponentSlot)((Object)neighbor.getValue()), info.getSide().getOpposite(), this.color, true) & 0xFF);
        }
        if (this.getPos().func_177956_o() == 0) {
            for (EnumCircuitSide edge : this.getEdgesOn()) {
                if (this.getNeighbors()[edge.ordinal()].getType() != IRedstoneConductor.EnumConnectionType.CATHODE) continue;
                input = Math.max(input, this.getCircuit().getInput(edge, color, this.getCircuit().getIOMode(edge) == EnumCircuitIOMode.BUNDLED) & 0xFF);
            }
        }
        return (byte)input;
    }

    @Override
    public byte getOutputSignal(EnumComponentSlot slot, EnumCircuitSide side, EnumDyeColor color, boolean bundled) {
        return (!bundled || !this.getEdgesOn().contains((Object)side) || this.getCircuit().getIOMode(side) == EnumCircuitIOMode.BUNDLED) && this.shouldOutputPower && this.isOutput(slot, side) && color == this.color ? this.power : (byte)0;
    }

    @Override
    public boolean isInput(EnumComponentSlot slot, EnumCircuitSide side) {
        return this.cond.getNeighbors()[side.ordinal()].getType().isInput;
    }

    @Override
    public boolean isOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        return this.cond.getNeighbors()[side.ordinal()].getType().isOutput;
    }

    @Override
    public boolean isStrongOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        return true;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, Vec3d hit) {
        if (heldItem != null && heldItem.func_77973_b() == SCMItems.screwdriver) {
            List<EnumCircuitSide> edges;
            IRedstoneConductor.EnumConnectionType prevType;
            int rot = ProjectionHelper.getPlacementRotation(new Vec3d(hit.field_72450_a, 0.0, 1.0 - hit.field_72449_c));
            if (rot == 1 || rot == 2) {
                rot = (rot - 1 ^ 1) + 1;
            }
            SimpleRedstoneConductor.ConnectionInfo info = this.cond.getNeighborsRAW()[rot + 2];
            IRedstoneConductor.EnumConnectionType type = prevType = info.type;
            EnumCircuitSide side = info.side;
            Pair<IComponent, EnumComponentSlot> neighbor = this.getNeighborPair(this.slot, side);
            if (neighbor != null) {
                type = player.func_70093_af() ? (prevType == IRedstoneConductor.EnumConnectionType.CATHODE ? (((IComponent)neighbor.getKey()).isInput((EnumComponentSlot)((Object)neighbor.getValue()), side.getOpposite()) ? IRedstoneConductor.EnumConnectionType.ANODE : IRedstoneConductor.EnumConnectionType.DISABLED) : (neighbor.getKey() instanceof IRedstoneConductor || ((IComponent)neighbor.getKey()).isOutput((EnumComponentSlot)((Object)neighbor.getValue()), side.getOpposite()) ? IRedstoneConductor.EnumConnectionType.CATHODE : IRedstoneConductor.EnumConnectionType.DISABLED)) : (prevType.isOutput ? IRedstoneConductor.EnumConnectionType.DISABLED : (neighbor.getKey() instanceof IRedstoneConductor || ((IComponent)neighbor.getKey()).isInput((EnumComponentSlot)((Object)neighbor.getValue()), side.getOpposite()) ? IRedstoneConductor.EnumConnectionType.ANODE : (!(neighbor.getKey() instanceof IRedstoneConductor) && type != IRedstoneConductor.EnumConnectionType.CATHODE && ((IComponent)neighbor.getKey()).isOutput((EnumComponentSlot)((Object)neighbor.getValue()), side.getOpposite()) ? IRedstoneConductor.EnumConnectionType.CATHODE : IRedstoneConductor.EnumConnectionType.DISABLED)));
            } else if (!this.isOnSeam() && this.getPos().func_177956_o() == 0 && (edges = this.getEdgesOn()).contains((Object)side) && this.isOnEdge(side)) {
                type = player.func_70093_af() ? (type == IRedstoneConductor.EnumConnectionType.CATHODE ? IRedstoneConductor.EnumConnectionType.ANODE : IRedstoneConductor.EnumConnectionType.CATHODE) : (type == IRedstoneConductor.EnumConnectionType.ANODE ? IRedstoneConductor.EnumConnectionType.DISABLED : IRedstoneConductor.EnumConnectionType.ANODE);
            }
            if (type != prevType) {
                if (!this.getCircuit().getWorld().field_72995_K) {
                    info.type = type;
                    if (neighbor != null && neighbor.getKey() instanceof IRedstoneConductor) {
                        IRedstoneConductor w = (IRedstoneConductor)neighbor.getKey();
                        if (type == IRedstoneConductor.EnumConnectionType.DISABLED) {
                            w.disconnect(side.getOpposite());
                            w.propagate(w.isBundled() ? this.getColor() : w.getColor());
                            info.neighbor = null;
                        } else {
                            info.neighbor = w;
                            w.connect(side.getOpposite(), this, IRedstoneConductor.EnumConnectionType.ANODE, false);
                            if (type == IRedstoneConductor.EnumConnectionType.CATHODE) {
                                w.propagate(w.isBundled() ? this.getColor() : w.getColor());
                            }
                        }
                    } else {
                        this.getCircuit().notifyUpdate(this.getPos(), this.slot, side);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        heldItem.func_77972_a(1, (EntityLivingBase)player);
                    }
                    this.propagate(this.getColor());
                    this.getCircuit().sendUpdate(this.getPos(), this.slot, !this.glowing);
                    this.getCircuit().markDirty();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onAdded() {
        if (this.connectOnAdd) {
            super.onAdded();
        }
    }

    @Override
    public void propagate(IRedstoneConductor from, EnumDyeColor color, Multimap<IRedstoneConductor, EnumDyeColor> wires, Set<Triple<IRedstoneConductor, IRedstoneConductor, EnumDyeColor>> scheduled) {
        if (this.shouldPropagate && (!from.isBundled() || color == this.color)) {
            super.propagate(from, color, wires, scheduled);
        }
    }

    @Override
    public void onPropagated(Set<EnumDyeColor> colors, byte power) {
        if (this.power != power) {
            this.power = power;
            if (this.getPos() != null) {
                super.onPropagated(colors, power);
                this.getCircuit().markDirty();
                if (this.glowing) {
                    this.getCircuit().sendUpdate(this.getPos(), this.slot, false);
                }
            }
        }
    }

    @Override
    public boolean connect(EnumCircuitSide side, IRedstoneConductor conductor, IRedstoneConductor.EnumConnectionType type, boolean simulated) {
        return (!simulated || this.connectOnAdd || this.cond.getNeighbors()[side.ordinal()].getType() != IRedstoneConductor.EnumConnectionType.DISABLED) && super.connect(side, conductor, type, simulated);
    }

    @Override
    public void onConnect(EnumCircuitSide side, IRedstoneConductor conductor, IRedstoneConductor.EnumConnectionType type) {
        this.getCircuit().markDirty();
        this.getCircuit().sendUpdate(this.getPos(), this.slot, !this.glowing);
    }

    @Override
    public void onDisconnect(EnumCircuitSide side) {
        this.getCircuit().markDirty();
        this.getCircuit().sendUpdate(this.getPos(), this.slot, !this.glowing);
    }

    @Override
    public void onWorldChange() {
        if (this.getPos().func_177956_o() == 0) {
            this.cond.propagate(this.getColor());
        }
    }

    @Override
    public void addSelectionBoxes(List<AxisAlignedBB> boxes) {
        boxes.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0));
    }

    @Override
    public List<ItemStack> getDrops() {
        return Arrays.asList(this.getPickedItem());
    }

    @Override
    public ItemStack getPickedItem() {
        return new ItemStack(SCMItems.resource, 1, (this.glowing ? EnumResourceType.PILE_OF_GLOWING_REDSTONE : EnumResourceType.PILE_OF_REDSTONE).ordinal());
    }

    @Override
    public int getColorMultiplier(int index) {
        if (index == 0) {
            return this.color.func_176768_e().field_76291_p;
        }
        if (index == 1) {
            int minBrightness = 128;
            int pow = this.glowing ? (int)((float)(this.power & 0xFF) / 255.0f * (float)(255 - minBrightness) + (float)minBrightness) : 191;
            return pow << 16 | pow << 8 | pow << 0;
        }
        return super.getColorMultiplier(index);
    }

    @Override
    public boolean paint(EnumDyeColor color) {
        if (this.getCircuit().getWorld().field_72995_K && this.color != color) {
            ByteBuf buf = Unpooled.buffer();
            buf.writeByte(color.func_176765_a());
            this.getCircuit().sendCustomPayload(this.getPos(), this.slot, buf);
            return this.color != color;
        }
        return false;
    }

    @Override
    public void handleCustomPayload(ByteBuf buf) {
        this.shouldPropagate = false;
        this.shouldOutputPower = false;
        this.getCircuit().notifyUpdateAll(this.getPos(), this.slot);
        this.shouldOutputPower = true;
        this.shouldPropagate = true;
        EnumDyeColor prevColor = this.color;
        this.color = EnumDyeColor.func_176764_b((int)(buf.readByte() & 0xFF));
        if (prevColor != this.color) {
            this.getCircuit().notifyUpdateAll(this.getPos(), this.slot);
            this.cond.propagate(this.getColor());
            this.getCircuit().sendUpdate(this.getPos(), this.slot, !this.glowing);
            this.getCircuit().markDirty();
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("glowing", this.glowing);
        tag.func_74768_a("color", this.color.func_176765_a());
        tag.func_74774_a("power", this.power);
        int connections = 0;
        for (IRedstoneConductor.IConnectionInfo info : this.getNeighbors()) {
            connections |= info.getType().ordinal() << info.getSide().ordinal() * 2;
        }
        tag.func_74768_a("connections", connections);
        tag.func_74774_a("version", (byte)3);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        block4: {
            int version;
            block5: {
                block3: {
                    super.readFromNBT(tag);
                    this.glowing = tag.func_74767_n("glowing");
                    this.color = tag.func_74764_b("color") ? EnumDyeColor.func_176764_b((int)tag.func_74762_e("color")) : EnumDyeColor.SILVER;
                    this.power = tag.func_74771_c("power");
                    int n = version = tag.func_74764_b("version") ? tag.func_74771_c("version") & 0xFF : 1;
                    if (version != 1) break block3;
                    int connections = tag.func_74770_j("connections")[0] & 0xFF;
                    for (int i = 0; i < 4; ++i) {
                        this.cond.getNeighborsRAW()[i + 2].type = IRedstoneConductor.EnumConnectionType.VALUES[connections >> i * 2 & 3];
                    }
                    break block4;
                }
                if (version != 2) break block5;
                int connections = tag.func_74771_c("connections") & 0xFF;
                for (int i = 0; i < 4; ++i) {
                    this.cond.getNeighborsRAW()[i + 2].type = IRedstoneConductor.EnumConnectionType.VALUES[connections >> i * 2 & 3];
                }
                break block4;
            }
            if (version != 3) break block4;
            int connections = tag.func_74762_e("connections");
            for (SimpleRedstoneConductor.ConnectionInfo info : this.cond.getNeighborsRAW()) {
                info.type = IRedstoneConductor.EnumConnectionType.VALUES[connections >> info.side.ordinal() * 2 & 3];
            }
        }
    }

    @Override
    public void writeDescription(PacketBuffer buf) {
        super.writeDescription(buf);
        buf.writeBoolean(this.glowing);
        buf.func_179249_a((Enum)this.color);
        if (this.glowing) {
            buf.writeByte((int)this.power);
        }
        int connections = 0;
        for (IRedstoneConductor.IConnectionInfo info : this.getNeighbors()) {
            connections |= info.getType().ordinal() << info.getSide().ordinal() * 2;
        }
        buf.writeInt(connections);
    }

    @Override
    public void readDescription(PacketBuffer buf) {
        super.readDescription(buf);
        this.glowing = buf.readBoolean();
        this.color = (EnumDyeColor)buf.func_179257_a(EnumDyeColor.class);
        this.power = this.glowing ? buf.readByte() : (byte)0;
        int connections = buf.readInt();
        for (SimpleRedstoneConductor.ConnectionInfo info : this.cond.getNeighborsRAW()) {
            info.type = IRedstoneConductor.EnumConnectionType.VALUES[connections >> info.side.ordinal() * 2 & 3];
        }
    }

    @Override
    public void serializePlacement(PacketBuffer buf) {
        super.serializePlacement(buf);
        buf.writeBoolean(this.glowing);
        buf.writeBoolean(this.connectOnAdd);
        buf.func_179249_a((Enum)this.color);
    }

    @Override
    public void deserializePlacement(PacketBuffer buf) {
        super.deserializePlacement(buf);
        this.glowing = buf.readBoolean();
        this.connectOnAdd = buf.readBoolean();
        this.color = (EnumDyeColor)buf.func_179257_a(EnumDyeColor.class);
        if (!this.connectOnAdd) {
            for (SimpleRedstoneConductor.ConnectionInfo info : this.cond.getNeighborsRAW()) {
                if (info.side.face.func_176740_k() == EnumFacing.Axis.Y) continue;
                info.type = IRedstoneConductor.EnumConnectionType.DISABLED;
            }
        }
    }

    @Override
    public void debug(EntityPlayer player) {
        player.func_145747_a((ITextComponent)new TextComponentString("Power Level: " + (this.power & 0xFF)));
    }

    public static class Factory
    extends SimpleFactory<ComponentWire> {
        @Override
        public BlockStateContainer createBlockState() {
            return new BlockStateContainer.Builder((Block)MCMultiPartMod.multipart).add(new IProperty[]{FRONT, BACK, LEFT, RIGHT}).add(new IUnlistedProperty[]{POWER_LEVEL}).build();
        }

        @Override
        public ResourceLocation getModelPath() {
            return new ResourceLocation("rscircuits", "component/wire");
        }

        @Override
        public boolean isValidPlacementStack(ItemStack stack, EntityPlayer player) {
            return stack.func_77973_b() == SCMItems.resource && (stack.func_77952_i() == EnumResourceType.PILE_OF_REDSTONE.ordinal() || stack.func_77952_i() == EnumResourceType.PILE_OF_GLOWING_REDSTONE.ordinal());
        }

        private ComponentWire mkWire(ICircuit circuit, ItemStack stack) {
            ItemStack offStack;
            ComponentWire wire = new ComponentWire(circuit, stack.func_77952_i() == EnumResourceType.PILE_OF_GLOWING_REDSTONE.ordinal(), !Keyboard.isKeyDown((int)29));
            EntityPlayer player = SCM.proxy.getPlayer();
            if (player != null && player.func_184592_cb() != null && (offStack = player.func_184592_cb()).hasCapability(SCMCaps.PALETTE, null)) {
                wire.color = ((IColorPalette)offStack.getCapability(SCMCaps.PALETTE, null)).getColor();
            }
            return wire;
        }

        @Override
        public IComponentFactory.EnumPlacementType getPlacementType(ItemStack stack, EntityPlayer player) {
            return IComponentFactory.EnumPlacementType.DRAW;
        }

        @Override
        public ComponentWire getPlacementData(ICircuit circuit, BlockPos pos, EnumCircuitSide faceClicked, Vec3d hitVec, ItemStack stack, EntityPlayer player, IComponentFactory.EnumPlacementType type, ComponentWire previousData, Map<BlockPos, ComponentWire> otherData, IComponentFactory.EnumInstantanceUse use) {
            if (previousData != null) {
                return previousData;
            }
            if (!circuit.isSideSolid(pos.func_177977_b(), EnumCircuitSide.TOP)) {
                return null;
            }
            IComponent c = circuit.getComponent(pos, EnumComponentSlot.BOTTOM);
            return c instanceof ComponentWire ? (ComponentWire)c : this.mkWire(circuit, stack);
        }

        @Override
        public boolean placeComponent(ICircuit circuit, BlockPos pos, ComponentWire data, IComponentFactory.EnumPlacementType type, Map<BlockPos, ComponentWire> otherData, boolean simulate) {
            for (EnumCircuitSide side : EnumCircuitSide.HORIZONTALS) {
                ComponentWire neighbor = otherData.get(pos.func_177972_a(side.face));
                if (neighbor == null) continue;
                SimpleRedstoneConductor.ConnectionInfo info = data.cond.getNeighborsRAW()[side.ordinal()];
                info.type = IRedstoneConductor.EnumConnectionType.ANODE;
                info.neighbor = neighbor;
            }
            return circuit.addComponent(pos, data, simulate);
        }

        @Override
        public void drawPlacement(ICircuit circuit, BlockPos pos, ComponentWire data, IComponentFactory.EnumPlacementType type, Map<BlockPos, ComponentWire> otherData) {
            Pair<IRedstoneConductor.EnumConnectionType, Boolean> front = this.getState(circuit, pos, EnumCircuitSide.FRONT, otherData, data.connectOnAdd, data.color);
            Pair<IRedstoneConductor.EnumConnectionType, Boolean> back = this.getState(circuit, pos, EnumCircuitSide.BACK, otherData, data.connectOnAdd, data.color);
            Pair<IRedstoneConductor.EnumConnectionType, Boolean> left = this.getState(circuit, pos, EnumCircuitSide.LEFT, otherData, data.connectOnAdd, data.color);
            Pair<IRedstoneConductor.EnumConnectionType, Boolean> right = this.getState(circuit, pos, EnumCircuitSide.RIGHT, otherData, data.connectOnAdd, data.color);
            IBlockState state = data.getActualState().func_177226_a(FRONT, (Comparable)front.getKey()).func_177226_a(BACK, (Comparable)back.getKey()).func_177226_a(LEFT, (Comparable)left.getKey()).func_177226_a(RIGHT, (Comparable)right.getKey());
            SimpleFactory.draw(data, state, state);
            if (data.connectOnAdd) {
                if (((Boolean)front.getValue()).booleanValue()) {
                    state = data.getActualState().func_177226_a(FRONT, (Comparable)((Object)IRedstoneConductor.EnumConnectionType.NONE)).func_177226_a(BACK, (Comparable)front.getKey()).func_177226_a(LEFT, (Comparable)((Object)IRedstoneConductor.EnumConnectionType.NONE)).func_177226_a(RIGHT, (Comparable)((Object)IRedstoneConductor.EnumConnectionType.NONE));
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
                    SimpleFactory.draw(data, state, state);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                }
                if (((Boolean)back.getValue()).booleanValue()) {
                    state = data.getActualState().func_177226_a(FRONT, (Comparable)back.getKey()).func_177226_a(BACK, (Comparable)((Object)IRedstoneConductor.EnumConnectionType.NONE)).func_177226_a(LEFT, (Comparable)((Object)IRedstoneConductor.EnumConnectionType.NONE)).func_177226_a(RIGHT, (Comparable)((Object)IRedstoneConductor.EnumConnectionType.NONE));
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                    SimpleFactory.draw(data, state, state);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (((Boolean)left.getValue()).booleanValue()) {
                    state = data.getActualState().func_177226_a(FRONT, (Comparable)((Object)IRedstoneConductor.EnumConnectionType.NONE)).func_177226_a(BACK, (Comparable)((Object)IRedstoneConductor.EnumConnectionType.NONE)).func_177226_a(LEFT, (Comparable)((Object)IRedstoneConductor.EnumConnectionType.NONE)).func_177226_a(RIGHT, (Comparable)left.getKey());
                    GlStateManager.func_179109_b((float)1.0f, (float)0.0f, (float)0.0f);
                    SimpleFactory.draw(data, state, state);
                    GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
                }
                if (((Boolean)right.getValue()).booleanValue()) {
                    state = data.getActualState().func_177226_a(FRONT, (Comparable)((Object)IRedstoneConductor.EnumConnectionType.NONE)).func_177226_a(BACK, (Comparable)((Object)IRedstoneConductor.EnumConnectionType.NONE)).func_177226_a(LEFT, (Comparable)right.getKey()).func_177226_a(RIGHT, (Comparable)((Object)IRedstoneConductor.EnumConnectionType.NONE));
                    GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
                    SimpleFactory.draw(data, state, state);
                    GlStateManager.func_179109_b((float)1.0f, (float)0.0f, (float)0.0f);
                }
            }
        }

        private Pair<IRedstoneConductor.EnumConnectionType, Boolean> getState(ICircuit circuit, BlockPos pos, EnumCircuitSide side, Map<BlockPos, ComponentWire> otherData, boolean connectOnAdd, EnumDyeColor color) {
            IComponent c;
            if (otherData.containsKey(pos.func_177972_a(EnumCircuitSide.FRONT.face))) {
                return Pair.of((Object)((Object)IRedstoneConductor.EnumConnectionType.ANODE), (Object)true);
            }
            if (connectOnAdd && (c = circuit.getComponent(pos.func_177972_a(side.face), EnumComponentSlot.BOTTOM)) != null) {
                if (c instanceof IRedstoneConductor) {
                    EnumDyeColor col = ((IRedstoneConductor)((Object)c)).getColor();
                    return col == null || col == color ? Pair.of((Object)((Object)IRedstoneConductor.EnumConnectionType.ANODE), (Object)true) : Pair.of((Object)((Object)IRedstoneConductor.EnumConnectionType.NONE), (Object)false);
                }
                if (c.isInput(EnumComponentSlot.BOTTOM, side.getOpposite())) {
                    return Pair.of((Object)((Object)IRedstoneConductor.EnumConnectionType.ANODE), (Object)false);
                }
                if (c.isOutput(EnumComponentSlot.BOTTOM, side.getOpposite())) {
                    return Pair.of((Object)((Object)IRedstoneConductor.EnumConnectionType.CATHODE), (Object)false);
                }
                return Pair.of((Object)((Object)IRedstoneConductor.EnumConnectionType.NONE), (Object)false);
            }
            return Pair.of((Object)((Object)IRedstoneConductor.EnumConnectionType.NONE), (Object)false);
        }

        @Override
        public ComponentWire instantiate(ICircuit circuit) {
            return new ComponentWire(circuit);
        }
    }
}

