/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component.lamp;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.api.component.IPaintableComponent;
import com.amadornes.rscircuits.component.ComponentBaseInt;
import com.amadornes.rscircuits.component.SimpleFactory;
import com.amadornes.rscircuits.component.lamp.ComponentLamp;
import com.amadornes.rscircuits.init.SCMItems;
import com.amadornes.rscircuits.item.EnumResourceType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import mcmultipart.MCMultiPartMod;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;

public class ComponentLampSegmented
extends ComponentLamp
implements IPaintableComponent {
    public static final PropertyBool FRONT = PropertyBool.func_177716_a((String)"front");
    public static final PropertyBool BACK = PropertyBool.func_177716_a((String)"back");
    public static final PropertyBool LEFT = PropertyBool.func_177716_a((String)"left");
    public static final PropertyBool RIGHT = PropertyBool.func_177716_a((String)"right");
    public static final ResourceLocation NAME = new ResourceLocation("rscircuits", "lamp_segm");
    private EnumDyeColor color = EnumDyeColor.YELLOW;

    public ComponentLampSegmented(ICircuit circuit) {
        super(circuit);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public float getComplexity() {
        return 0.02f;
    }

    @Override
    public IBlockState getActualState() {
        return super.getActualState().func_177226_a(ON, (Comparable)Boolean.valueOf(this.state)).func_177226_a((IProperty)FRONT, (Comparable)Boolean.valueOf(this.isLampOn(EnumCircuitSide.FRONT))).func_177226_a((IProperty)BACK, (Comparable)Boolean.valueOf(this.isLampOn(EnumCircuitSide.BACK))).func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(this.isLampOn(EnumCircuitSide.LEFT))).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(this.isLampOn(EnumCircuitSide.RIGHT)));
    }

    private boolean isLampOn(EnumCircuitSide side) {
        if (this.getPos() == null || !this.state) {
            return false;
        }
        IComponent c = this.getCircuit().getComponent(this.getPos().func_177972_a(side.face), this.slot);
        return c != null && c instanceof ComponentLampSegmented && ((ComponentLampSegmented)c).state;
    }

    @Override
    public ItemStack getPickedItem() {
        return new ItemStack(SCMItems.resource, 1, EnumResourceType.TINY_LAMP_SEGMENTED.ordinal());
    }

    @Override
    public void addSelectionBoxes(List<AxisAlignedBB> boxes) {
        boxes.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
    }

    @Override
    public AxisAlignedBB getSelectionBox(AxisAlignedBB box) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    }

    @Override
    public int getColorMultiplier(int index) {
        return index == 0 ? this.color.func_176768_e().field_76291_p : super.getColorMultiplier(index);
    }

    @Override
    public boolean paint(EnumDyeColor color) {
        if (this.getCircuit().getWorld().field_72995_K) {
            ByteBuf buf = Unpooled.buffer();
            buf.writeByte(color.func_176765_a());
            this.getCircuit().sendCustomPayload(this.getPos(), this.slot, buf);
            return this.color != color;
        }
        this.color = color;
        return true;
    }

    @Override
    public void handleCustomPayload(ByteBuf buf) {
        this.color = EnumDyeColor.func_176764_b((int)(buf.readByte() & 0xFF));
        this.getCircuit().sendUpdate(this.getPos(), this.slot, false);
        this.getCircuit().markDirty();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag = super.writeToNBT(tag);
        tag.func_74768_a("color", this.color.func_176765_a());
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.color = tag.func_74764_b("color") ? EnumDyeColor.func_176764_b((int)tag.func_74762_e("color")) : EnumDyeColor.YELLOW;
    }

    @Override
    public void writeDescription(PacketBuffer buf) {
        super.writeDescription(buf);
        buf.func_179249_a((Enum)this.color);
    }

    @Override
    public void readDescription(PacketBuffer buf) {
        super.readDescription(buf);
        this.color = (EnumDyeColor)buf.func_179257_a(EnumDyeColor.class);
    }

    public static class Factory
    extends SimpleFactory<ComponentLampSegmented> {
        @Override
        public BlockStateContainer createBlockState() {
            return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[]{ComponentBaseInt.ON, FRONT, BACK, LEFT, RIGHT});
        }

        @Override
        public ResourceLocation getModelPath() {
            return new ResourceLocation("rscircuits", "component/lamp_segm");
        }

        @Override
        public boolean isValidPlacementStack(ItemStack stack, EntityPlayer player) {
            return stack.func_77973_b() == SCMItems.resource && stack.func_77952_i() == EnumResourceType.TINY_LAMP_SEGMENTED.ordinal();
        }

        @Override
        public ComponentLampSegmented instantiate(ICircuit circuit) {
            return new ComponentLampSegmented(circuit);
        }
    }
}

