/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.client;

import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.client.TmpModel;
import com.amadornes.rscircuits.part.PartCircuit;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import mcmultipart.client.multipart.MultipartSpecialRenderer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;

public class MSRCircuit
extends MultipartSpecialRenderer<PartCircuit> {
    public static final Matrix4f[] matrices = new Matrix4f[6];

    public void renderMultipartAt(PartCircuit part, double x_, double y_, double z_, float partialTicks, int destroyStage) {
        if (part.isEncapsulated() || part.isSad()) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vb = tessellator.func_178180_c();
        this.bindTexture(TextureMap.field_110575_b);
        RenderHelper.func_74518_a();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179147_l();
        GlStateManager.func_179089_o();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x_, (double)y_, (double)z_);
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        List<BakedQuad> quads = TmpModel.INSTANCE.getQuads();
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 5; ++y) {
                for (int z = 0; z < 8; ++z) {
                    pos.func_181079_c(x, y, z);
                    for (int s = 0; s < 7; ++s) {
                        IBlockState actualState;
                        IComponent c = part.circuit.components[x][y][z][s];
                        if (c == null || !c.isDynamic() || (actualState = c.getActualState()) == null) continue;
                        IBakedModel model = brd.func_184389_a(actualState);
                        IBlockState extendedState = c.getExtendedState(actualState);
                        float size = c.getSize();
                        Vec3d offset = c.getOffset();
                        ArrayList mQuads = new ArrayList(model.func_188616_a(extendedState, null, 0L));
                        for (EnumFacing f : EnumFacing.field_82609_l) {
                            mQuads.addAll(model.func_188616_a(extendedState, f, 0L));
                        }
                        mQuads.forEach(q -> {
                            int multiplier = q.func_178212_b() ? c.getColorMultiplier(q.func_178211_c()) : -1;
                            Color colorMultiplier = multiplier != -1 ? new Color(multiplier, false) : null;
                            int[] data = (int[])q.func_178209_a().clone();
                            for (int i = 0; i < 4; ++i) {
                                Point3f point = new Point3f((Float.intBitsToFloat(data[i * 7 + 0]) - 0.5f + (offset != null ? (float)offset.field_72450_a : 0.0f)) * size + ((float)pos.func_177958_n() + 0.5f) * 0.125f + 0.0625f, (Float.intBitsToFloat(data[i * 7 + 1]) + (offset != null ? (float)offset.field_72448_b : 0.0f)) * size + (float)pos.func_177956_o() * 0.125f + 0.125f, (Float.intBitsToFloat(data[i * 7 + 2]) - 0.5f + (offset != null ? (float)offset.field_72449_c : 0.0f)) * size + ((float)pos.func_177952_p() + 0.5f) * 0.125f + 0.0625f);
                                matrices[part.getFace().ordinal()].transform(point);
                                data[i * 7 + 0] = Float.floatToRawIntBits(point.x);
                                data[i * 7 + 1] = Float.floatToRawIntBits(point.y);
                                data[i * 7 + 2] = Float.floatToRawIntBits(point.z);
                                if (colorMultiplier == null) continue;
                                Color color = new Color(data[i * 7 + 3]);
                                data[i * 7 + 3] = color.getAlpha() << 24 | color.getRed() * colorMultiplier.getBlue() / 255 << 16 | color.getGreen() * colorMultiplier.getGreen() / 255 << 8 | color.getBlue() * colorMultiplier.getRed() / 255 << 0;
                            }
                            quads.add(new BakedQuad(data, q.func_178211_c(), q.func_178210_d(), q.func_187508_a(), q.shouldApplyDiffuseLighting(), q.getFormat()));
                        });
                    }
                }
            }
        }
        vb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        vb.func_178969_c((double)(-part.getPos().func_177958_n()), (double)(-part.getPos().func_177956_o()), (double)(-part.getPos().func_177952_p()));
        brd.func_175019_b().func_178267_a((IBlockAccess)this.getWorld(), (IBakedModel)TmpModel.INSTANCE, Blocks.field_150348_b.func_176223_P(), part.getPos(), vb, false);
        vb.func_178969_c(0.0, 0.0, 0.0);
        Tessellator.func_178181_a().func_78381_a();
        quads.clear();
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
    }

    static {
        Matrix4f tr1 = new Matrix4f();
        tr1.setIdentity();
        tr1.setTranslation(new Vector3f(0.5f, 0.5f, 0.5f));
        Matrix4f tr2 = new Matrix4f();
        tr2.setIdentity();
        tr2.setTranslation(new Vector3f(-0.5f, -0.5f, -0.5f));
        Matrix4f rot1 = new Matrix4f();
        Matrix4f rot2 = new Matrix4f();
        for (EnumFacing f : EnumFacing.field_82609_l) {
            rot1.setIdentity();
            rot2.setIdentity();
            switch (f) {
                case DOWN: {
                    break;
                }
                case UP: {
                    rot1.rotY((float)Math.toRadians(180.0));
                    rot2.rotZ((float)Math.toRadians(180.0));
                    break;
                }
                case NORTH: {
                    rot1.rotY((float)Math.toRadians(-90.0));
                    rot2.rotX((float)Math.toRadians(90.0));
                    break;
                }
                case SOUTH: {
                    rot1.rotY((float)Math.toRadians(90.0));
                    rot2.rotX((float)Math.toRadians(-90.0));
                    break;
                }
                case WEST: {
                    rot2.rotZ((float)Math.toRadians(-90.0));
                    break;
                }
                case EAST: {
                    rot1.rotY((float)Math.toRadians(180.0));
                    rot2.rotZ((float)Math.toRadians(90.0));
                    break;
                }
            }
            Matrix4f mat = new Matrix4f();
            mat.setIdentity();
            mat.mul(tr1);
            mat.mul(rot2);
            mat.mul(rot1);
            mat.mul(tr2);
            MSRCircuit.matrices[f.ordinal()] = mat;
        }
    }
}

