/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad.gui;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.gui.widget.TextFieldEnder;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import com.google.common.collect.Lists;
import crazypants.enderio.EnderIO;
import crazypants.enderio.GuiID;
import crazypants.enderio.config.Config;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.gui.GuiContainerBaseEIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.PowerDisplayUtil;
import crazypants.enderio.teleport.telepad.TelepadTarget;
import crazypants.enderio.teleport.telepad.TileTelePad;
import crazypants.enderio.teleport.telepad.gui.ContainerTelePad;
import crazypants.enderio.teleport.telepad.gui.IToggleableGui;
import crazypants.enderio.teleport.telepad.gui.ToggleTravelButton;
import crazypants.enderio.teleport.telepad.packet.PacketOpenServerGui;
import crazypants.enderio.teleport.telepad.packet.PacketSetTarget;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiTelePad
extends GuiContainerBaseEIO
implements IToggleableGui {
    private static final int ID_SWITCH_BUTTON = 95;
    private static final int ID_TELEPORT_BUTTON = 96;
    ToggleTravelButton switchButton;
    GuiButton teleportButton;
    private final TileTelePad te;
    private TextFieldEnder xTF;
    private TextFieldEnder yTF;
    private TextFieldEnder zTF;
    private TextFieldEnder dimTF;
    private static final int powerX = 8;
    private static final int powerY = 9;
    private int powerScale = Config.telepadFluidUse > 0 ? 57 : 120;
    private static final int progressX = 26;
    private static final int progressY = 110;
    private static final int progressScale = 124;
    private static final int fluidX = 8;
    private static final int fluidY = 71;
    private static final int fluidScale = 58;
    private static final Rectangle RECTANGLE_TANK = new Rectangle(8, 71, 10, 58);
    public static int SWITCH_X = 155;
    public static int SWITCH_Y = 5;

    public GuiTelePad(InventoryPlayer playerInv, final TileTelePad te) {
        super((Container)new ContainerTelePad(playerInv, te), "telePad");
        this.te = te;
        this.field_147000_g = 220;
        this.addToolTip(new GuiToolTip(new Rectangle(8, 9, 10, this.powerScale), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                GuiTelePad.this.updatePowerBarTooltip(this.text);
            }
        });
        this.addToolTip(new GuiToolTip(new Rectangle(26, 110, 124, 10), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                this.text.add(Math.round(GuiTelePad.this.te.getProgress() * 100.0f) + "%");
            }
        });
        if (Config.telepadFluidUse > 0) {
            this.addToolTip(new GuiToolTip(RECTANGLE_TANK, new String[]{""}){

                protected void updateText() {
                    this.text.clear();
                    String heading = EnderIO.lang.localize("tank.tank");
                    if (te.getTank().getFluid() != null) {
                        heading = heading + ": " + new FluidStack(te.getFluidType(), 1000).getLocalizedName();
                    }
                    this.text.add(heading);
                    this.text.add(Fluids.toCapactityString((IFluidTank)te.getTank()));
                }
            });
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int x = 48;
        int y = 24;
        int tfHeight = 12;
        int tfWidth = this.field_146999_f - x * 2;
        this.xTF = new TextFieldEnder(fr, x, y, tfWidth, tfHeight, TextFieldEnder.FILTER_NUMERIC);
        this.yTF = new TextFieldEnder(fr, x, y + this.xTF.field_146219_i + 2, tfWidth, tfHeight, TextFieldEnder.FILTER_NUMERIC);
        this.zTF = new TextFieldEnder(fr, x, y + this.xTF.field_146219_i * 2 + 4, tfWidth, tfHeight, TextFieldEnder.FILTER_NUMERIC);
        this.dimTF = new TextFieldEnder(fr, x, y + this.xTF.field_146219_i * 3 + 6, tfWidth, tfHeight, TextFieldEnder.FILTER_NUMERIC);
        this.xTF.func_146180_a(Integer.toString(te.getX()));
        this.yTF.func_146180_a(Integer.toString(te.getY()));
        this.zTF.func_146180_a(Integer.toString(te.getZ()));
        this.dimTF.func_146180_a(Integer.toString(te.getTargetDim()));
        this.xTF.func_146205_d(!Config.telepadLockCoords);
        this.yTF.func_146205_d(!Config.telepadLockCoords);
        this.zTF.func_146205_d(!Config.telepadLockCoords);
        this.dimTF.func_146205_d(!Config.telepadLockDimension);
        this.textFields.addAll(Lists.newArrayList((Object[])new TextFieldEnder[]{this.xTF, this.yTF, this.zTF, this.dimTF}));
        this.switchButton = new ToggleTravelButton(this, 95, SWITCH_X, SWITCH_Y, IconEIO.IO_WHATSIT);
        this.switchButton.setToolTip(new String[]{EnderIO.lang.localize("gui.telepad.configure.travel")});
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(int mouseX, int mouseY) {
        if (RECTANGLE_TANK.contains(mouseX, mouseY)) {
            return this.te.getTank().getFluid();
        }
        return super.getIngredientUnderMouse(mouseX, mouseY);
    }

    private String getPowerOutputLabel() {
        return I18n.func_135052_a((String)"enderio.gui.max", (Object[])new Object[0]);
    }

    protected int getPowerOutputValue() {
        return this.te.getUsage();
    }

    protected void updatePowerBarTooltip(List<String> text) {
        text.add(this.getPowerOutputLabel() + " " + PowerDisplayUtil.formatPower(this.getPowerOutputValue()) + " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr());
        text.add(PowerDisplayUtil.formatStoredPower(this.te.getEnergyStored(null), this.te.getMaxEnergyStored(null)));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.switchButton.onGuiInit();
        String text = EnderIO.lang.localize("gui.telepad.teleport");
        int width = this.getFontRenderer().func_78256_a(text) + 10;
        int x = this.field_147003_i + this.field_146999_f / 2 - width / 2;
        int y = this.field_147009_r + 83;
        this.teleportButton = new GuiButton(96, x, y, width, 20, text);
        this.addButton(this.teleportButton);
        ((ContainerTelePad)this.field_147002_h).createGhostSlots(this.getGhostSlots());
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.te.getStackInSlot(0) != null) {
            this.te.setTarget(TelepadTarget.readFromNBT(this.te.getStackInSlot(0)));
            this.xTF.func_146180_a(Integer.toString(this.te.getX()));
            this.yTF.func_146180_a(Integer.toString(this.te.getY()));
            this.zTF.func_146180_a(Integer.toString(this.te.getZ()));
            this.dimTF.func_146180_a(Integer.toString(this.te.getTargetDim()));
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        this.updateCoords();
    }

    private void updateCoords() {
        BlockCoord bc = new BlockCoord(this.getIntFromTextBox(this.xTF), this.getIntFromTextBox(this.yTF), this.getIntFromTextBox(this.zTF));
        int targetDim = this.getIntFromTextBox(this.dimTF);
        if (bc.x != this.te.getX() || bc.y != this.te.getY() || bc.z != this.te.getZ() || targetDim != this.te.getTargetDim()) {
            this.te.setX(bc.x);
            this.te.setY(bc.y);
            this.te.setZ(bc.z);
            this.te.setTargetDim(targetDim);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetTarget(this.te, this.te.getTarget()));
        }
    }

    private int getIntFromTextBox(TextFieldEnder tf) {
        String text = tf.func_146179_b();
        if ("".equals(text) || "-".equals(text)) {
            return 0;
        }
        return Integer.parseInt(text);
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        String name;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        int u = Config.telepadFluidUse > 0 ? 200 : 187;
        int v = 0;
        this.func_73729_b(sx + 8 - 1, sy + 9 - 1, u, v, 12, 122);
        if (Config.telepadFluidUse > 0 && this.te.getFluidAmount() > 0) {
            RenderUtil.renderGuiTank((FluidTank)this.te.getTank(), (double)(sx + 8), (double)(sy + 71), (double)0.0, (double)10.0, (double)58.0);
            this.bindGuiTexture();
            this.func_73729_b(sx + 8, sy + 71, 213, v, 10, 58);
        }
        int powerScaled = this.te.getPowerScaled(this.powerScale);
        this.func_73729_b(sx + 8, sy + 9 + this.powerScale - powerScaled, this.field_146999_f, 0, 10, powerScaled);
        int progressScaled = Util.getProgressScaled((int)124, (IProgressTile)this.te);
        this.func_73729_b(sx + 26, sy + 110, 0, this.field_147000_g, progressScaled, 10);
        FontRenderer fnt = this.getFontRenderer();
        String[] text = new String[]{"X", "Y", "Z", "DIM"};
        for (int i = 0; i < text.length; ++i) {
            TextFieldEnder f = (TextFieldEnder)this.textFields.get(i);
            fnt.func_78276_b(text[i], f.field_146209_f - fnt.func_78256_a(text[i]) / 2 - 10, f.field_146210_g + (f.field_146219_i - fnt.field_78288_b) / 2 + 1, 0);
            if (f.getCanLoseFocus()) continue;
            IconEIO.map.render((IWidgetIcon)IconEIO.LOCK_LOCKED, (double)(f.field_146209_f + f.field_146218_h - 2), (double)(f.field_146210_g - 2), true);
        }
        Entity e = this.te.getCurrentTarget();
        if (e != null) {
            name = e.func_70005_c_();
            fnt.func_78276_b(name, sx + this.field_146999_f / 2 - fnt.func_78256_a(name) / 2, sy + 110 + fnt.field_78288_b + 6, 0);
        } else if (this.te.wasBlocked()) {
            String s = EnderIO.lang.localize("gui.telepad.blocked");
            fnt.func_78276_b(s, sx + this.field_146999_f / 2 - fnt.func_78256_a(s) / 2, sy + 110 + fnt.field_78288_b + 6, 0xAA0000);
        }
        name = this.te.getTarget().getName();
        if (name != null) {
            fnt.func_175063_a(name, (float)(sx + this.field_146999_f / 2 - fnt.func_78256_a(name) / 2), (float)(this.getGuiTop() + 10), 0xFFFFFF);
        }
        super.func_146976_a(p_146976_1_, p_146976_2_, p_146976_3_);
    }

    @Override
    public void switchGui() {
        BlockPos pos = this.te.getLocation().getBlockPos();
        GuiID.GUI_ID_TELEPAD_TRAVEL.openClientGui(this.te.func_145831_w(), pos, (EntityPlayer)this.field_146297_k.field_71439_g, null);
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketOpenServerGui(this.te, GuiID.GUI_ID_TELEPAD_TRAVEL));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 96) {
            this.te.teleportAll();
        }
    }
}

