/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render.pipeline;

import crazypants.enderio.Log;
import crazypants.enderio.paint.render.PaintedBlockAccessWrapper;
import crazypants.enderio.render.util.QuadCollector;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;

public class PaintWrangler {
    private static final BlockRenderLayer BREAKING = null;
    private static final ConcurrentHashMap<Block, Memory> cache = new ConcurrentHashMap();

    public static boolean wrangleBakedModel(IBlockAccess blockAccess, BlockPos pos, IBlockState paintSource, QuadCollector quads) {
        IBakedModel paintModel;
        IBlockState actualPaintSource = paintSource;
        IBlockState extendedPaintSource = paintSource;
        if (paintSource == null) {
            return false;
        }
        Block block = paintSource.func_177230_c();
        if (block == null) {
            return false;
        }
        Memory memory = cache.get(block);
        if (memory == null) {
            memory = new Memory();
            cache.put(block, memory);
        }
        if (!memory.doPaint) {
            return false;
        }
        PaintedBlockAccessWrapper fakeWorld = null;
        if (memory.doActualState || memory.doExtendedState) {
            fakeWorld = PaintedBlockAccessWrapper.instance(blockAccess);
            if (memory.doActualState) {
                try {
                    extendedPaintSource = actualPaintSource = paintSource.func_185899_b((IBlockAccess)fakeWorld, pos);
                }
                catch (Throwable t) {
                    Log.warn("Failed to get actual state of block " + paintSource.func_177230_c() + " to use as paint. Error while rendering: " + t);
                    memory.doActualState = false;
                }
            }
            if (memory.doExtendedState) {
                try {
                    extendedPaintSource = block.getExtendedState(actualPaintSource, (IBlockAccess)fakeWorld, pos);
                }
                catch (Throwable t) {
                    Log.warn("Failed to get extended state of block " + paintSource.func_177230_c() + " to use as paint. Error while rendering: " + t);
                    memory.doExtendedState = false;
                }
            }
        }
        if ((paintModel = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(actualPaintSource)) == null) {
            if (fakeWorld != null) {
                fakeWorld.free();
            }
            return false;
        }
        long positionRandom = MathHelper.func_180186_a((Vec3i)pos);
        BlockRenderLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
        for (BlockRenderLayer layer : quads.getBlockLayers()) {
            if (layer != BREAKING && !paintSource.func_177230_c().canRenderInLayer(extendedPaintSource, layer)) continue;
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
            List<String> errors = quads.addUnfriendlybakedModel(layer, paintModel, extendedPaintSource, positionRandom);
            if (errors == null) continue;
            memory.doPaint = false;
            Log.error("Failed to use block " + paintSource.func_177230_c() + " as paint. Error(s) while rendering: " + errors);
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
            if (fakeWorld != null) {
                fakeWorld.free();
            }
            return false;
        }
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
        if (fakeWorld != null) {
            fakeWorld.free();
        }
        return true;
    }

    private static class Memory {
        boolean doActualState = true;
        boolean doExtendedState = true;
        boolean doPaint = true;

        private Memory() {
        }
    }
}

