/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render.pipeline;

import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.render.model.CollectedQuadBakedBlockModel;
import crazypants.enderio.render.model.NullModel;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.render.pipeline.PaintWrangler;
import crazypants.enderio.render.util.QuadCollector;
import crazypants.util.Profiler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;

public class BlockStateWrapperRelay
extends BlockStateWrapperBase {
    private static final NullModel NULL = new NullModel();

    public BlockStateWrapperRelay(IBlockState state, IBlockAccess world, BlockPos pos) {
        super(state, world, pos, null);
    }

    @Override
    public void bakeModel() {
        String cacheResult;
        long start = Profiler.instance.start();
        QuadCollector paintQuads = new QuadCollector();
        boolean hasPaintRendered = false;
        if (!(!(this.block instanceof IPaintable.IBlockPaintableBlock) || this.block instanceof IPaintable.IWrenchHideablePaint && this.getYetaDisplayMode().isHideFacades())) {
            hasPaintRendered = PaintWrangler.wrangleBakedModel(this.world, this.pos, ((IPaintable.IBlockPaintableBlock)this.block).getPaintSource(this.state, this.world, this.pos), paintQuads);
        }
        if (!hasPaintRendered) {
            if (MinecraftForgeClient.getRenderLayer() == null || MinecraftForgeClient.getRenderLayer() == this.block.func_180664_k()) {
                this.model = null;
                cacheResult = "relaying";
            } else {
                this.model = NULL;
                cacheResult = "none";
            }
        } else {
            this.model = new CollectedQuadBakedBlockModel(paintQuads);
            cacheResult = "paint only";
        }
        Profiler.instance.stop(start, this.state.func_177230_c().func_149732_F() + " (bake, cache=" + cacheResult + ")");
    }

    @Override
    public IBakedModel getModel() {
        return this.model;
    }
}

