/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.power.forge;

import crazypants.enderio.power.IInternalPoweredItem;
import crazypants.enderio.power.ItemPowerCapabilityProvider;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class InternalPoweredItemWrapper
implements IEnergyStorage {
    protected final ItemStack container;
    protected IInternalPoweredItem item;

    public InternalPoweredItemWrapper(ItemStack container) {
        this.container = container;
        this.item = (IInternalPoweredItem)container.func_77973_b();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energy = this.getEnergyStored();
        int energyReceived = Math.min(this.getMaxEnergyStored() - energy, Math.min(this.item.getMaxInput(this.container), maxReceive));
        if (!simulate) {
            this.setEnergyStored(energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energy = this.getEnergyStored();
        int energyExtracted = Math.min(energy, Math.min(this.item.getMaxOutput(this.container), maxExtract));
        if (!simulate) {
            this.setEnergyStored(energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public void setEnergyStored(int energy) {
        this.item.setEnergyStored(this.container, energy);
    }

    public int getEnergyStored() {
        return this.item.getEnergyStored(this.container);
    }

    public int getMaxEnergyStored() {
        return this.item.getMaxEnergyStored(this.container);
    }

    public boolean canExtract() {
        if (this.container.field_77994_a > 1) {
            return false;
        }
        return this.item.getMaxOutput(this.container) > 0;
    }

    public boolean canReceive() {
        if (this.container.field_77994_a > 1) {
            return false;
        }
        return this.item.getMaxInput(this.container) > 0;
    }

    public static class PoweredItemCapabilityProvider
    implements ItemPowerCapabilityProvider {
        @Override
        public boolean hasCapability(ItemStack stack, Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityEnergy.ENERGY;
        }

        @Override
        public <T> T getCapability(ItemStack stack, Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)new InternalPoweredItemWrapper(stack));
            }
            return null;
        }
    }
}

