/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.paint;

import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.util.Prep;
import crazypants.util.Things;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PaintTooltipUtil {
    private static Things paintables = new Things(new String[0]);

    public static void create() {
        MinecraftForge.EVENT_BUS.register(PaintTooltipUtil.class);
    }

    private PaintTooltipUtil() {
    }

    public static void registerPaintable(Block ... blocks) {
        for (Block block : blocks) {
            if (block instanceof IPaintable) continue;
            paintables.add(block);
        }
    }

    public static void registerPaintable(Item ... items) {
        for (Item item : items) {
            if (Block.func_149634_a((Item)item) instanceof IPaintable) continue;
            paintables.add(item);
        }
    }

    public static boolean isPaintable(ItemStack stack) {
        if (Prep.isInvalid(stack)) {
            return false;
        }
        return PainterUtil2.isPainted(stack) || Block.func_149634_a((Item)stack.func_77973_b()) instanceof IPaintable || paintables.contains(stack);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void addTooltip(ItemTooltipEvent evt) {
        if (PaintTooltipUtil.isPaintable(evt.getItemStack())) {
            evt.getToolTip().add(PainterUtil2.getTooltTipText(evt.getItemStack()));
        }
    }
}

