/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.zombie;

import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.generator.zombie.ContainerZombieGenerator;
import crazypants.enderio.machine.generator.zombie.TileZombieGenerator;
import crazypants.enderio.machine.gui.GuiPoweredMachineBase;
import crazypants.enderio.power.PowerDisplayUtil;
import java.awt.Color;
import java.awt.Rectangle;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;

public class GuiZombieGenerator
extends GuiPoweredMachineBase<TileZombieGenerator> {
    private static final Rectangle RECTANGLE_FUEL_TANK = new Rectangle(80, 21, 15, 47);

    public GuiZombieGenerator(InventoryPlayer inventory, final TileZombieGenerator tileEntity) {
        super(tileEntity, (Container)new ContainerZombieGenerator(inventory, tileEntity), "zombieGenerator");
        this.addToolTip(new GuiToolTip(RECTANGLE_FUEL_TANK, new String[]{""}){

            protected void updateText() {
                this.text.clear();
                String heading = EnderIO.lang.localize("zombieGenerator.fuelTank");
                this.text.add(heading);
                this.text.add(Fluids.toCapactityString((IFluidTank)((TileZombieGenerator)((GuiZombieGenerator)GuiZombieGenerator.this).getTileEntity()).tank));
                if (tileEntity.tank.getFluidAmount() < tileEntity.getActivationAmount()) {
                    this.text.add(EnderIO.lang.localize("gui.fluid.minReq", new Object[]{tileEntity.getActivationAmount() + Fluids.MB()}));
                }
            }
        });
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(int mouseX, int mouseY) {
        if (RECTANGLE_FUEL_TANK.contains(mouseX, mouseY)) {
            return ((TileZombieGenerator)this.getTileEntity()).tank.getFluid();
        }
        return super.getIngredientUnderMouse(mouseX, mouseY);
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    public void renderSlotHighlights(IoMode mode) {
        super.renderSlotHighlights(mode);
        if (mode == IoMode.PULL || mode == IoMode.PUSH_PULL) {
            int x = 78;
            int y = 19;
            int w = 19;
            int h = 51;
            this.renderSlotHighlight(PULL_COLOR, x, y, w, h);
        }
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        TileZombieGenerator gen = (TileZombieGenerator)this.getTileEntity();
        FontRenderer fr = this.getFontRenderer();
        int output = 0;
        if (gen.isActive()) {
            output = gen.outputPerTick;
        }
        String txt = EnderIO.lang.localize("combustionGenerator.output") + " " + PowerDisplayUtil.formatPower(output) + " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr();
        int sw = fr.func_78256_a(txt);
        fr.func_175063_a(txt, (float)(this.field_147003_i + this.field_146999_f / 2 - sw / 2), (float)(this.field_147009_r + fr.field_78288_b / 2 + 3), ColorUtil.getRGB((Color)Color.WHITE));
        int x = this.field_147003_i + 80;
        int y = this.field_147009_r + 21;
        if (gen.tank.getFluidAmount() > 0) {
            RenderUtil.renderGuiTank((FluidStack)gen.tank.getFluid(), (int)gen.tank.getCapacity(), (int)gen.tank.getFluidAmount(), (double)x, (double)y, (double)this.field_73735_i, (double)16.0, (double)47.0);
            if (gen.isActive()) {
                txt = gen.tickPerBucketOfFuel / 1000 + " " + EnderIO.lang.localize("power.tmb");
                sw = fr.func_78256_a(txt);
                fr.func_175063_a(txt, (float)(x - sw / 2 + 7), (float)(y + fr.field_78288_b / 2 + 46), ColorUtil.getRGB((Color)Color.WHITE));
            }
        }
        this.bindGuiTexture();
        super.func_146976_a(par1, par2, par3);
    }

    @Override
    protected int getPowerX() {
        return 15;
    }

    @Override
    protected int getPowerY() {
        return 20;
    }

    @Override
    protected int getPowerHeight() {
        return 48;
    }
}

