/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.render;

import crazypants.enderio.conduit.TileConduitBundle;
import crazypants.enderio.conduit.geom.ConduitConnectorType;
import crazypants.enderio.conduit.registry.ConduitRegistry;
import crazypants.enderio.conduit.render.ConduitBundleRenderer;
import crazypants.enderio.conduit.render.ConduitRenderer;
import crazypants.enderio.render.registry.TextureRegistry;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ConduitBundleRenderManager {
    public static final ConduitBundleRenderManager instance = new ConduitBundleRenderManager();
    private final ConduitBundleRenderer cbr = new ConduitBundleRenderer();
    public static final TextureRegistry.TextureSupplier connectorIconExternal = TextureRegistry.registerTexture("blocks/conduitConnector");
    public static final TextureRegistry.TextureSupplier connectorIcon = TextureRegistry.registerTexture("blocks/conduitConnector");
    public static final TextureRegistry.TextureSupplier wireFrameIcon = TextureRegistry.registerTexture("blocks/wireFrame");

    public void init(FMLPreInitializationEvent event) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileConduitBundle.class, (TileEntitySpecialRenderer)this.cbr);
    }

    public void init(FMLPostInitializationEvent event) {
        for (ConduitRegistry.ConduitInfo conduitInfo : ConduitRegistry.getAll()) {
            for (ConduitRenderer renderer : conduitInfo.getRenderers()) {
                renderer.initIcons();
                this.cbr.registerRenderer(renderer);
            }
        }
    }

    public TextureAtlasSprite getConnectorIcon(Object data) {
        return (data == ConduitConnectorType.EXTERNAL ? connectorIconExternal : connectorIcon).get(TextureAtlasSprite.class);
    }

    public TextureAtlasSprite getWireFrameIcon() {
        return wireFrameIcon.get(TextureAtlasSprite.class);
    }

    public ConduitBundleRenderer getConduitBundleRenderer() {
        return this.cbr;
    }
}

