/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public enum SpeedUpgrade {
    UPGRADE("extractSpeedUpgrade", "item.itemExtractSpeedUpgrade", 15){

        @Override
        public int getMaximumExtracted(int stackSize) {
            return 4 + Math.min(stackSize, this.maxStackSize) * 4;
        }
    }
    ,
    DOWNGRADE("extractSpeedDowngrade", "item.itemExtractSpeedDowngrade", 1){

        @Override
        public int getMaximumExtracted(int stackSize) {
            return 1;
        }
    };

    public static final int BASE_MAX_EXTRACTED = 4;
    public final String baseName;
    public final String iconName;
    public final String unlocName;
    public final int maxStackSize;

    public static List<ResourceLocation> resources() {
        ArrayList<ResourceLocation> res = new ArrayList<ResourceLocation>(SpeedUpgrade.values().length);
        for (SpeedUpgrade c : SpeedUpgrade.values()) {
            res.add(new ResourceLocation(c.iconName));
        }
        return res;
    }

    private SpeedUpgrade(String iconName, String unlocName, int maxStackSize) {
        this.baseName = iconName;
        this.iconName = "enderio:" + iconName;
        this.unlocName = unlocName;
        this.maxStackSize = maxStackSize;
    }

    public abstract int getMaximumExtracted(int var1);
}

