/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.capacitor;

import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.capacitor.ICapacitorData;
import crazypants.enderio.capacitor.ICapacitorDataItem;
import crazypants.enderio.capacitor.NBTCapacitorData;
import crazypants.util.Prep;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.tuple.Pair;

public class CapacitorHelper {
    private CapacitorHelper() {
    }

    public static ICapacitorData getCapacitorDataFromItemStack(ItemStack stack) {
        if (Prep.isInvalid(stack)) {
            return null;
        }
        ICapacitorData capData = CapacitorHelper.getNBTCapacitorDataFromItemStack(stack);
        if (capData != null) {
            return capData;
        }
        if (stack.func_77973_b() instanceof ICapacitorDataItem) {
            return ((ICapacitorDataItem)stack.func_77973_b()).getCapacitorData(stack);
        }
        return null;
    }

    public static boolean isValidUpgrade(ItemStack stack) {
        if (Prep.isInvalid(stack)) {
            return false;
        }
        ICapacitorData capData = CapacitorHelper.getNBTCapacitorDataFromItemStack(stack);
        if (capData != null) {
            return true;
        }
        if (stack.func_77973_b() == ModObject.itemBasicCapacitor.getItem()) {
            return stack.func_77952_i() > 0;
        }
        return stack.func_77973_b() instanceof ICapacitorDataItem;
    }

    protected static ICapacitorData getNBTCapacitorDataFromItemStack(ItemStack stack) {
        NBTTagCompound nbtRoot = stack.func_77978_p();
        if (nbtRoot == null) {
            return null;
        }
        if (!nbtRoot.func_150297_b("eiocap", 10)) {
            return null;
        }
        NBTTagCompound nbtTag = nbtRoot.func_74775_l("eiocap");
        if (!nbtTag.func_150297_b("level", 99)) {
            return null;
        }
        int capLevel = nbtTag.func_74762_e("level");
        if (capLevel <= 0 || capLevel > 99) {
            return null;
        }
        return new NBTCapacitorData(stack.func_77973_b().func_77667_c(stack), capLevel, nbtTag);
    }

    public static ItemStack addCapData(ItemStack stack, SetType setType, CapacitorKey key, float value) {
        NBTTagCompound root = stack.func_77978_p();
        if (root == null) {
            root = new NBTTagCompound();
            stack.func_77982_d(root);
        }
        NBTTagCompound tag = root.func_74775_l("eiocap");
        root.func_74782_a("eiocap", (NBTBase)tag);
        switch (setType) {
            case LEVEL: {
                tag.func_74768_a("level", (int)value);
                break;
            }
            case NAME: {
                tag.func_74776_a(key.getName(), value);
                break;
            }
            case OWNER_TYPE: {
                NBTTagCompound subtag = tag.func_74775_l(key.getOwner().getUnlocalisedName());
                subtag.func_74776_a(key.getValueType().getName(), value);
                break;
            }
            case TYPE: {
                tag.func_74776_a(key.getValueType().getName(), value);
            }
        }
        return stack;
    }

    public static List<Pair<String, Float>> getCapDataRaw(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("eiocap", false);
        if (tag == null) {
            return null;
        }
        ArrayList<Pair<String, Float>> result = new ArrayList<Pair<String, Float>>();
        for (String key : tag.func_150296_c()) {
            if (!tag.func_150297_b(key, 5)) continue;
            result.add((Pair<String, Float>)Pair.of((Object)key, (Object)Float.valueOf(tag.func_74760_g(key))));
        }
        return result;
    }

    public static int getCapLevelRaw(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("eiocap", false);
        if (tag == null) {
            return 1;
        }
        return tag.func_74762_e("level");
    }

    public static enum SetType {
        LEVEL,
        NAME,
        OWNER_TYPE,
        TYPE;

    }
}

