/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio;

import com.enderio.core.common.TileEntityBase;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.config.Config;
import info.loenwind.autosave.Reader;
import info.loenwind.autosave.Writer;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public abstract class TileEntityEio
extends TileEntityBase {
    private static final Vector4f COLOR = new Vector4f(1.0f, 0.7137255f, 0.0f, 0.4f);
    protected boolean doingOtherNbt = false;
    private static final List<TileEntity> notTickingTileEntitiesS = new ArrayList<TileEntity>();
    private static final List<TileEntity> notTickingTileEntitiesC = new ArrayList<TileEntity>();

    protected TileEntityEio() {
        if (Config.debugTraceTELivecycleExtremelyDetailed) {
            StringBuilder sb = new StringBuilder("TE ").append((Object)this).append(" created");
            for (StackTraceElement elem : new Exception("Stackstrace").getStackTrace()) {
                sb.append(" at ").append(elem);
            }
            Log.warn(sb);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (Config.debugTraceTELivecycleExtremelyDetailed) {
            StringBuilder sb = new StringBuilder("TE ").append((Object)this).append(" invalidated");
            for (StackTraceElement elem : new Exception("Stackstrace").getStackTrace()) {
                sb.append(" at ").append(elem);
            }
            Log.warn(sb);
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (Config.debugTraceTELivecycleExtremelyDetailed) {
            StringBuilder sb = new StringBuilder("TE ").append((Object)this).append(" unloaded");
            for (StackTraceElement elem : new Exception("Stackstrace").getStackTrace()) {
                sb.append(" at ").append(elem);
            }
            Log.warn(sb);
        }
    }

    public final SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound root = this.createClientUpdateNBT();
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, root);
    }

    public NBTTagCompound func_189517_E_() {
        return this.createClientUpdateNBT();
    }

    protected NBTTagCompound createClientUpdateNBT() {
        NBTTagCompound root = new NBTTagCompound();
        try {
            this.doingOtherNbt = true;
            super.func_189515_b(root);
        }
        finally {
            this.doingOtherNbt = false;
        }
        Writer.write(Store.StoreFor.CLIENT, root, this);
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound root = pkt.func_148857_g();
        Reader.read(Store.StoreFor.CLIENT, root, this);
        try {
            this.doingOtherNbt = true;
            super.func_145839_a(root);
        }
        finally {
            this.doingOtherNbt = false;
        }
        this.onAfterDataPacket();
        if (Config.debugUpdatePackets) {
            EnderIO.proxy.markBlock(this.func_145831_w(), this.func_174877_v(), COLOR);
        }
    }

    protected void onAfterDataPacket() {
    }

    protected void writeCustomNBT(NBTTagCompound root) {
        if (!this.doingOtherNbt) {
            Writer.write(Store.StoreFor.SAVE, root, this);
        }
    }

    protected void readCustomNBT(NBTTagCompound root) {
        if (!this.doingOtherNbt) {
            Reader.read(Store.StoreFor.SAVE, root, this);
        }
    }

    public void readContentsFromNBT(NBTTagCompound nbtRoot) {
        Reader.read(Store.StoreFor.ITEM, nbtRoot, this);
    }

    public void writeContentsToNBT(NBTTagCompound nbtRoot) {
        Writer.write(Store.StoreFor.ITEM, nbtRoot, this);
    }

    protected void doUpdate() {
        this.disableTicking();
    }

    protected void disableTicking() {
        if (this.field_145850_b.field_72995_K) {
            notTickingTileEntitiesC.add((TileEntity)this);
        } else {
            notTickingTileEntitiesS.add((TileEntity)this);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        for (TileEntity te : notTickingTileEntitiesS) {
            te.func_145831_w().field_175730_i.remove(te);
        }
        notTickingTileEntitiesS.clear();
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        for (TileEntity te : notTickingTileEntitiesC) {
            te.func_145831_w().field_175730_i.remove(te);
        }
        notTickingTileEntitiesC.clear();
    }

    static {
        MinecraftForge.EVENT_BUS.register(TileEntityEio.class);
    }
}

