/*
 * Decompiled with CFR 0.152.
 */
package com.hancinworld.fw.handler;

import com.hancinworld.fw.FullscreenWindowed;
import java.io.File;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    public static final String CATEGORY_ADVANCED = "advanced";
    private Configuration _configuration;
    private static ConfigurationHandler _instance;
    private Property _enableFullscreenWindowed = null;
    private Property _fullscreenMonitor = null;
    private Property _enableAdvancedFeatures = null;
    private Property _customFullscreenDimensions = null;
    private Property _customFullscreenDimensionsX = null;
    private Property _customFullscreenDimensionsY = null;
    private Property _customFullscreenDimensionsW = null;
    private Property _customFullscreenDimensionsH = null;
    private Property _onlyRemoveDecorations = null;
    private Property _enableMaximumCompatibility = null;
    private boolean _commitImmediately = true;
    private boolean _isInitializing = true;

    private ConfigurationHandler() {
    }

    public static ConfigurationHandler instance() {
        if (_instance == null) {
            _instance = new ConfigurationHandler();
        }
        return _instance;
    }

    public ConfigCategory getConfigurationCategory() {
        return this._configuration.getCategory("general");
    }

    public void init(File suggestedConfigurationFile) {
        if (this._configuration == null) {
            this._configuration = new Configuration(suggestedConfigurationFile);
            this._isInitializing = true;
            this.load();
            this._isInitializing = false;
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        block4: {
            try {
                if (event.getModID().equalsIgnoreCase("fw")) {
                    this.load();
                    if (!this._isInitializing) {
                        FullscreenWindowed.proxy.registerKeyBindings();
                    }
                }
            }
            catch (NoSuchMethodError e) {
                this.load();
                if (this._isInitializing) break block4;
                FullscreenWindowed.proxy.registerKeyBindings();
            }
        }
    }

    public boolean isFullscreenWindowedEnabled() {
        if (this._enableFullscreenWindowed == null) {
            return true;
        }
        return this._enableFullscreenWindowed.getBoolean(true);
    }

    public void setFullscreenWindowedEnabled(boolean value) {
        this._enableFullscreenWindowed.set(value);
        if (this._commitImmediately && this._configuration.hasChanged()) {
            this._configuration.save();
        }
    }

    public int getFullscreenMonitor() {
        if (this._fullscreenMonitor == null) {
            return 0;
        }
        return this._fullscreenMonitor.getInt(0);
    }

    public void setFullscreenMonitor(int value) {
        this._fullscreenMonitor.set(value);
        if (this._commitImmediately && this._configuration.hasChanged()) {
            this._configuration.save();
        }
    }

    public boolean areAdvancedFeaturesEnabled() {
        if (this._enableAdvancedFeatures == null) {
            return false;
        }
        return this._enableAdvancedFeatures.getBoolean(false);
    }

    public void setAdvancedFeaturesEnabled(boolean value) {
        this._enableAdvancedFeatures.set(value);
        if (this._commitImmediately && this._configuration.hasChanged()) {
            this._configuration.save();
        }
    }

    public boolean isOnlyRemoveDecorations() {
        if (this._onlyRemoveDecorations == null) {
            return false;
        }
        return this._onlyRemoveDecorations.getBoolean(false);
    }

    public void setOnlyRemoveDecorations(boolean value) {
        this._onlyRemoveDecorations.set(value);
        if (this._commitImmediately && this._configuration.hasChanged()) {
            this._configuration.save();
        }
    }

    public boolean isCustomFullscreenDimensions() {
        if (this._customFullscreenDimensions == null) {
            return false;
        }
        return this._customFullscreenDimensions.getBoolean(false);
    }

    public void setCustomFullscreenDimensions(boolean value) {
        this._customFullscreenDimensions.set(value);
        if (this._commitImmediately && this._configuration.hasChanged()) {
            this._configuration.save();
        }
    }

    public boolean isMaximumCompatibilityEnabled() {
        if (this._enableMaximumCompatibility == null) {
            return true;
        }
        return this._enableMaximumCompatibility.getBoolean(true);
    }

    public void setEnableMaximumCompatibility(boolean value) {
        this._enableMaximumCompatibility.set(value);
        if (this._commitImmediately && this._configuration.hasChanged()) {
            this._configuration.save();
        }
    }

    public int getCustomFullscreenDimensionsX() {
        if (this._customFullscreenDimensionsX == null) {
            return 0;
        }
        return this._customFullscreenDimensionsX.getInt(0);
    }

    public void setCustomFullscreenDimensionsX(int value) {
        this._customFullscreenDimensionsX.set(value);
        if (this._commitImmediately && this._configuration.hasChanged()) {
            this._configuration.save();
        }
    }

    public int getCustomFullscreenDimensionsY() {
        if (this._customFullscreenDimensionsY == null) {
            return 0;
        }
        return this._customFullscreenDimensionsY.getInt(0);
    }

    public void setCustomFullscreenDimensionsY(int value) {
        this._customFullscreenDimensionsY.set(value);
        if (this._commitImmediately && this._configuration.hasChanged()) {
            this._configuration.save();
        }
    }

    public int getCustomFullscreenDimensionsW() {
        if (this._customFullscreenDimensionsW == null) {
            return 0;
        }
        return this._customFullscreenDimensionsW.getInt(0);
    }

    public void setCustomFullscreenDimensionsW(int value) {
        this._customFullscreenDimensionsW.set(value);
        if (this._commitImmediately && this._configuration.hasChanged()) {
            this._configuration.save();
        }
    }

    public int getCustomFullscreenDimensionsH() {
        if (this._customFullscreenDimensionsH == null) {
            return 0;
        }
        return this._customFullscreenDimensionsH.getInt(0);
    }

    public void setCustomFullscreenDimensionsH(int value) {
        this._customFullscreenDimensionsH.set(value);
        if (this._commitImmediately && this._configuration.hasChanged()) {
            this._configuration.save();
        }
    }

    public boolean isCommitImmediately() {
        return this._commitImmediately;
    }

    public void setCommitImmediately(boolean value) {
        this._commitImmediately = value;
    }

    private void load() {
        this._enableFullscreenWindowed = this._configuration.get("general", "enableFullscreenWindowed", true, I18n.func_135052_a((String)"comment.fullscreenwindowed.enableFullscreenWindowed", (Object[])new Object[0]));
        this._fullscreenMonitor = this._configuration.get("general", "fullscreenMonitor", 0, I18n.func_135052_a((String)"comment.fullscreenwindowed.fullscreenmonitor", (Object[])new Object[0]));
        this._enableAdvancedFeatures = this._configuration.get(CATEGORY_ADVANCED, "enableAdvancedFeatures", false, I18n.func_135052_a((String)"comment.fullscreenwindowed.enableAdvancedFeatures", (Object[])new Object[0]));
        this._enableMaximumCompatibility = this._configuration.get("general", "enableMaximumCompatibility", true, I18n.func_135052_a((String)"comment.fullscreenwindowed.enableMaximumCompatibility", (Object[])new Object[0]));
        this._customFullscreenDimensions = this._configuration.get(CATEGORY_ADVANCED, "customFullscreenDimensions", false, I18n.func_135052_a((String)"comment.fullscreenwindowed.customFullscreenDimensions", (Object[])new Object[0]));
        this._customFullscreenDimensionsX = this._configuration.get(CATEGORY_ADVANCED, "customFullscreenDimensionsX", 0, I18n.func_135052_a((String)"comment.fullscreenwindowed.customFullscreenDimensionsX", (Object[])new Object[0]));
        this._customFullscreenDimensionsY = this._configuration.get(CATEGORY_ADVANCED, "customFullscreenDimensionsY", 0, I18n.func_135052_a((String)"comment.fullscreenwindowed.customFullscreenDimensionsY", (Object[])new Object[0]));
        this._customFullscreenDimensionsW = this._configuration.get(CATEGORY_ADVANCED, "customFullscreenDimensionsW", 0, I18n.func_135052_a((String)"comment.fullscreenwindowed.customFullscreenDimensionsW", (Object[])new Object[0]));
        this._customFullscreenDimensionsH = this._configuration.get(CATEGORY_ADVANCED, "customFullscreenDimensionsH", 0, I18n.func_135052_a((String)"comment.fullscreenwindowed.customFullscreenDimensionsH", (Object[])new Object[0]));
        if (this._configuration.hasChanged()) {
            this._configuration.save();
        }
    }

    public String toString() {
        return this._configuration.toString();
    }
}

