/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part.aspect;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Level;
import org.cyclops.commoncapabilities.api.capability.inventorystate.IInventoryState;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.EnergyHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.part.aspect.build.AspectBuilder;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectValuePropagator;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectWriteActivator;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectWriteDeactivator;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectProperties;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.part.aspect.read.AspectReadBuilders;
import org.cyclops.integrateddynamics.part.aspect.write.AspectWriteBuilders;
import org.cyclops.integratedtunnels.Capabilities;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.IntegratedTunnels;
import org.cyclops.integratedtunnels.api.network.IFluidNetwork;
import org.cyclops.integratedtunnels.api.network.IItemNetwork;
import org.cyclops.integratedtunnels.capability.network.FluidNetworkConfig;
import org.cyclops.integratedtunnels.capability.network.ItemNetworkConfig;
import org.cyclops.integratedtunnels.core.ItemStackPredicate;
import org.cyclops.integratedtunnels.core.TunnelEnergyHelpers;
import org.cyclops.integratedtunnels.core.TunnelFluidHelpers;
import org.cyclops.integratedtunnels.core.TunnelItemHelpers;
import org.cyclops.integratedtunnels.core.part.PartStatePositionedAddon;

public class TunnelAspectWriteBuilders {
    public static <N extends IPositionedAddonsNetwork, T> IAspectWriteActivator createPositionedNetworkAddonActivator(final Function<Void, Capability<N>> networkCapability, final Capability<T> targetCapability) {
        return new IAspectWriteActivator(){

            public <P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>> void onActivate(P partType, PartTarget target, S state) {
                state.addVolatileCapability(targetCapability, state);
                DimPos pos = target.getCenter().getPos();
                INetwork network = NetworkHelpers.getNetwork((IBlockAccess)pos.getWorld(), (BlockPos)pos.getBlockPos());
                if (network != null && network.hasCapability((Capability)networkCapability.apply(null))) {
                    ((PartStatePositionedAddon)state).setPositionedAddonsNetwork((IPositionedAddonsNetwork)network.getCapability((Capability)networkCapability.apply(null)));
                }
            }
        };
    }

    public static <N extends IPositionedAddonsNetwork, T> IAspectWriteDeactivator createPositionedNetworkAddonDeactivator(final Function<Void, Capability<N>> networkCapability, final Capability<T> targetCapability) {
        return new IAspectWriteDeactivator(){

            public <P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>> void onDeactivate(P partType, PartTarget target, S state) {
                state.removeVolatileCapability(targetCapability);
                DimPos pos = target.getCenter().getPos();
                INetwork network = NetworkHelpers.getNetwork((IBlockAccess)pos.getWorld(), (BlockPos)pos.getBlockPos());
                if (network != null && network.hasCapability((Capability)networkCapability.apply(null))) {
                    ((PartStatePositionedAddon)state).setPositionedAddonsNetwork((IPositionedAddonsNetwork)network.getCapability((Capability)networkCapability.apply(null)));
                }
            }
        };
    }

    public static final class Fluid {
        public static final IAspectWriteActivator ACTIVATOR = TunnelAspectWriteBuilders.createPositionedNetworkAddonActivator(new Function<Void, Capability<IFluidNetwork>>(){

            @Nullable
            public Capability<IFluidNetwork> apply(Void input) {
                return FluidNetworkConfig.CAPABILITY;
            }
        }, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        public static final IAspectWriteDeactivator DEACTIVATOR = TunnelAspectWriteBuilders.createPositionedNetworkAddonDeactivator(new Function<Void, Capability<IFluidNetwork>>(){

            @Nullable
            public Capability<IFluidNetwork> apply(Void input) {
                return FluidNetworkConfig.CAPABILITY;
            }
        }, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, Triple<PartTarget, IAspectProperties, Boolean>> BUILDER_BOOLEAN = AspectWriteBuilders.BUILDER_BOOLEAN.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("fluid").handle(AspectWriteBuilders.PROP_GET_BOOLEAN);
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, Triple<PartTarget, IAspectProperties, Integer>> BUILDER_INTEGER = AspectWriteBuilders.BUILDER_INTEGER.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("fluid").handle(AspectWriteBuilders.PROP_GET_INTEGER);
        public static final AspectBuilder<ValueObjectTypeFluidStack.ValueFluidStack, ValueObjectTypeFluidStack, Triple<PartTarget, IAspectProperties, FluidStack>> BUILDER_FLUIDSTACK = AspectWriteBuilders.BUILDER_FLUIDSTACK.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("fluid").handle(AspectWriteBuilders.PROP_GET_FLUIDSTACK);
        public static final AspectBuilder<ValueTypeList.ValueList, ValueTypeList, Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>> BUILDER_LIST = AspectWriteBuilders.BUILDER_LIST.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("fluid");
        public static final AspectBuilder<ValueTypeOperator.ValueOperator, ValueTypeOperator, Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>> BUILDER_OPERATOR = AspectWriteBuilders.BUILDER_OPERATOR.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("fluid");
        public static final Predicate<ValueTypeInteger.ValueInteger> VALIDATOR_INTEGER_MAXRATE = new Predicate<ValueTypeInteger.ValueInteger>(){

            public boolean apply(ValueTypeInteger.ValueInteger input) {
                return input.getRawValue() <= GeneralConfig.fluidRateLimit;
            }
        };
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_RATE = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integratedtunnels.integer.fluid.rate.name", Predicates.and((Predicate)AspectReadBuilders.VALIDATOR_INTEGER_POSITIVE, VALIDATOR_INTEGER_MAXRATE));
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_CHECK_AMOUNT = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.fluid.checkamount.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_CHECK_NBT = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.fluid.checknbt.name");
        public static final IAspectProperties PROPERTIES_RATE = new AspectProperties((Collection)ImmutableList.of(PROP_RATE));
        public static final IAspectProperties PROPERTIES_RATECHECKS = new AspectProperties((Collection)ImmutableList.of(PROP_RATE, PROP_CHECK_AMOUNT, PROP_CHECK_NBT));
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Boolean>, Triple<PartTarget, IAspectProperties, Integer>> PROP_BOOLEAN_GETRATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Integer>, FluidTarget> PROP_INTEGER_FLUIDTARGET;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, FluidStack>, FluidTarget> PROP_FLUIDSTACK_FLUIDTARGET;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>, FluidTarget> PROP_FLUIDSTACKLIST_FLUIDTARGET;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>, FluidTarget> PROP_FLUIDSTACKPREDICATE_FLUIDTARGET;
        public static final IAspectValuePropagator<FluidTarget, Void> PROP_EXPORT;
        public static final IAspectValuePropagator<FluidTarget, Void> PROP_IMPORT;

        static {
            PROPERTIES_RATE.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1000));
            PROPERTIES_RATECHECKS.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1000));
            PROPERTIES_RATECHECKS.setValue(PROP_CHECK_AMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATECHECKS.setValue(PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROP_BOOLEAN_GETRATE = new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Boolean>, Triple<PartTarget, IAspectProperties, Integer>>(){

                public Triple<PartTarget, IAspectProperties, Integer> getOutput(Triple<PartTarget, IAspectProperties, Boolean> input) {
                    return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), (Object)((Boolean)input.getRight() != false ? ((ValueTypeInteger.ValueInteger)((IAspectProperties)input.getMiddle()).getValue(PROP_RATE)).getRawValue() : 0));
                }
            };
            PROP_INTEGER_FLUIDTARGET = new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Integer>, FluidTarget>(){

                public FluidTarget getOutput(Triple<PartTarget, IAspectProperties, Integer> input) {
                    return FluidTarget.of((PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), (Integer)input.getRight(), TunnelFluidHelpers.MATCH_ALL);
                }
            };
            PROP_FLUIDSTACK_FLUIDTARGET = new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, FluidStack>, FluidTarget>(){

                public FluidTarget getOutput(Triple<PartTarget, IAspectProperties, FluidStack> input) {
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    int rate = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                    boolean checkAmount = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_AMOUNT)).getRawValue();
                    boolean checkNbt = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_NBT)).getRawValue();
                    return FluidTarget.of((PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), rate, TunnelFluidHelpers.matchFluidStack((FluidStack)input.getRight(), checkAmount, checkNbt));
                }
            };
            PROP_FLUIDSTACKLIST_FLUIDTARGET = new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>, FluidTarget>(){

                public FluidTarget getOutput(Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList> input) throws EvaluationException {
                    ValueTypeList.ValueList list = (ValueTypeList.ValueList)input.getRight();
                    if (list.getRawValue().getValueType() != ValueTypes.OBJECT_FLUIDSTACK) {
                        throw new EvaluationException(new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalidListValueType", new Object[]{ValueTypes.OBJECT_FLUIDSTACK, list.getRawValue().getValueType()}).localize());
                    }
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    int rate = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                    boolean checkAmount = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_AMOUNT)).getRawValue();
                    boolean checkNbt = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_NBT)).getRawValue();
                    return FluidTarget.of((PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), rate, TunnelFluidHelpers.matchFluidStacks((IValueTypeListProxy<ValueObjectTypeFluidStack, ValueObjectTypeFluidStack.ValueFluidStack>)list.getRawValue(), checkAmount, checkNbt));
                }
            };
            PROP_FLUIDSTACKPREDICATE_FLUIDTARGET = new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>, FluidTarget>(){

                public FluidTarget getOutput(Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator> input) throws EvaluationException {
                    IOperator predicate = ((ValueTypeOperator.ValueOperator)input.getRight()).getRawValue();
                    if (predicate.getInputTypes().length == 1 && ValueHelpers.correspondsTo((IValueType)predicate.getInputTypes()[0], (IValueType)ValueTypes.OBJECT_FLUIDSTACK)) {
                        IAspectProperties properties = (IAspectProperties)input.getMiddle();
                        int rate = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                        return FluidTarget.of((PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), rate, TunnelFluidHelpers.matchPredicate((PartTarget)input.getLeft(), predicate));
                    }
                    String current = ValueTypeOperator.getSignature((IOperator)predicate);
                    String expected = ValueTypeOperator.getSignature((IValueType[])new IValueType[]{ValueTypes.OBJECT_FLUIDSTACK}, (IValueType)ValueTypes.BOOLEAN);
                    throw new EvaluationException(new L10NHelpers.UnlocalizedString("aspect.integrateddynamics.error.invalidType", new Object[]{expected, current}).localize());
                }
            };
            PROP_EXPORT = new IAspectValuePropagator<FluidTarget, Void>(){

                public Void getOutput(FluidTarget input) {
                    if (input.getFluidNetwork() != null && input.getFluidHandler() != null && input.getAmount() != 0) {
                        TunnelFluidHelpers.moveFluids(input.getFluidNetwork(), input.getFluidHandler(), input.getAmount(), true, input.getFluidStackMatcher());
                    }
                    return null;
                }
            };
            PROP_IMPORT = new IAspectValuePropagator<FluidTarget, Void>(){

                public Void getOutput(FluidTarget input) {
                    if (input.getFluidNetwork() != null && input.getFluidHandler() != null && input.getAmount() != 0) {
                        TunnelFluidHelpers.moveFluids(input.getFluidHandler(), input.getFluidNetwork(), input.getAmount(), true, input.getFluidStackMatcher());
                    }
                    return null;
                }
            };
        }

        public static class FluidTarget {
            private final IFluidNetwork fluidNetwork;
            private final IFluidHandler fluidHandler;
            private final int amount;
            private final Predicate<FluidStack> fluidStackMatcher;

            public static FluidTarget of(PartTarget partTarget, IAspectProperties properties, int amount, Predicate<FluidStack> fluidStackMatcher) {
                PartPos center = partTarget.getCenter();
                PartPos target = partTarget.getTarget();
                INetwork network = NetworkHelpers.getNetwork((IBlockAccess)center.getPos().getWorld(), (BlockPos)center.getPos().getBlockPos());
                if (network == null) {
                    IntegratedDynamics.clog((Level)Level.ERROR, (String)"Could not get the fluid network as no network was found.");
                    throw new PartStateException(center.getPos());
                }
                IFluidHandler fluidHandler = (IFluidHandler)TileHelpers.getCapability((DimPos)target.getPos(), (EnumFacing)target.getSide(), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
                return new FluidTarget((IFluidNetwork)network.getCapability(FluidNetworkConfig.CAPABILITY), fluidHandler, amount, fluidStackMatcher);
            }

            public FluidTarget(IFluidNetwork fluidNetwork, IFluidHandler fluidHandler, int amount, Predicate<FluidStack> fluidStackMatcher) {
                this.fluidNetwork = fluidNetwork;
                this.fluidHandler = fluidHandler;
                this.amount = amount;
                this.fluidStackMatcher = fluidStackMatcher;
            }

            public IFluidNetwork getFluidNetwork() {
                return this.fluidNetwork;
            }

            public IFluidHandler getFluidHandler() {
                return this.fluidHandler;
            }

            public int getAmount() {
                return this.amount;
            }

            public Predicate<FluidStack> getFluidStackMatcher() {
                return this.fluidStackMatcher;
            }
        }
    }

    public static final class Item {
        public static final IAspectWriteActivator ACTIVATOR = TunnelAspectWriteBuilders.createPositionedNetworkAddonActivator(new Function<Void, Capability<IItemNetwork>>(){

            @Nullable
            public Capability<IItemNetwork> apply(Void input) {
                return ItemNetworkConfig.CAPABILITY;
            }
        }, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        public static final IAspectWriteDeactivator DEACTIVATOR = TunnelAspectWriteBuilders.createPositionedNetworkAddonDeactivator(new Function<Void, Capability<IItemNetwork>>(){

            @Nullable
            public Capability<IItemNetwork> apply(Void input) {
                return ItemNetworkConfig.CAPABILITY;
            }
        }, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, Triple<PartTarget, IAspectProperties, Boolean>> BUILDER_BOOLEAN = AspectWriteBuilders.BUILDER_BOOLEAN.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("item").handle(AspectWriteBuilders.PROP_GET_BOOLEAN);
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, Triple<PartTarget, IAspectProperties, Integer>> BUILDER_INTEGER = AspectWriteBuilders.BUILDER_INTEGER.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("item").handle(AspectWriteBuilders.PROP_GET_INTEGER);
        public static final AspectBuilder<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack, Triple<PartTarget, IAspectProperties, ItemStack>> BUILDER_ITEMSTACK = AspectWriteBuilders.BUILDER_ITEMSTACK.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("item").handle(AspectWriteBuilders.PROP_GET_ITEMSTACK);
        public static final AspectBuilder<ValueTypeList.ValueList, ValueTypeList, Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>> BUILDER_LIST = AspectWriteBuilders.BUILDER_LIST.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("item");
        public static final AspectBuilder<ValueTypeOperator.ValueOperator, ValueTypeOperator, Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>> BUILDER_OPERATOR = AspectWriteBuilders.BUILDER_OPERATOR.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("item");
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_RATE = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integratedtunnels.integer.item.rate.name");
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_SLOT = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integratedtunnels.integer.item.slot.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_CHECK_STACKSIZE = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.item.checkstacksize.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_CHECK_DAMAGE = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.item.checkdamage.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_CHECK_NBT = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.item.checknbt.name");
        public static final IAspectProperties PROPERTIES_RATESLOT = new AspectProperties((Collection)ImmutableList.of(PROP_RATE, PROP_SLOT));
        public static final IAspectProperties PROPERTIES_SLOT = new AspectProperties((Collection)ImmutableList.of(PROP_SLOT));
        public static final IAspectProperties PROPERTIES_RATESLOTCHECKS = new AspectProperties((Collection)ImmutableList.of(PROP_RATE, PROP_SLOT, PROP_CHECK_STACKSIZE, PROP_CHECK_DAMAGE, PROP_CHECK_NBT));
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Boolean>, Triple<PartTarget, IAspectProperties, Integer>> PROP_BOOLEAN_GETRATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Integer>, ItemTarget> PROP_INTEGER_ITEMTARGET;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ItemStack>, ItemTarget> PROP_ITEMSTACK_ITEMTARGET;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>, ItemTarget> PROP_ITEMSTACKLIST_ITEMTARGET;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>, ItemTarget> PROP_ITEMSTACKPREDICATE_ITEMTARGET;
        public static final IAspectValuePropagator<ItemTarget, Void> PROP_EXPORT;
        public static final IAspectValuePropagator<ItemTarget, Void> PROP_IMPORT;

        static {
            PROPERTIES_RATESLOT.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
            PROPERTIES_RATESLOT.setValue(PROP_SLOT, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_SLOT.setValue(PROP_SLOT, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_SLOT, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_CHECK_STACKSIZE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROP_BOOLEAN_GETRATE = new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Boolean>, Triple<PartTarget, IAspectProperties, Integer>>(){

                public Triple<PartTarget, IAspectProperties, Integer> getOutput(Triple<PartTarget, IAspectProperties, Boolean> input) {
                    return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), (Object)((Boolean)input.getRight() != false ? ((ValueTypeInteger.ValueInteger)((IAspectProperties)input.getMiddle()).getValue(PROP_RATE)).getRawValue() : 0));
                }
            };
            PROP_INTEGER_ITEMTARGET = new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Integer>, ItemTarget>(){

                public ItemTarget getOutput(Triple<PartTarget, IAspectProperties, Integer> input) {
                    return ItemTarget.of((PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), (Integer)input.getRight(), TunnelItemHelpers.MATCH_ALL, (Integer)input.getRight());
                }
            };
            PROP_ITEMSTACK_ITEMTARGET = new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ItemStack>, ItemTarget>(){

                public ItemTarget getOutput(Triple<PartTarget, IAspectProperties, ItemStack> input) {
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    int rate = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                    boolean checkStackSize = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_STACKSIZE)).getRawValue();
                    boolean checkDamage = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_DAMAGE)).getRawValue();
                    boolean checkNbt = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_NBT)).getRawValue();
                    return ItemTarget.of((PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), rate, TunnelItemHelpers.matchItemStack((ItemStack)input.getRight(), checkStackSize, checkDamage, checkNbt), TunnelItemHelpers.getItemStackHashCode((ItemStack)input.getRight()));
                }
            };
            PROP_ITEMSTACKLIST_ITEMTARGET = new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>, ItemTarget>(){

                public ItemTarget getOutput(Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList> input) throws EvaluationException {
                    ValueTypeList.ValueList list = (ValueTypeList.ValueList)input.getRight();
                    if (list.getRawValue().getValueType() != ValueTypes.OBJECT_ITEMSTACK) {
                        throw new EvaluationException(new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalidListValueType", new Object[]{ValueTypes.OBJECT_ITEMSTACK, list.getRawValue().getValueType()}).localize());
                    }
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    int rate = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                    boolean checkStackSize = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_STACKSIZE)).getRawValue();
                    boolean checkDamage = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_DAMAGE)).getRawValue();
                    boolean checkNbt = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_NBT)).getRawValue();
                    return ItemTarget.of((PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), rate, TunnelItemHelpers.matchItemStacks((IValueTypeListProxy<ValueObjectTypeItemStack, ValueObjectTypeItemStack.ValueItemStack>)list.getRawValue(), checkStackSize, checkDamage, checkNbt), list.getRawValue().hashCode());
                }
            };
            PROP_ITEMSTACKPREDICATE_ITEMTARGET = new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>, ItemTarget>(){

                public ItemTarget getOutput(Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator> input) throws EvaluationException {
                    IOperator predicate = ((ValueTypeOperator.ValueOperator)input.getRight()).getRawValue();
                    if (predicate.getInputTypes().length == 1 && ValueHelpers.correspondsTo((IValueType)predicate.getInputTypes()[0], (IValueType)ValueTypes.OBJECT_ITEMSTACK)) {
                        IAspectProperties properties = (IAspectProperties)input.getMiddle();
                        int rate = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                        return ItemTarget.of((PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), rate, TunnelItemHelpers.matchPredicate((PartTarget)input.getLeft(), predicate), predicate.hashCode());
                    }
                    String current = ValueTypeOperator.getSignature((IOperator)predicate);
                    String expected = ValueTypeOperator.getSignature((IValueType[])new IValueType[]{ValueTypes.OBJECT_ITEMSTACK}, (IValueType)ValueTypes.BOOLEAN);
                    throw new EvaluationException(new L10NHelpers.UnlocalizedString("aspect.integrateddynamics.error.invalidType", new Object[]{expected, current}).localize());
                }
            };
            PROP_EXPORT = new IAspectValuePropagator<ItemTarget, Void>(){

                public Void getOutput(ItemTarget input) {
                    if (input.getItemNetwork() != null && input.getItemStorage() != null && input.getAmount() != 0) {
                        TunnelItemHelpers.moveItemsStateOptimized(input.getConnectionHash(), input.getItemNetwork(), input.getInventoryStateNetwork(), -1, input.getItemNetworkSlotless(), input.getItemStorage(), input.getInventoryStateStorage(), input.getSlot(), input.getItemStorageSlotless(), input.getAmount(), input.getItemStackMatcher());
                    }
                    return null;
                }
            };
            PROP_IMPORT = new IAspectValuePropagator<ItemTarget, Void>(){

                public Void getOutput(ItemTarget input) {
                    if (input.getItemNetwork() != null && input.getItemStorage() != null && input.getAmount() != 0) {
                        TunnelItemHelpers.moveItemsStateOptimized(input.getConnectionHash(), input.getItemStorage(), input.getInventoryStateStorage(), input.getSlot(), input.getItemStorageSlotless(), input.getItemNetwork(), input.getInventoryStateNetwork(), -1, input.getItemNetworkSlotless(), input.getAmount(), input.getItemStackMatcher());
                    }
                    return null;
                }
            };
        }

        public static class ItemTarget {
            private final IItemNetwork itemNetwork;
            private final IItemHandler itemStorage;
            private final IInventoryState inventoryStateNetwork;
            private final IInventoryState inventoryStateStorage;
            private final ISlotlessItemHandler itemNetworkSlotless;
            private final ISlotlessItemHandler itemStorageSlotless;
            private final int connectionHash;
            private final int slot;
            private final int amount;
            private final ItemStackPredicate itemStackMatcher;

            public static ItemTarget of(PartTarget partTarget, IAspectProperties properties, int amount, ItemStackPredicate itemStackMatcher, int transferHash) {
                PartPos center = partTarget.getCenter();
                PartPos target = partTarget.getTarget();
                INetwork network = NetworkHelpers.getNetwork((IBlockAccess)center.getPos().getWorld(), (BlockPos)center.getPos().getBlockPos());
                if (network == null) {
                    IntegratedDynamics.clog((Level)Level.ERROR, (String)"Could not get the item network as no network was found.");
                    throw new PartStateException(center.getPos());
                }
                IItemHandler itemHandler = (IItemHandler)TileHelpers.getCapability((DimPos)target.getPos(), (EnumFacing)target.getSide(), (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                int slot = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_SLOT)).getRawValue();
                return new ItemTarget((IItemNetwork)network.getCapability(ItemNetworkConfig.CAPABILITY), itemHandler, network.hasCapability(Capabilities.INVENTORY_STATE) ? (IInventoryState)network.getCapability(Capabilities.INVENTORY_STATE) : null, (IInventoryState)TileHelpers.getCapability((DimPos)target.getPos(), (EnumFacing)target.getSide(), Capabilities.INVENTORY_STATE), network.hasCapability(Capabilities.SLOTLESS_ITEMHANDLER) ? (ISlotlessItemHandler)network.getCapability(Capabilities.SLOTLESS_ITEMHANDLER) : null, (ISlotlessItemHandler)TileHelpers.getCapability((DimPos)target.getPos(), (EnumFacing)target.getSide(), Capabilities.SLOTLESS_ITEMHANDLER), target.hashCode(), slot, amount, itemStackMatcher, transferHash);
            }

            public ItemTarget(IItemNetwork itemNetwork, IItemHandler itemStorage, IInventoryState inventoryStateNetwork, IInventoryState inventoryStateStorage, ISlotlessItemHandler itemNetworkSlotless, ISlotlessItemHandler itemStorageSlotless, int storagePosHash, int slot, int amount, ItemStackPredicate itemStackMatcher, int transferHash) {
                this.itemNetwork = itemNetwork;
                this.itemStorage = itemStorage;
                this.inventoryStateNetwork = inventoryStateNetwork;
                this.inventoryStateStorage = inventoryStateStorage;
                this.itemNetworkSlotless = itemNetworkSlotless;
                this.itemStorageSlotless = itemStorageSlotless;
                this.connectionHash = transferHash << 4 + storagePosHash + itemNetwork.hashCode();
                this.slot = slot;
                this.amount = amount;
                this.itemStackMatcher = itemStackMatcher;
            }

            public IItemNetwork getItemNetwork() {
                return this.itemNetwork;
            }

            public IItemHandler getItemStorage() {
                return this.itemStorage;
            }

            public IInventoryState getInventoryStateNetwork() {
                return this.inventoryStateNetwork;
            }

            public IInventoryState getInventoryStateStorage() {
                return this.inventoryStateStorage;
            }

            public ISlotlessItemHandler getItemNetworkSlotless() {
                return this.itemNetworkSlotless;
            }

            public ISlotlessItemHandler getItemStorageSlotless() {
                return this.itemStorageSlotless;
            }

            public int getConnectionHash() {
                return this.connectionHash;
            }

            public int getSlot() {
                return this.slot;
            }

            public int getAmount() {
                return this.amount;
            }

            public ItemStackPredicate getItemStackMatcher() {
                return this.itemStackMatcher;
            }
        }
    }

    public static final class Energy {
        public static final IAspectWriteActivator ACTIVATOR = TunnelAspectWriteBuilders.createPositionedNetworkAddonActivator(new Function<Void, Capability<IEnergyNetwork>>(){

            @Nullable
            public Capability<IEnergyNetwork> apply(Void input) {
                return Capabilities.NETWORK_ENERGY;
            }
        }, CapabilityEnergy.ENERGY);
        public static final IAspectWriteDeactivator DEACTIVATOR = TunnelAspectWriteBuilders.createPositionedNetworkAddonDeactivator(new Function<Void, Capability<IEnergyNetwork>>(){

            @Nullable
            public Capability<IEnergyNetwork> apply(Void input) {
                return Capabilities.NETWORK_ENERGY;
            }
        }, CapabilityEnergy.ENERGY);
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, Triple<PartTarget, IAspectProperties, Boolean>> BUILDER_BOOLEAN = AspectWriteBuilders.BUILDER_BOOLEAN.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("energy").handle(AspectWriteBuilders.PROP_GET_BOOLEAN);
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, Triple<PartTarget, IAspectProperties, Integer>> BUILDER_INTEGER = AspectWriteBuilders.BUILDER_INTEGER.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("energy").handle(AspectWriteBuilders.PROP_GET_INTEGER);
        public static final Predicate<ValueTypeInteger.ValueInteger> VALIDATOR_INTEGER_MAXRATE = new Predicate<ValueTypeInteger.ValueInteger>(){

            public boolean apply(ValueTypeInteger.ValueInteger input) {
                return input.getRawValue() <= org.cyclops.integrateddynamics.GeneralConfig.energyRateLimit;
            }
        };
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_RATE = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integratedtunnels.integer.energy.rate.name", Predicates.and((Predicate)AspectReadBuilders.VALIDATOR_INTEGER_POSITIVE, VALIDATOR_INTEGER_MAXRATE));
        public static final IAspectProperties PROPERTIES = new AspectProperties((Collection)ImmutableList.of(PROP_RATE));
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Boolean>, Triple<PartTarget, IAspectProperties, Integer>> PROP_GETRATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Integer>, EnergyTarget> PROP_ENERGYTARGET;
        public static final IAspectValuePropagator<EnergyTarget, Void> PROP_EXPORT;
        public static final IAspectValuePropagator<EnergyTarget, Void> PROP_IMPORT;

        static {
            PROPERTIES.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1000));
            PROP_GETRATE = new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Boolean>, Triple<PartTarget, IAspectProperties, Integer>>(){

                public Triple<PartTarget, IAspectProperties, Integer> getOutput(Triple<PartTarget, IAspectProperties, Boolean> input) {
                    return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), (Object)((Boolean)input.getRight() != false ? ((ValueTypeInteger.ValueInteger)((IAspectProperties)input.getMiddle()).getValue(PROP_RATE)).getRawValue() : 0));
                }
            };
            PROP_ENERGYTARGET = new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Integer>, EnergyTarget>(){

                public EnergyTarget getOutput(Triple<PartTarget, IAspectProperties, Integer> input) {
                    PartPos center = ((PartTarget)input.getLeft()).getCenter();
                    PartPos target = ((PartTarget)input.getLeft()).getTarget();
                    INetwork network = NetworkHelpers.getNetwork((IBlockAccess)center.getPos().getWorld(), (BlockPos)center.getPos().getBlockPos());
                    if (network == null) {
                        IntegratedDynamics.clog((Level)Level.ERROR, (String)"Could not get the energy network as no network was found.");
                        throw new PartStateException(center.getPos());
                    }
                    IEnergyStorage energyStorage = EnergyHelpers.getEnergyStorage((PartPos)target);
                    return new EnergyTarget((IEnergyNetwork)network.getCapability(Capabilities.NETWORK_ENERGY), energyStorage, (Integer)input.getRight());
                }
            };
            PROP_EXPORT = new IAspectValuePropagator<EnergyTarget, Void>(){

                public Void getOutput(EnergyTarget input) {
                    if (input.getEnergyNetwork() != null && input.getEnergyStorage() != null && input.getAmount() != 0) {
                        TunnelEnergyHelpers.moveEnergy((IEnergyStorage)input.getEnergyNetwork(), input.getEnergyStorage(), input.getAmount());
                    }
                    return null;
                }
            };
            PROP_IMPORT = new IAspectValuePropagator<EnergyTarget, Void>(){

                public Void getOutput(EnergyTarget input) {
                    if (input.getEnergyNetwork() != null && input.getEnergyStorage() != null && input.getAmount() != 0) {
                        TunnelEnergyHelpers.moveEnergy(input.getEnergyStorage(), (IEnergyStorage)input.getEnergyNetwork(), input.getAmount());
                    }
                    return null;
                }
            };
        }

        public static class EnergyTarget {
            private final IEnergyNetwork energyNetwork;
            private final IEnergyStorage energyStorage;
            private final int amount;

            public EnergyTarget(IEnergyNetwork energyNetwork, IEnergyStorage energyStorage, int amount) {
                this.energyNetwork = energyNetwork;
                this.energyStorage = energyStorage;
                this.amount = amount;
            }

            public IEnergyNetwork getEnergyNetwork() {
                return this.energyNetwork;
            }

            public IEnergyStorage getEnergyStorage() {
                return this.energyStorage;
            }

            public int getAmount() {
                return this.amount;
            }
        }
    }
}

