/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part;

import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.api.network.IFluidNetwork;
import org.cyclops.integratedtunnels.core.part.PartStatePositionedAddon;

public class PartStateFluid<P extends IPartTypeWriter>
extends PartStatePositionedAddon<P, IFluidNetwork>
implements IFluidHandler {
    public PartStateFluid(int inventorySize, boolean canReceive, boolean canExtract) {
        super(inventorySize, canReceive, canExtract);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.getPositionedAddonsNetwork() != null ? ((IFluidNetwork)this.getPositionedAddonsNetwork()).getTankProperties() : new IFluidTankProperties[]{};
    }

    protected FluidStack rateLimitFluid(FluidStack fluidStack) {
        if (fluidStack != null && fluidStack.amount > GeneralConfig.fluidRateLimit) {
            return new FluidStack(fluidStack.getFluid(), GeneralConfig.fluidRateLimit);
        }
        return fluidStack;
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.canReceive() && this.getPositionedAddonsNetwork() != null ? ((IFluidNetwork)this.getPositionedAddonsNetwork()).fill(this.rateLimitFluid(resource), doFill) : 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.canExtract() && this.getPositionedAddonsNetwork() != null ? ((IFluidNetwork)this.getPositionedAddonsNetwork()).drain(this.rateLimitFluid(resource), doDrain) : null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.canExtract() && this.getPositionedAddonsNetwork() != null ? ((IFluidNetwork)this.getPositionedAddonsNetwork()).drain(Math.min(maxDrain, GeneralConfig.fluidRateLimit), doDrain) : null;
    }
}

