/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import com.google.common.base.Objects;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.Level;
import org.cyclops.commoncapabilities.api.capability.inventorystate.IInventoryState;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.IntegratedTunnels;
import org.cyclops.integratedtunnels.core.ItemStackPredicate;

public class TunnelItemHelpers {
    public static final ItemStackPredicate MATCH_ALL = new ItemStackPredicate(null, 0){

        public boolean apply(@Nullable ItemStack input) {
            return true;
        }
    };
    private static final Cache<Integer, Integer> CACHE_INV_STATES = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();
    private static final Cache<Integer, Boolean> CACHE_INV_CHECKS = CacheBuilder.newBuilder().expireAfterWrite((long)(GeneralConfig.inventoryUnchangedTickTimeout * 50), TimeUnit.MILLISECONDS).build();

    public static ItemStack moveItemsSingle(IItemHandler source, int sourceSlot, @Nullable ISlotlessItemHandler sourceSlotless, IItemHandler target, int targetSlot, @Nullable ISlotlessItemHandler targetSlotless, int amount, ItemStackPredicate itemStackMatcher, boolean simulate) {
        block14: {
            boolean loopTargetSlots;
            block15: {
                boolean loopSourceSlots;
                block13: {
                    ItemStack extracted;
                    loopSourceSlots = sourceSlot < 0;
                    boolean bl = loopTargetSlots = targetSlot < 0;
                    if (loopSourceSlots && (sourceSlotless == null || !itemStackMatcher.hasMatchFlags()) || loopTargetSlots && targetSlotless == null) break block13;
                    boolean appliedMatcher = false;
                    if (loopSourceSlots && itemStackMatcher.hasMatchFlags()) {
                        if (itemStackMatcher.getItemStack() == null) {
                            extracted = sourceSlotless.extractItem(amount, simulate);
                            appliedMatcher = true;
                        } else {
                            ItemStack itemStack = itemStackMatcher.getItemStack();
                            if (itemStack != null && itemStack.field_77994_a != amount) {
                                itemStack.field_77994_a = amount;
                            }
                            extracted = sourceSlotless.extractItem(itemStack, itemStackMatcher.getMatchFlags(), simulate);
                            appliedMatcher = true;
                        }
                    } else {
                        extracted = source.extractItem(sourceSlot, amount, simulate);
                    }
                    if (extracted != null && (!simulate || appliedMatcher || itemStackMatcher.apply(extracted))) {
                        ItemStack remaining;
                        ItemStack itemStack = remaining = !loopTargetSlots ? target.insertItem(targetSlot, extracted, simulate) : targetSlotless.insertItem(extracted, simulate);
                        if (remaining == null) {
                            return extracted;
                        }
                        extracted = extracted.func_77946_l();
                        extracted.field_77994_a -= remaining.field_77994_a;
                        if (!simulate) {
                            ItemStack itemStack2 = remaining = loopSourceSlots ? sourceSlotless.insertItem(remaining, false) : source.insertItem(sourceSlot, remaining, false);
                            if (remaining != null) {
                                IntegratedTunnels.clog(Level.WARN, "Just lost stack " + remaining + " while transfering items, report this to the Integrated Tunnels issue tracker with some details about your setup!");
                            }
                        }
                        return extracted.field_77994_a > 0 && (simulate || itemStackMatcher.apply(extracted)) ? extracted : null;
                    }
                    break block14;
                }
                if (!loopSourceSlots) break block15;
                for (sourceSlot = 0; sourceSlot < source.getSlots(); ++sourceSlot) {
                    ItemStack moved;
                    ItemStack movedSimulated;
                    if (loopTargetSlots) {
                        if (source.getStackInSlot(sourceSlot) == null) continue;
                        for (targetSlot = 0; targetSlot < target.getSlots(); ++targetSlot) {
                            if (!simulate && (movedSimulated = TunnelItemHelpers.moveItemsSingle(source, sourceSlot, sourceSlotless, target, targetSlot, targetSlotless, amount, itemStackMatcher, true)) == null || (moved = TunnelItemHelpers.moveItemsSingle(source, sourceSlot, sourceSlotless, target, targetSlot, targetSlotless, amount, itemStackMatcher, simulate)) == null) continue;
                            return moved;
                        }
                        continue;
                    }
                    if (!simulate && (movedSimulated = TunnelItemHelpers.moveItemsSingle(source, sourceSlot, sourceSlotless, target, targetSlot, targetSlotless, amount, itemStackMatcher, true)) == null || (moved = TunnelItemHelpers.moveItemsSingle(source, sourceSlot, sourceSlotless, target, targetSlot, targetSlotless, amount, itemStackMatcher, simulate)) == null) continue;
                    return moved;
                }
                break block14;
            }
            if (!loopTargetSlots) break block14;
            for (targetSlot = 0; targetSlot < target.getSlots(); ++targetSlot) {
                ItemStack moved;
                ItemStack movedSimulated;
                if (!simulate && (movedSimulated = TunnelItemHelpers.moveItemsSingle(source, sourceSlot, sourceSlotless, target, targetSlot, targetSlotless, amount, itemStackMatcher, true)) == null || (moved = TunnelItemHelpers.moveItemsSingle(source, sourceSlot, sourceSlotless, target, targetSlot, targetSlotless, amount, itemStackMatcher, simulate)) == null) continue;
                return moved;
            }
        }
        return null;
    }

    protected static Integer getCachedState(int posHash) {
        return (Integer)CACHE_INV_STATES.getIfPresent((Object)posHash);
    }

    protected static void setCachedState(int posHash, int state) {
        CACHE_INV_STATES.put((Object)posHash, (Object)state);
        CACHE_INV_CHECKS.put((Object)posHash, (Object)true);
    }

    protected static boolean shouldCheckState(int posHash) {
        return CACHE_INV_CHECKS.getIfPresent((Object)posHash) == null;
    }

    protected static void invalidateCachedState(int posHash) {
        CACHE_INV_STATES.invalidate((Object)posHash);
        CACHE_INV_CHECKS.invalidate((Object)posHash);
    }

    public static int getItemStackHashCode(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        return Objects.hashCode((Object[])new Object[]{itemStack.field_77994_a, itemStack.func_77960_j(), Item.func_150891_b((Item)itemStack.func_77973_b()), itemStack.func_77942_o() ? itemStack.func_77978_p() : Integer.valueOf(0)});
    }

    public static int calculateInventoryState(IItemHandler itemHandler, @Nullable IInventoryState inventoryState) {
        if (inventoryState != null) {
            return inventoryState.getHash();
        }
        int hash = itemHandler.hashCode();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            hash += TunnelItemHelpers.getItemStackHashCode(itemHandler.getStackInSlot(i)) + i;
        }
        return hash;
    }

    public static ItemStack moveItems(IItemHandler source, int sourceSlot, @Nullable ISlotlessItemHandler sourceSlotless, IItemHandler target, int targetSlot, @Nullable ISlotlessItemHandler targetSlotless, int amount) {
        ItemStack simulatedTransfer = TunnelItemHelpers.moveItemsSingle(source, sourceSlot, sourceSlotless, target, targetSlot, targetSlotless, amount, MATCH_ALL, true);
        if (simulatedTransfer == null) {
            return null;
        }
        return TunnelItemHelpers.moveItemsSingle(source, sourceSlot, sourceSlotless, target, targetSlot, targetSlotless, simulatedTransfer.field_77994_a, MATCH_ALL, false);
    }

    public static ItemStack moveItemsStateOptimized(int connectionHash, IItemHandler sourceHandler, @Nullable IInventoryState sourceInvState, int sourceSlot, @Nullable ISlotlessItemHandler sourceSlotless, IItemHandler targetHandler, @Nullable IInventoryState targetInvState, int targetSlot, @Nullable ISlotlessItemHandler targetSlotless, int amount, ItemStackPredicate itemStackMatcher) {
        boolean shouldMoveItems;
        Integer cachedState = TunnelItemHelpers.getCachedState(connectionHash);
        boolean calculatedStates = false;
        int currentState = 0;
        boolean bl = shouldMoveItems = cachedState == null;
        if (!shouldMoveItems && TunnelItemHelpers.shouldCheckState(connectionHash)) {
            calculatedStates = true;
            currentState = TunnelItemHelpers.calculateInventoryState(sourceHandler, sourceInvState) + TunnelItemHelpers.calculateInventoryState(targetHandler, targetInvState);
            boolean bl2 = shouldMoveItems = cachedState != currentState;
            if (!shouldMoveItems) {
                CACHE_INV_CHECKS.put((Object)connectionHash, (Object)true);
            }
        }
        if (shouldMoveItems) {
            ItemStack simulatedTransfer = TunnelItemHelpers.moveItemsSingle(sourceHandler, sourceSlot, sourceSlotless, targetHandler, targetSlot, targetSlotless, amount, itemStackMatcher, true);
            if (simulatedTransfer == null) {
                if (!calculatedStates) {
                    currentState = TunnelItemHelpers.calculateInventoryState(sourceHandler, sourceInvState) + TunnelItemHelpers.calculateInventoryState(targetHandler, targetInvState);
                }
                TunnelItemHelpers.setCachedState(connectionHash, currentState);
                return null;
            }
            TunnelItemHelpers.invalidateCachedState(connectionHash);
            return TunnelItemHelpers.moveItemsSingle(sourceHandler, sourceSlot, sourceSlotless, targetHandler, targetSlot, targetSlotless, simulatedTransfer.field_77994_a, itemStackMatcher, false);
        }
        return null;
    }

    public static ItemStackPredicate matchItemStack(final ItemStack itemStack, final boolean checkStackSize, final boolean checkDamage, final boolean checkNbt) {
        int matchFlags = 0;
        if (checkDamage) {
            matchFlags |= 1;
        }
        if (checkNbt) {
            matchFlags |= 2;
        }
        if (checkStackSize) {
            matchFlags |= 4;
        }
        return new ItemStackPredicate(itemStack, matchFlags){

            public boolean apply(@Nullable ItemStack input) {
                return TunnelItemHelpers.areItemStackEqual(input, itemStack, checkStackSize, true, checkDamage, checkNbt);
            }
        };
    }

    public static ItemStackPredicate matchItemStacks(final IValueTypeListProxy<ValueObjectTypeItemStack, ValueObjectTypeItemStack.ValueItemStack> itemStacks, final boolean checkStackSize, final boolean checkDamage, final boolean checkNbt) {
        return new ItemStackPredicate(){

            public boolean apply(@Nullable ItemStack input) {
                for (ValueObjectTypeItemStack.ValueItemStack itemStack : itemStacks) {
                    if (!itemStack.getRawValue().isPresent() || !TunnelItemHelpers.areItemStackEqual(input, (ItemStack)itemStack.getRawValue().get(), checkStackSize, true, checkDamage, checkNbt)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static ItemStackPredicate matchPredicate(final PartTarget partTarget, final IOperator predicate) {
        return new ItemStackPredicate(){

            public boolean apply(@Nullable ItemStack input) {
                ValueObjectTypeItemStack.ValueItemStack valueItemStack = ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)input);
                try {
                    IValue result = ValueHelpers.evaluateOperator((IOperator)predicate, (IValue[])new IValue[]{valueItemStack});
                    return ((ValueTypeBoolean.ValueBoolean)result).getRawValue();
                }
                catch (EvaluationException e) {
                    PartHelpers.PartStateHolder partData = PartHelpers.getPart((PartPos)partTarget.getCenter());
                    if (partData != null) {
                        IPartStateWriter partState = (IPartStateWriter)partData.getState();
                        partState.addError(partState.getActiveAspect(), new L10NHelpers.UnlocalizedString(e.getMessage(), new Object[0]));
                        partState.setDeactivated(true);
                    }
                    return false;
                }
            }
        };
    }

    public static boolean areItemStackEqual(ItemStack stackA, ItemStack stackB, boolean checkStackSize, boolean checkItem, boolean checkDamage, boolean checkNbt) {
        if (stackA == null && stackB == null) {
            return true;
        }
        if (stackA != null && stackB != null) {
            if (checkStackSize && stackA.field_77994_a != stackB.field_77994_a) {
                return false;
            }
            if (checkItem && stackA.func_77973_b() != stackB.func_77973_b()) {
                return false;
            }
            if (checkDamage && stackA.func_77952_i() != stackB.func_77952_i()) {
                return false;
            }
            return !checkNbt || ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
        }
        return false;
    }
}

