/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public class TunnelFluidHelpers {
    public static final Predicate<FluidStack> MATCH_ALL = new Predicate<FluidStack>(){

        public boolean apply(@Nullable FluidStack input) {
            return true;
        }
    };

    @Nullable
    public static FluidStack moveFluids(IFluidHandler source, IFluidHandler target, int maxAmount, boolean doTransfer, Predicate<FluidStack> fluidStackMatcher) {
        ArrayList checkFluids = Lists.newArrayList();
        for (IFluidTankProperties properties : source.getTankProperties()) {
            FluidStack contents = properties.getContents();
            if (contents == null) continue;
            FluidStack toMove = contents.copy();
            toMove.amount = maxAmount;
            if (!fluidStackMatcher.apply((Object)toMove)) continue;
            checkFluids.add(toMove);
        }
        for (FluidStack checkFluid : checkFluids) {
            FluidStack drained;
            int fillableAmount;
            FluidStack drainable = source.drain(checkFluid, false);
            if (drainable == null || drainable.amount <= 0 || (fillableAmount = target.fill(drainable, false)) <= 0 || (drained = source.drain(new FluidStack(drainable.getFluid(), fillableAmount), doTransfer)) == null) continue;
            drained.amount = target.fill(drained, doTransfer);
            return drained;
        }
        return null;
    }

    public static Predicate<FluidStack> matchFluidStack(final FluidStack fluidStack, final boolean checkAmount, final boolean checkNbt) {
        return new Predicate<FluidStack>(){

            public boolean apply(@Nullable FluidStack input) {
                return TunnelFluidHelpers.areFluidStackEqual(input, fluidStack, true, checkAmount, checkNbt);
            }
        };
    }

    public static Predicate<FluidStack> matchFluidStacks(final IValueTypeListProxy<ValueObjectTypeFluidStack, ValueObjectTypeFluidStack.ValueFluidStack> fluidStacks, final boolean checkAmount, final boolean checkNbt) {
        return new Predicate<FluidStack>(){

            public boolean apply(@Nullable FluidStack input) {
                for (ValueObjectTypeFluidStack.ValueFluidStack fluidStack : fluidStacks) {
                    if (!fluidStack.getRawValue().isPresent() || !TunnelFluidHelpers.areFluidStackEqual(input, (FluidStack)fluidStack.getRawValue().get(), true, checkAmount, checkNbt)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<FluidStack> matchPredicate(final PartTarget partTarget, final IOperator predicate) {
        return new Predicate<FluidStack>(){

            public boolean apply(@Nullable FluidStack input) {
                ValueObjectTypeFluidStack.ValueFluidStack valueFluidStack = ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)input);
                try {
                    IValue result = ValueHelpers.evaluateOperator((IOperator)predicate, (IValue[])new IValue[]{valueFluidStack});
                    return ((ValueTypeBoolean.ValueBoolean)result).getRawValue();
                }
                catch (EvaluationException e) {
                    PartHelpers.PartStateHolder partData = PartHelpers.getPart((PartPos)partTarget.getCenter());
                    if (partData != null) {
                        IPartStateWriter partState = (IPartStateWriter)partData.getState();
                        partState.addError(partState.getActiveAspect(), new L10NHelpers.UnlocalizedString(e.getMessage(), new Object[0]));
                        partState.setDeactivated(true);
                    }
                    return false;
                }
            }
        };
    }

    public static boolean areFluidStackEqual(FluidStack stackA, FluidStack stackB, boolean checkFluid, boolean checkAmount, boolean checkNbt) {
        if (stackA == null && stackB == null) {
            return true;
        }
        if (stackA != null && stackB != null) {
            if (checkAmount && stackA.amount != stackB.amount) {
                return false;
            }
            if (checkFluid && stackA.getFluid() != stackB.getFluid()) {
                return false;
            }
            return !checkNbt || FluidStack.areFluidStackTagsEqual((FluidStack)stackA, (FluidStack)stackB);
        }
        return false;
    }
}

