/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import org.apache.commons.io.FilenameUtils;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.client.model.DummyModel;
import slimeknights.tconstruct.library.client.model.MaterialModel;
import slimeknights.tconstruct.library.client.model.MaterialModelLoader;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.library.client.model.ModifierModel;
import slimeknights.tconstruct.library.client.model.ModifierModelLoader;
import slimeknights.tconstruct.library.client.model.ToolModel;
import slimeknights.tconstruct.library.client.model.format.AmmoPosition;
import slimeknights.tconstruct.library.client.model.format.ToolModelOverride;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolCore;

public class ToolModelLoader
implements ICustomModelLoader {
    public static String EXTENSION = ".tcon";
    private static final Map<ResourceLocation, ToolCore> modelItemMap = Maps.newHashMap();

    public static void addPartMapping(ResourceLocation resourceLocation, ToolCore tool) {
        modelItemMap.put(resourceLocation, tool);
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return modelLocation.func_110623_a().endsWith(EXTENSION);
    }

    public IModel loadModel(ResourceLocation modelLocation) {
        if (!Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION)) {
            return DummyModel.INSTANCE;
        }
        try {
            Map<String, String> textures = ModelHelper.loadTexturesFromJson(modelLocation);
            ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms = ModelHelper.loadTransformFromJson(modelLocation);
            ImmutableList<ToolModelOverride> overrides = ModelHelper.loadToolModelOverridesFromJson(modelLocation);
            AmmoPosition ammoPosition = ModelHelper.loadAmmoPositionFromJson(modelLocation);
            Float[] rotations = ModelHelper.loadLayerRotations(modelLocation);
            if (rotations.length > 0 && textures.size() != rotations.length) {
                TinkerRegistry.log.error("Toolmodel {} has invalid layerrotation entry: Size should be {} but is {}; Skipping rotations.", new Object[]{modelLocation, textures.size(), rotations.length});
                rotations = new Float[]{};
            }
            ImmutableList.Builder defaultTextureListBuilder = ImmutableList.builder();
            ArrayList parts = Lists.newArrayList();
            ArrayList brokenParts = Lists.newArrayList();
            ToolCore toolCore = modelItemMap.get(MaterialModelLoader.getReducedPath(modelLocation));
            for (Map.Entry<String, String> entry : textures.entrySet()) {
                String name = entry.getKey();
                try {
                    ArrayList listToAdd;
                    int i;
                    if (name.startsWith("layer")) {
                        i = Integer.valueOf(name.substring(5));
                        listToAdd = parts;
                    } else if (name.startsWith("broken")) {
                        i = Integer.valueOf(name.substring(6));
                        listToAdd = brokenParts;
                    } else {
                        TinkerRegistry.log.warn("Toolmodel {} has invalid texture entry {}; Skipping layer.", new Object[]{modelLocation, name});
                        continue;
                    }
                    ResourceLocation location = new ResourceLocation(entry.getValue());
                    MaterialModel partModel = new MaterialModel((ImmutableList<ResourceLocation>)ImmutableList.of((Object)location));
                    while (listToAdd.size() <= i) {
                        listToAdd.add(null);
                    }
                    listToAdd.set(i, partModel);
                    defaultTextureListBuilder.add((Object)location);
                    this.registerCustomTextures(i, location, toolCore);
                }
                catch (NumberFormatException e) {
                    TinkerRegistry.log.error("Toolmodel {} has invalid texture entry {}; Skipping layer.", new Object[]{modelLocation, name});
                }
            }
            for (ToolModelOverride override : overrides) {
                for (Map.Entry entry : override.textures.entrySet()) {
                    String name = (String)entry.getKey();
                    try {
                        TIntObjectHashMap<MaterialModel> mapToAdd;
                        int i;
                        if (name.startsWith("layer")) {
                            i = Integer.valueOf(name.substring(5));
                            mapToAdd = override.partModelReplacement;
                        } else if (name.startsWith("broken")) {
                            i = Integer.valueOf(name.substring(6));
                            mapToAdd = override.brokenPartModelReplacement;
                        } else {
                            TinkerRegistry.log.warn("Toolmodel {} has invalid texture override entry {}; Skipping layer.", new Object[]{modelLocation, name});
                            continue;
                        }
                        ResourceLocation location = new ResourceLocation((String)entry.getValue());
                        MaterialModel partModel = new MaterialModel((ImmutableList<ResourceLocation>)ImmutableList.of((Object)location));
                        mapToAdd.put(i, (Object)partModel);
                        this.registerCustomTextures(i, location, toolCore);
                    }
                    catch (NumberFormatException e) {
                        TinkerRegistry.log.error("Toolmodel {} has invalid texture entry {}; Skipping layer.", new Object[]{modelLocation, name});
                    }
                }
            }
            String toolName = FilenameUtils.getBaseName((String)modelLocation.func_110623_a());
            ModifierModel modifiers = null;
            try {
                IModel mods = ModelLoaderRegistry.getModel((ResourceLocation)ModifierModelLoader.getLocationForToolModifiers(toolName));
                if (mods == null || !(mods instanceof ModifierModel)) {
                    TinkerRegistry.log.trace("Toolmodel {} does not have any modifiers associated with it. Be sure that the Tools internal name, the Toolmodels filename and the name used inside the Modifier Model Definition match!", new Object[]{modelLocation});
                } else {
                    modifiers = (ModifierModel)mods;
                    for (ToolModelOverride toolModelOverride : overrides) {
                        String modifierName;
                        IModel extraModel;
                        if (toolModelOverride.modifierSuffix == null || !((extraModel = ModelLoaderRegistry.getModel((ResourceLocation)ModifierModelLoader.getLocationForToolModifiers(modifierName = toolName + toolModelOverride.modifierSuffix))) instanceof ModifierModel)) continue;
                        ModifierModel overriddenModifierModel = new ModifierModel();
                        for (Map.Entry<String, String> entry : modifiers.getModels().entrySet()) {
                            overriddenModifierModel.addModelForModifier(entry.getKey(), entry.getValue());
                        }
                        for (Map.Entry<String, String> entry : ((ModifierModel)extraModel).getModels().entrySet()) {
                            overriddenModifierModel.addModelForModifier(entry.getKey(), entry.getValue());
                        }
                        toolModelOverride.overrideModifierModel = overriddenModifierModel;
                    }
                }
            }
            catch (Exception e) {
                TinkerRegistry.log.error((Object)e);
                modifiers = null;
            }
            return new ToolModel((ImmutableList<ResourceLocation>)defaultTextureListBuilder.build(), parts, brokenParts, rotations, modifiers, transforms, overrides, ammoPosition);
        }
        catch (IOException e) {
            TinkerRegistry.log.error("Could not load multimodel {}", new Object[]{modelLocation.toString()});
            return ModelLoaderRegistry.getMissingModel();
        }
    }

    private void registerCustomTextures(int i, ResourceLocation resourceLocation, ToolCore toolCore) {
        if (toolCore == null) {
            CustomTextureCreator.registerTexture(resourceLocation);
        } else {
            for (IToolPart part : toolCore.getRequiredComponents().get(i).getPossibleParts()) {
                CustomTextureCreator.registerTextureForPart(resourceLocation, part);
            }
        }
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
    }
}

